/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.server.session;

import com.litongjava.tio.http.common.Cookie;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.server.session.SessionCookieDecorator;
import com.litongjava.tio.utils.hutool.ReUtil;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainMappingSessionCookieDecorator
implements SessionCookieDecorator {
    private static Logger log = LoggerFactory.getLogger(DomainMappingSessionCookieDecorator.class);
    private Map<String, String> domainMap = null;

    public DomainMappingSessionCookieDecorator(Map<String, String> domainMap) {
        this.domainMap = domainMap;
    }

    protected DomainMappingSessionCookieDecorator() {
    }

    public void addMapping(String key, String value) {
        this.domainMap.put(key, value);
    }

    public void removeMapping(String key) {
        this.domainMap.remove(key);
    }

    @Override
    public void decorate(Cookie sessionCookie, HttpRequest request, String domain) {
        Set<Map.Entry<String, String>> set = this.domainMap.entrySet();
        String initDomain = sessionCookie.getDomain();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (!StrUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)initDomain) && !ReUtil.isMatch((String)key, (String)initDomain)) continue;
            sessionCookie.setDomain(value);
        }
    }

    public static void main(String[] args) {
        boolean ss = ReUtil.isMatch((String)"(.)*(.tiocloud.com){1}", (String)".tiocloud.com");
        System.out.println(ss);
        ss = ReUtil.isMatch((String)"(.)*(.tiocloud.com){1}", (String)"www.tiocloud.com");
        System.out.println(ss);
        ss = ReUtil.isMatch((String)"(.)*(.tiocloud.com){1}", (String)"www.xx.tiocloud.com");
        System.out.println(ss);
    }
}

