/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.server;

import com.litongjava.aio.Packet;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.exception.TioDecodeException;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpRequestDecoder;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.HttpResponseEncoder;
import com.litongjava.tio.http.common.handler.ITioHttpRequestHandler;
import com.litongjava.tio.server.intf.ServerAioHandler;
import java.nio.ByteBuffer;

public class HttpServerAioHandler
implements ServerAioHandler {
    public static final String REQUEST_KEY = "tio_request_key";
    protected HttpConfig httpConfig;
    private ITioHttpRequestHandler requestHandler;

    public HttpServerAioHandler(HttpConfig httpConfig, ITioHttpRequestHandler requestHandler) {
        this.httpConfig = httpConfig;
        this.requestHandler = requestHandler;
    }

    public HttpRequest decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext) throws TioDecodeException {
        HttpRequest request = HttpRequestDecoder.decode((ByteBuffer)buffer, (int)limit, (int)position, (int)readableLength, (ChannelContext)channelContext, (HttpConfig)this.httpConfig);
        if (request != null) {
            channelContext.setAttribute(REQUEST_KEY, (Object)request);
        }
        return request;
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext channelContext) {
        HttpResponse httpResponse = (HttpResponse)packet;
        return HttpResponseEncoder.encode((HttpResponse)httpResponse, (TioConfig)tioConfig, (ChannelContext)channelContext);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public void handler(Packet packet, ChannelContext channelContext) throws Exception {
        HttpRequest request = (HttpRequest)packet;
        String ip = request.getClientIp();
        if (channelContext.tioConfig.ipBlacklist != null && channelContext.tioConfig.ipBlacklist.isInBlacklist(ip)) {
            HttpResponse httpResponse = request.httpConfig.getRespForBlackIp();
            if (httpResponse != null) {
                if (httpResponse.isBlockSend()) {
                    Tio.bSend((ChannelContext)channelContext, (Packet)httpResponse);
                } else {
                    Tio.send((ChannelContext)channelContext, (Packet)httpResponse);
                }
                return;
            }
            Tio.remove((ChannelContext)channelContext, (String)(ip + "in the blacklist"));
            return;
        }
        HttpResponse httpResponse = this.requestHandler.handler(request);
        if (httpResponse != null && httpResponse.isSend()) {
            Tio.send((ChannelContext)channelContext, (Packet)httpResponse);
        }
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }
}

