/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.common.view.freemarker;

import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.view.ModelGenerator;
import com.litongjava.tio.http.common.view.freemarker.ConfigurationCreater;
import com.litongjava.tio.utils.freemarker.ShortMessageTemplateExceptionHandler;
import freemarker.template.Configuration;
import freemarker.template.TemplateExceptionHandler;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FreemarkerConfig {
    private Configuration configuration;
    private HttpConfig httpConfig;
    private volatile Map<String, Configuration> domainConfMap = null;
    private ModelGenerator modelGenerator;
    private String[] suffixes = null;
    private ConfigurationCreater configurationCreater;

    public FreemarkerConfig(HttpConfig httpConfig, ModelGenerator modelGenerator, String[] suffixes, ConfigurationCreater configurationCreater, String charset) throws IOException {
        this.configurationCreater = configurationCreater;
        String pageRoot = httpConfig.getPageRoot();
        if (pageRoot == null) {
            throw new IOException("\u6ca1\u6709\u914d\u7f6epageRoot");
        }
        httpConfig.setFreemarkerConfig(this);
        this.httpConfig = httpConfig;
        this.modelGenerator = modelGenerator;
        this.setSuffixes(suffixes);
        this.configuration = this.createConfiguration(httpConfig, pageRoot, charset);
        Map<String, String> domainPageMap = httpConfig.getDomainPageMap();
        if (domainPageMap != null && domainPageMap.size() > 0) {
            Set<Map.Entry<String, String>> set = domainPageMap.entrySet();
            for (Map.Entry<String, String> entry : set) {
                String domain = entry.getKey();
                String file = entry.getValue();
                this.addDomainConfiguration(domain, file, charset);
            }
        }
    }

    private Configuration createConfiguration(HttpConfig httpConfig, String root, String charset) throws IOException {
        if (httpConfig.getPageRoot() == null) {
            return null;
        }
        if (this.configurationCreater != null) {
            return this.configurationCreater.createConfiguration(httpConfig, root);
        }
        Configuration cfg = new Configuration(Configuration.getVersion());
        if (httpConfig.isPageInClasspath()) {
            cfg.setClassForTemplateLoading(this.getClass(), "/" + root);
        } else {
            cfg.setDirectoryForTemplateLoading(new File(root));
        }
        cfg.setDefaultEncoding(charset);
        cfg.setLogTemplateExceptions(false);
        cfg.setWrapUncheckedExceptions(true);
        cfg.setTemplateExceptionHandler((TemplateExceptionHandler)ShortMessageTemplateExceptionHandler.me);
        cfg.setLocale(Locale.SIMPLIFIED_CHINESE);
        cfg.setNumberFormat("#");
        return cfg;
    }

    public Configuration getConfiguration(HttpRequest request) {
        if (this.domainConfMap == null || this.domainConfMap.size() == 0) {
            return this.configuration;
        }
        String domain = request.getDomain();
        Configuration root = this.domainConfMap.get(domain);
        if (root != null) {
            return root;
        }
        Set<Map.Entry<String, Configuration>> set = this.domainConfMap.entrySet();
        for (Map.Entry<String, Configuration> entry : set) {
            String d = entry.getKey();
            if (!d.startsWith(".") || !domain.endsWith(d)) continue;
            Configuration cfg = entry.getValue();
            this.domainConfMap.put(domain, cfg);
            return cfg;
        }
        this.domainConfMap.put(domain, this.configuration);
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDomainConfiguration(String domain, String pageRoot, String charset) throws IOException {
        if (this.domainConfMap == null) {
            FreemarkerConfig freemarkerConfig = this;
            synchronized (freemarkerConfig) {
                if (this.domainConfMap == null) {
                    this.domainConfMap = new HashMap<String, Configuration>();
                }
            }
        }
        Configuration configuration = this.createConfiguration(this.httpConfig, pageRoot, charset);
        this.domainConfMap.put(domain, configuration);
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public ModelGenerator getModelGenerator() {
        return this.modelGenerator;
    }

    public void setModelGenerator(ModelGenerator modelGenerator) {
        this.modelGenerator = modelGenerator;
    }

    private FreemarkerConfig() {
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }

    public void setSuffixes(String[] suffixes) {
        this.suffixes = suffixes;
    }
}

