/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.common.utils;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpIpUtils {
    private static Logger log = LoggerFactory.getLogger(HttpIpUtils.class);
    private static final String[] HEADER_NAMES_FOR_REALIP = new String[]{"x-forwarded-for", "proxy-client-ip", "wl-proxy-client-ip", "x-real-ip"};

    public static String getRealIp(HttpRequest request) {
        String name;
        if (request.httpConfig == null) {
            return request.getRemote().getIp();
        }
        String headerName = null;
        String ip = null;
        String[] stringArray = HEADER_NAMES_FOR_REALIP;
        int n = stringArray.length;
        for (int i = 0; i < n && (!StrUtil.isNotBlank((CharSequence)(ip = request.getHeader(headerName = (name = stringArray[i])))) || "unknown".equalsIgnoreCase(ip)); ++i) {
        }
        if (StrUtil.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
            headerName = null;
            ip = request.getRemote().getIp();
        }
        if (ip.contains(",")) {
            ip = ip.split(",")[0].trim();
        }
        if (StrUtil.isBlank((String)ip)) {
            ip = request.getRemote().getIp();
        }
        return ip;
    }

    public static String getRealIp(ChannelContext channelContext, HttpConfig httpConfig, Map<String, String> httpHeaders) {
        if (httpConfig == null) {
            return channelContext.getClientNode().getIp();
        }
        if (httpConfig.isProxied()) {
            String name;
            String headerName = null;
            String ip = null;
            String[] stringArray = HEADER_NAMES_FOR_REALIP;
            int n = stringArray.length;
            for (int i = 0; i < n && (!StrUtil.isNotBlank((CharSequence)(ip = httpHeaders.get(headerName = (name = stringArray[i])))) || "unknown".equalsIgnoreCase(ip)); ++i) {
            }
            if (StrUtil.isBlank(ip) || "unknown".equalsIgnoreCase(ip)) {
                headerName = null;
                ip = channelContext.getClientNode().getIp();
            }
            if (ip.contains(",")) {
                if (log.isInfoEnabled()) {
                    log.info("ip[{}], header name:{}", (Object)ip, (Object)headerName);
                }
                ip = ip.split(",")[0].trim();
            }
            return ip;
        }
        return channelContext.getClientNode().getIp();
    }

    public static boolean isIp(String str) {
        if (str.length() < 7 || str.length() > 15 || "".equals(str)) {
            return false;
        }
        String rexp = "([1-9]|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])(\\.(\\d|[1-9]\\d|1\\d{2}|2[0-4]\\d|25[0-5])){3}";
        Pattern pat = Pattern.compile(rexp);
        Matcher mat = pat.matcher(str);
        boolean ipAddress = mat.find();
        return ipAddress;
    }
}

