/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.common.utils;

import com.litongjava.tio.http.common.HeaderName;
import com.litongjava.tio.http.common.HeaderValue;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.utils.hutool.ZipUtil;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGzipUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpGzipUtils.class);

    public static void gzip(HttpRequest request, HttpResponse response) {
        boolean isBinary;
        if (response == null) {
            return;
        }
        if (response.isSkipGzipped()) {
            return;
        }
        HeaderValue ct = response.getContentType();
        String mime = ct != null ? ct.getValue().toLowerCase(Locale.ROOT) : "";
        boolean bl = isBinary = mime.startsWith("image/") || mime.startsWith("video/") || mime.startsWith("audio/");
        if (isBinary) {
            return;
        }
        if (request != null && request.getIsSupportGzip().booleanValue()) {
            HttpGzipUtils.justGzip(response);
        } else if (request != null) {
            log.warn("not support gzip:{}, {}", (Object)request.getClientIp(), (Object)request.getHeader("user-agent"));
        }
    }

    public static void gzip(HttpResponse response) {
        boolean isBinary;
        if (response == null) {
            return;
        }
        if (response.isSkipGzipped()) {
            return;
        }
        HeaderValue ct = response.getContentType();
        String mime = ct != null ? ct.getValue().toLowerCase(Locale.ROOT) : "";
        boolean bl = isBinary = mime.startsWith("image/") || mime.startsWith("video/") || mime.startsWith("audio/");
        if (isBinary) {
            return;
        }
        HttpGzipUtils.justGzip(response);
    }

    public static void justGzip(HttpResponse response) {
        byte[] bs2;
        byte[] bs = response.getBody();
        if (bs != null && bs.length >= 300 && (bs2 = ZipUtil.gzip((byte[])bs)).length < bs.length) {
            response.setBody(bs2);
            response.setSkipGzipped(true);
            response.addHeader(HeaderName.Content_Encoding, HeaderValue.Content_Encoding.gzip);
        }
    }
}

