/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.common.stream;

import com.litongjava.aio.BytePacket;
import com.litongjava.aio.Packet;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.http.common.encoder.ChunkEncoder;
import com.litongjava.tio.http.common.sse.ChunkedPacket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TioOutputStream
extends OutputStream {
    private final ChannelContext ctx;
    private final boolean chunked;
    private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

    public TioOutputStream(ChannelContext ctx, boolean chunked) {
        this.ctx = ctx;
        this.chunked = chunked;
    }

    @Override
    public void write(int b) throws IOException {
        this.baos.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.baos.write(b, off, len);
    }

    @Override
    public void flush() throws IOException {
        byte[] data = this.baos.toByteArray();
        if (data.length > 0) {
            if (this.chunked) {
                byte[] chunk = ChunkEncoder.encodeChunk(data);
                Tio.bSend((ChannelContext)this.ctx, (Packet)new ChunkedPacket(chunk));
            } else {
                Tio.bSend((ChannelContext)this.ctx, (Packet)new BytePacket(data));
            }
            this.baos.reset();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.chunked) {
            byte[] endChunk = ChunkEncoder.encodeChunk(new byte[0]);
            Tio.bSend((ChannelContext)this.ctx, (Packet)new ChunkedPacket(endChunk));
        }
        Tio.close((ChannelContext)this.ctx, (String)"close");
    }
}

