/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.common;

import com.litongjava.model.sys.SysConst;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.http.common.Cookie;
import com.litongjava.tio.http.common.HeaderName;
import com.litongjava.tio.http.common.HeaderValue;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.HttpResponseStatus;
import com.litongjava.tio.http.common.utils.HttpDateTimer;
import com.litongjava.tio.http.common.utils.HttpGzipUtils;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponseEncoder {
    private static final Logger log = LoggerFactory.getLogger(HttpResponseEncoder.class);
    public static final int MAX_HEADER_LENGTH = 20480;
    public static final int HEADER_SERVER_LENGTH = HeaderName.Server.bytes.length + HeaderValue.Server.TIO.bytes.length + 3;
    public static final int HEADER_DATE_LENGTH_1 = HeaderName.Date.bytes.length + 3;
    public static final int HEADER_FIXED_LENGTH = HEADER_SERVER_LENGTH + HEADER_DATE_LENGTH_1;
    private static boolean showServer = EnvUtils.getBoolean((String)"http.response.header.showServer", (boolean)true);

    public static ByteBuffer encode(HttpResponse httpResponse, TioConfig tioConfig, ChannelContext channelContext) {
        boolean isNotAddContentLength;
        String jsonp;
        File fileBody = httpResponse.getFileBody();
        if (fileBody != null) {
            long length = fileBody.length();
            return HttpResponseEncoder.buildHeader(httpResponse, length);
        }
        int bodyLength = 0;
        byte[] body = httpResponse.body;
        byte[] jsonpBytes = null;
        HttpRequest httpRequest = httpResponse.getHttpRequest();
        if (httpRequest != null && StrUtil.isNotBlank((CharSequence)(jsonp = httpRequest.getParam(httpRequest.httpConfig.getJsonpParamName())))) {
            try {
                jsonpBytes = jsonp.getBytes(httpRequest.getCharset());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (body == null) {
                body = SysConst.NULL;
            }
            byte[] bodyBs = new byte[jsonpBytes.length + 1 + body.length + 1];
            System.arraycopy(jsonpBytes, 0, bodyBs, 0, jsonpBytes.length);
            bodyBs[jsonpBytes.length] = 40;
            System.arraycopy(body, 0, bodyBs, jsonpBytes.length + 1, body.length);
            bodyBs[bodyBs.length - 1] = 41;
            body = bodyBs;
            httpResponse.setBody(bodyBs);
        }
        if (body != null) {
            try {
                HttpGzipUtils.gzip(httpRequest, httpResponse);
                body = httpResponse.body;
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
            bodyLength = body.length;
        }
        HttpResponseStatus httpResponseStatus = httpResponse.getStatus();
        int respLineLength = httpResponseStatus.responseLineBinary.length;
        Map<HeaderName, HeaderValue> headers = httpResponse.getHeaders();
        boolean bl = isNotAddContentLength = httpResponse.isStream() || !httpResponse.isSkipAddContentLength();
        if (!isNotAddContentLength) {
            httpResponse.addHeader(HeaderName.Content_Length, HeaderValue.from(Integer.toString(bodyLength)));
        }
        int headerLength = httpResponse.getHeaderByteCount();
        if (httpResponse.getCookies() != null) {
            for (Cookie cookie : httpResponse.getCookies()) {
                byte[] bs;
                headerLength += HeaderName.SET_COOKIE.bytes.length;
                try {
                    bs = cookie.toString().getBytes(httpResponse.getCharset());
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                cookie.setBytes(bs);
                headerLength += bs.length;
            }
            headerLength += httpResponse.getCookies().size() * 3;
        }
        HeaderValue httpDateValue = HttpDateTimer.httpDateValue;
        ByteBuffer buffer = ByteBuffer.allocate(respLineLength + (headerLength += HEADER_FIXED_LENGTH + httpDateValue.bytes.length) + bodyLength);
        buffer.put(httpResponseStatus.responseLineBinary);
        if (showServer) {
            buffer.put(HeaderName.Server.bytes);
            buffer.put((byte)58);
            buffer.put(HeaderValue.Server.TIO.bytes);
            buffer.put(SysConst.CR_LF);
        }
        buffer.put(HeaderName.Date.bytes);
        buffer.put((byte)58);
        buffer.put(httpDateValue.bytes);
        buffer.put(SysConst.CR_LF);
        Set<Map.Entry<HeaderName, HeaderValue>> headerSet = headers.entrySet();
        for (Map.Entry<HeaderName, HeaderValue> entry : headerSet) {
            buffer.put(entry.getKey().bytes);
            buffer.put((byte)58);
            buffer.put(entry.getValue().bytes);
            buffer.put(SysConst.CR_LF);
        }
        if (httpResponse.getCookies() != null) {
            for (Cookie cookie : httpResponse.getCookies()) {
                buffer.put(HeaderName.SET_COOKIE.bytes);
                buffer.put((byte)58);
                buffer.put(cookie.getBytes());
                buffer.put(SysConst.CR_LF);
            }
        }
        buffer.put(SysConst.CR_LF);
        if (bodyLength > 0) {
            buffer.put(body);
        }
        buffer.flip();
        return buffer;
    }

    private static ByteBuffer buildHeader(HttpResponse httpResponse, long contentLength) {
        boolean isNotAddContentLength;
        HttpResponseStatus status = httpResponse.getStatus();
        byte[] httpLine = status.responseLineBinary;
        Map<HeaderName, HeaderValue> headers = httpResponse.getHeaders();
        HeaderValue dateValue = HttpDateTimer.httpDateValue;
        byte[] lengthBytes = null;
        try {
            lengthBytes = String.valueOf(contentLength).getBytes(httpResponse.getCharset());
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        int headerLen = 0;
        headerLen += httpLine.length;
        if (showServer) {
            headerLen += HEADER_SERVER_LENGTH;
        }
        headerLen += HEADER_DATE_LENGTH_1 + dateValue.bytes.length;
        headerLen += HeaderName.Content_Length.bytes.length + 1 + lengthBytes.length + 2;
        for (Map.Entry<HeaderName, HeaderValue> e : headers.entrySet()) {
            headerLen += e.getKey().bytes.length + 1 + e.getValue().bytes.length + 2;
        }
        if (httpResponse.getCookies() != null) {
            for (Cookie c : httpResponse.getCookies()) {
                byte[] cbytes = c.getBytes();
                headerLen += HeaderName.SET_COOKIE.bytes.length + 1 + cbytes.length + 2;
            }
        }
        ByteBuffer buf = ByteBuffer.allocate(headerLen += 2);
        buf.put(httpLine);
        if (showServer) {
            buf.put(HeaderName.Server.bytes).put((byte)58).put(HeaderValue.Server.TIO.bytes).put(SysConst.CR_LF);
        }
        buf.put(HeaderName.Date.bytes).put((byte)58).put(dateValue.bytes).put(SysConst.CR_LF);
        boolean bl = isNotAddContentLength = httpResponse.isStream() || !httpResponse.isSkipAddContentLength();
        if (!isNotAddContentLength) {
            buf.put(HeaderName.Content_Length.bytes).put((byte)58).put(lengthBytes).put(SysConst.CR_LF);
        }
        for (Map.Entry<HeaderName, HeaderValue> e : headers.entrySet()) {
            buf.put(e.getKey().bytes).put((byte)58).put(e.getValue().bytes).put(SysConst.CR_LF);
        }
        if (httpResponse.getCookies() != null) {
            for (Cookie c : httpResponse.getCookies()) {
                buf.put(HeaderName.SET_COOKIE.bytes).put((byte)58).put(c.getBytes()).put(SysConst.CR_LF);
            }
        }
        buf.put(SysConst.CR_LF);
        buf.flip();
        return buf;
    }
}

