/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.common;

import com.litongjava.aio.Packet;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.http.common.Cookie;
import com.litongjava.tio.http.common.HeaderName;
import com.litongjava.tio.http.common.HeaderValue;
import com.litongjava.tio.http.common.HttpPacket;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponseStatus;
import com.litongjava.tio.http.common.stream.TioOutputStream;
import com.litongjava.tio.http.common.utils.HttpGzipUtils;
import com.litongjava.tio.http.common.utils.MimeTypeUtils;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.ClassUtil;
import com.litongjava.tio.utils.json.Json;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpResponse
extends HttpPacket {
    private static final Logger log = LoggerFactory.getLogger(HttpResponse.class);
    private static final boolean DIAGNOSTIC_LOG_ENABLED = EnvUtils.getBoolean((String)"tio.core.diagnostic", (boolean)false);
    private static final long serialVersionUID = -3512681144230291786L;
    public static final transient HttpResponse NULL_RESPONSE = new HttpResponse();
    private HttpResponseStatus status = null;
    private boolean isStaticRes = false;
    private transient boolean stream = false;
    private transient boolean send = true;
    private transient boolean skipAddContentLength = true;
    private transient HttpRequest request = null;
    private transient List<Cookie> cookies = null;
    private Map<HeaderName, HeaderValue> headers = new HashMap<HeaderName, HeaderValue>();
    private int headerByteCount = 2;
    private boolean skipGzipped = false;
    private String charset = "utf-8";
    private transient boolean skipIpStat = false;
    private transient boolean skipTokenStat = false;
    private String version;

    public HttpResponse() {
        this.status = HttpResponseStatus.C200;
    }

    public HttpResponse(HttpRequest request) {
        this();
        String version;
        if (request == null) {
            return;
        }
        this.charset = request.getCharset();
        this.request = request;
        this.version = version = request.requestLine.getVersion();
        String conn = request.getConnection();
        if ("1.0".equals(version)) {
            if (request.httpConfig != null && request.httpConfig.compatible1_0 && "keep-alive".equalsIgnoreCase(conn)) {
                this.addHeader(HeaderName.Connection, HeaderValue.Connection.keep_alive);
                this.addHeader(HeaderName.Keep_Alive, HeaderValue.Keep_Alive.TIMEOUT_10_MAX_20);
                this.setKeepConnection(true);
            } else {
                this.addHeader(HeaderName.Connection, HeaderValue.Connection.close);
                this.setKeepConnection(false);
            }
        } else if ("1.1".equals(version)) {
            if ("close".equalsIgnoreCase(conn)) {
                this.addHeader(HeaderName.Connection, HeaderValue.Connection.close);
                this.setKeepConnection(false);
            } else {
                this.addHeader(HeaderName.Connection, HeaderValue.Connection.keep_alive);
                this.setKeepConnection(true);
            }
        } else {
            this.addHeader(HeaderName.Connection, HeaderValue.Connection.close);
            this.setKeepConnection(false);
        }
        if (DIAGNOSTIC_LOG_ENABLED) {
            log.info("keepConnection:{}", (Object)this.isKeepConnection());
        }
        this.status = HttpResponseStatus.C200.changeVersion(version);
    }

    public HttpResponse(Map<HeaderName, HeaderValue> responseHeaders, byte[] body) {
        if (responseHeaders != null) {
            this.headers.putAll(responseHeaders);
        }
        this.status = HttpResponseStatus.C200;
        this.setBody(body);
        HttpGzipUtils.gzip(this);
    }

    public HttpResponse setSend(boolean b) {
        this.send = b;
        return this;
    }

    public boolean isSend() {
        return this.send;
    }

    public void crossDomain() {
        this.addHeader(HeaderName.Access_Control_Allow_Origin, HeaderValue.from("*"));
        this.addHeader(HeaderName.Access_Control_Allow_Headers, HeaderValue.from("x-requested-with,content-type"));
    }

    public static HttpResponse cloneResponse(HttpRequest request, HttpResponse response) {
        HttpResponse cloneResponse = new HttpResponse(request);
        cloneResponse.setStatus(response.getStatus());
        cloneResponse.setBody(response.getBody());
        cloneResponse.setSkipGzipped(response.isSkipGzipped());
        cloneResponse.addHeaders(response.getHeaders());
        if (cloneResponse.getCookies() != null) {
            cloneResponse.getCookies().clear();
        }
        return cloneResponse;
    }

    public Map<HeaderName, HeaderValue> getHeaders() {
        return this.headers;
    }

    public void setHeader(String name, String value) {
        this.addHeader(name, value);
    }

    public void setHeader(HeaderName key, String headeValue) {
        HeaderValue value = HeaderValue.from(headeValue);
        this.addHeader(key, value);
    }

    public HttpResponse addHeader(String name, String headeValue) {
        HeaderName key = HeaderName.from(name);
        HeaderValue value = HeaderValue.from(headeValue);
        this.addHeader(key, value);
        return this;
    }

    public void addHeader(HeaderName key, HeaderValue value) {
        this.headers.put(key, value);
        this.headerByteCount += key.bytes.length + value.bytes.length + 3;
    }

    public void addHeaders(Map<HeaderName, HeaderValue> headers) {
        if (headers != null) {
            Set<Map.Entry<HeaderName, HeaderValue>> set = headers.entrySet();
            for (Map.Entry<HeaderName, HeaderValue> entry : set) {
                this.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public HeaderValue getContentType() {
        return this.headers.get(HeaderName.Content_Type);
    }

    public boolean addCookie(Cookie cookie) {
        if (this.cookies == null) {
            this.cookies = new ArrayList<Cookie>();
        }
        return this.cookies.add(cookie);
    }

    public String getCharset() {
        return this.charset;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public HttpRequest getHttpRequest() {
        return this.request;
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public boolean isStaticRes() {
        return this.isStaticRes;
    }

    public String logstr() {
        String str = null;
        if (this.request != null) {
            str = "reponse: requestID_" + this.request.getId() + "  " + this.request.getRequestLine().getPathAndQuery();
            str = str + "\r\n" + this.getHeaderString();
        } else {
            str = "nresponse " + this.status.getHeaderText();
        }
        return str;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public void setHttpRequestPacket(HttpRequest request) {
        this.request = request;
    }

    public void setStaticRes(boolean isStaticRes) {
        this.isStaticRes = isStaticRes;
    }

    public HttpResponse setStatus(int code) {
        switch (code) {
            case 100: {
                this.status = HttpResponseStatus.C100;
                break;
            }
            case 101: {
                this.status = HttpResponseStatus.C101;
                break;
            }
            case 200: {
                this.status = HttpResponseStatus.C200;
                break;
            }
            case 201: {
                this.status = HttpResponseStatus.C201;
                break;
            }
            case 202: {
                this.status = HttpResponseStatus.C202;
                break;
            }
            case 203: {
                this.status = HttpResponseStatus.C203;
                break;
            }
            case 204: {
                this.status = HttpResponseStatus.C204;
                break;
            }
            case 205: {
                this.status = HttpResponseStatus.C205;
                break;
            }
            case 206: {
                this.status = HttpResponseStatus.C206;
                break;
            }
            case 300: {
                this.status = HttpResponseStatus.C300;
                break;
            }
            case 301: {
                this.status = HttpResponseStatus.C301;
                break;
            }
            case 302: {
                this.status = HttpResponseStatus.C302;
                break;
            }
            case 303: {
                this.status = HttpResponseStatus.C303;
                break;
            }
            case 304: {
                this.status = HttpResponseStatus.C304;
                break;
            }
            case 305: {
                this.status = HttpResponseStatus.C305;
                break;
            }
            case 307: {
                this.status = HttpResponseStatus.C307;
                break;
            }
            case 400: {
                this.status = HttpResponseStatus.C400;
                break;
            }
            case 401: {
                this.status = HttpResponseStatus.C401;
                break;
            }
            case 403: {
                this.status = HttpResponseStatus.C403;
                break;
            }
            case 404: {
                this.status = HttpResponseStatus.C404;
                break;
            }
            case 405: {
                this.status = HttpResponseStatus.C405;
                break;
            }
            case 406: {
                this.status = HttpResponseStatus.C406;
                break;
            }
            case 407: {
                this.status = HttpResponseStatus.C407;
                break;
            }
            case 408: {
                this.status = HttpResponseStatus.C408;
                break;
            }
            case 409: {
                this.status = HttpResponseStatus.C409;
                break;
            }
            case 410: {
                this.status = HttpResponseStatus.C410;
                break;
            }
            case 411: {
                this.status = HttpResponseStatus.C411;
                break;
            }
            case 412: {
                this.status = HttpResponseStatus.C412;
                break;
            }
            case 413: {
                this.status = HttpResponseStatus.C413;
                break;
            }
            case 414: {
                this.status = HttpResponseStatus.C414;
                break;
            }
            case 416: {
                this.status = HttpResponseStatus.C416;
                break;
            }
            case 500: {
                this.status = HttpResponseStatus.C500;
                break;
            }
            case 501: {
                this.status = HttpResponseStatus.C501;
                break;
            }
            case 502: {
                this.status = HttpResponseStatus.C502;
                break;
            }
            case 503: {
                this.status = HttpResponseStatus.C503;
                break;
            }
            case 504: {
                this.status = HttpResponseStatus.C504;
                break;
            }
            case 505: {
                this.status = HttpResponseStatus.C505;
                break;
            }
            default: {
                this.status = HttpResponseStatus.CUSTOM.build(this.version, code);
            }
        }
        return this;
    }

    public HttpResponse setStatus(HttpResponseStatus status) {
        this.status = status;
        return this;
    }

    public HttpResponse setStatus(int status, String description) {
        HttpResponseStatus custom;
        this.status = custom = HttpResponseStatus.CUSTOM.build(this.version, status, description);
        return this;
    }

    public void setStatus(int status, String description, String headerText) {
        HttpResponseStatus custom;
        this.status = custom = HttpResponseStatus.CUSTOM.build(this.version, status, description, headerText);
    }

    public boolean isSkipGzipped() {
        return this.skipGzipped;
    }

    public void setSkipGzipped(boolean hasGzipped) {
        this.skipGzipped = hasGzipped;
    }

    public boolean isSkipIpStat() {
        return this.skipIpStat;
    }

    public void setSkipIpStat(boolean skipIpStat) {
        this.skipIpStat = skipIpStat;
    }

    public boolean isSkipTokenStat() {
        return this.skipTokenStat;
    }

    public void setSkipTokenStat(boolean skipTokenStat) {
        this.skipTokenStat = skipTokenStat;
    }

    public HeaderValue getLastModified() {
        return this.getHeader(HeaderName.Last_Modified);
    }

    public HeaderValue getHeader(HeaderName name) {
        return this.headers.get(name);
    }

    public void setLastModified(HeaderValue lastModified) {
        if (lastModified != null) {
            this.addHeader(HeaderName.Last_Modified, lastModified);
        }
    }

    public String toString() {
        return this.status.toString();
    }

    public int getHeaderByteCount() {
        return this.headerByteCount;
    }

    public void setContentType(String contentType) {
        this.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.from(contentType));
    }

    public void setContentDisposition(String value) {
        this.addHeader(HeaderName.Content_Disposition, HeaderValue.Content_Type.from(value));
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public HttpResponse addServerSentEventsHeader(String charset) {
        this.setContentType("text/event-stream;charset=" + charset);
        this.addHeader(HeaderName.Connection, HeaderValue.from("keep-alive"));
        this.stream = true;
        this.keepConnection = true;
        return this;
    }

    public HttpResponse addServerSentEventsHeader() {
        return this.addServerSentEventsHeader("utf-8");
    }

    public void sendRedirect(String url) {
        this.setStatus(HttpResponseStatus.C302);
        this.addHeader(HeaderName.Location, HeaderValue.from(url));
    }

    public static HttpResponse string(String bodyString, String charset, String mimeTypeStr) {
        HttpResponse httpResponse = new HttpResponse();
        httpResponse.setString(bodyString, charset, mimeTypeStr);
        return httpResponse;
    }

    public HttpResponse setBodyString(String bodyString) {
        if (bodyString != null) {
            try {
                this.setBody(bodyString.getBytes(this.charset));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        this.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.TEXT_PLAIN_TXT);
        return this;
    }

    public HttpResponse setBodyString(String bodyString, String charset) {
        if (bodyString != null) {
            try {
                this.setBody(bodyString.getBytes(charset));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public HttpResponse setString(String bodyString, String charset, String mimeTypeStr) {
        if (bodyString != null) {
            if (charset == null) {
                this.setBody(bodyString.getBytes());
            } else {
                try {
                    this.setBody(bodyString.getBytes(charset));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.addHeader(HeaderName.Content_Type, HeaderValue.Content_Type.from(mimeTypeStr));
        return this;
    }

    public HttpResponse setJson(Object body) {
        String charset = this.getHttpRequest().getChannelContext().getTioConfig().getCharset();
        if (body == null) {
            return this.setString("", charset, MimeTypeUtils.getJson(charset));
        }
        if (body.getClass() == String.class || ClassUtil.isBasicType(body.getClass())) {
            return this.setString(body + "", charset, MimeTypeUtils.getJson(charset));
        }
        return this.setString(Json.getJson().toJson(body), charset, MimeTypeUtils.getJson(charset));
    }

    public HttpResponse setSkipAddContentLength(boolean b) {
        this.skipAddContentLength = b;
        return this;
    }

    public HttpResponse removeHeaders(String name) {
        this.headers.remove(HeaderName.from(name));
        return this;
    }

    public boolean isSkipAddContentLength() {
        return this.skipAddContentLength;
    }

    public void setAttachmentFilename(String downloadFilename) {
        this.setHeader(HeaderName.Content_Disposition, "attachment; filename=\"" + downloadFilename + "\"");
    }

    public HttpResponse status(int code) {
        return this.setStatus(code);
    }

    public HttpResponse status(int status, String description) {
        return this.setStatus(status, description);
    }

    public HttpResponse header(String key, String value) {
        return this.addHeader(key, value);
    }

    public HttpResponse fail(Object body) {
        this.setStatus(400);
        return this.setJson(body);
    }

    public HttpResponse error(String body) {
        this.setStatus(HttpResponseStatus.C500);
        return this.setBodyString(body);
    }

    public static HttpResponse json(Object body) {
        String charset = Charset.defaultCharset().name();
        return HttpResponse.json(body, charset);
    }

    public static HttpResponse json(Object body, String charset) {
        if (body == null) {
            return HttpResponse.string("", charset, MimeTypeUtils.getJson(charset));
        }
        if (body.getClass() == String.class || ClassUtil.isBasicType(body.getClass())) {
            return HttpResponse.string(body + "", charset, MimeTypeUtils.getJson(charset));
        }
        return HttpResponse.string(Json.getJson().toJson(body), charset, MimeTypeUtils.getJson(charset));
    }

    public static HttpResponse json(HttpRequest request, Object body) {
        HttpResponse httpResponse = new HttpResponse(request);
        return httpResponse.setJson(body);
    }

    public HttpResponse body(String bodyString) {
        return this.setBodyString(bodyString);
    }

    public HttpResponse body(Object obj) {
        return this.setJson(obj);
    }

    public HttpResponse ok(byte[] payload) {
        this.setBody(payload);
        return this;
    }

    public void disableGzip(boolean b) {
        this.setSkipAddContentLength(!b);
    }

    public OutputStream newOutputStream() {
        return this.newOutputStream(this.request.channelContext);
    }

    public OutputStream newOutputStream(ChannelContext ctx) {
        this.addHeader(HeaderName.Transfer_Encoding, HeaderValue.from("chunked"));
        this.setSkipAddContentLength(false);
        Tio.bSend((ChannelContext)this.request.channelContext, (Packet)this);
        this.setSend(false);
        return new TioOutputStream(ctx, true);
    }
}

