/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.common;

import com.litongjava.aio.Packet;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Node;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.exception.TioDecodeException;
import com.litongjava.tio.core.utils.IpBlacklistUtils;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpConst;
import com.litongjava.tio.http.common.HttpMethod;
import com.litongjava.tio.http.common.HttpMultiBodyDecoder;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.HttpResponseStatus;
import com.litongjava.tio.http.common.MimeType;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.http.common.StrCache;
import com.litongjava.tio.http.common.utils.HttpIpUtils;
import com.litongjava.tio.http.common.utils.HttpParseUtils;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestDecoder {
    private static final Logger log = LoggerFactory.getLogger(HttpRequestDecoder.class);
    public static final int MAX_LENGTH_OF_HEADER = 20480;
    public static final int MAX_LENGTH_OF_HEADERLINE = 8192;
    public static final int MAX_LENGTH_OF_REQUESTLINE = 8192;
    public static boolean PRINT_PACKET = EnvUtils.getBoolean((String)"server.http.request.printPacket", (boolean)false);

    public static HttpRequest decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext channelContext, HttpConfig httpConfig) throws TioDecodeException {
        boolean decodeParams;
        if (PRINT_PACKET) {
            buffer.mark();
            String request = StandardCharsets.UTF_8.decode(buffer).toString();
            buffer.reset();
            log.info("request:{}", (Object)request);
        }
        RequestLine firstLine = null;
        firstLine = HttpRequestDecoder.parseRequestLine(buffer, channelContext);
        if (firstLine == null) {
            return null;
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        int contentLength = 0;
        byte[] bodyBytes = null;
        boolean headerCompleted = HttpRequestDecoder.parseHeader(buffer, headers, 0, httpConfig);
        if (!headerCompleted) {
            return null;
        }
        String contentLengthStr = (String)headers.get("content-length");
        if (StrUtil.isBlank((String)contentLengthStr)) {
            contentLength = 0;
        } else {
            contentLength = Integer.parseInt(contentLengthStr);
            if (contentLength > httpConfig.getMaxLengthOfPostBody()) {
                String message = "post body length is too big[" + contentLength + "], max length is " + httpConfig.getMaxLengthOfPostBody() + " byte";
                log.error(message);
                HttpResponse httpResponse = new HttpResponse();
                httpResponse.setStatus(413);
                httpResponse.body(message);
                Tio.bSend((ChannelContext)channelContext, (Packet)httpResponse);
                Tio.close((ChannelContext)channelContext, (String)"Payload Too Large");
            }
        }
        int headerLength = buffer.position() - position;
        int allNeedLength = headerLength + contentLength;
        int notReceivedLength = allNeedLength - readableLength;
        if (notReceivedLength > 0) {
            if (notReceivedLength > channelContext.getReadBufferSize()) {
                channelContext.setReadBufferSize(Integer.valueOf(notReceivedLength));
            }
            channelContext.setPacketNeededLength(Integer.valueOf(allNeedLength));
            return null;
        }
        String realIp = HttpIpUtils.getRealIp(channelContext, httpConfig, headers);
        if (IpBlacklistUtils.isInBlacklist((TioConfig)channelContext.tioConfig, (String)realIp)) {
            throw new TioDecodeException("[" + realIp + "] in black list");
        }
        if (httpConfig.checkHost && !headers.containsKey("host")) {
            throw new TioDecodeException("there is no host header");
        }
        Node realNode = null;
        if (Objects.equals(realIp, channelContext.getClientNode().getIp())) {
            realNode = channelContext.getClientNode();
        } else {
            realNode = new Node(realIp, channelContext.getClientNode().getPort());
            channelContext.setProxyClientNode(realNode);
        }
        HttpRequest httpRequest = new HttpRequest(realNode);
        httpRequest.setRequestLine(firstLine);
        httpRequest.setChannelContext(channelContext);
        httpRequest.setHttpConfig(httpConfig);
        httpRequest.setHeaders(headers);
        httpRequest.setContentLength(contentLength);
        String connection = (String)headers.get("connection");
        if (connection != null) {
            httpRequest.setConnection(connection.toLowerCase());
        }
        String httpVersion = firstLine.getVersion();
        boolean keepAlive = true;
        if ("1.1".equalsIgnoreCase(httpVersion)) {
            if ("close".equalsIgnoreCase(connection)) {
                keepAlive = false;
            }
        } else if ("1.0".equalsIgnoreCase(httpVersion)) {
            keepAlive = "keep-alive".equalsIgnoreCase(connection);
        } else if ("close".equalsIgnoreCase(connection)) {
            keepAlive = false;
        }
        httpRequest.setKeepConnection(keepAlive);
        if (StrUtil.isNotBlank((CharSequence)firstLine.queryString) && !(decodeParams = HttpRequestDecoder.decodeParams(httpRequest.getParams(), firstLine.queryString, httpRequest.getCharset(), channelContext))) {
            return null;
        }
        if (contentLength > 0) {
            bodyBytes = new byte[contentLength];
            buffer.get(bodyBytes);
            httpRequest.setBody(bodyBytes);
            HttpRequestDecoder.parseBody(httpRequest, firstLine, bodyBytes, channelContext, httpConfig);
        }
        return httpRequest;
    }

    public static boolean decodeParams(Map<String, Object[]> params, String queryString, String charset, ChannelContext channelContext) throws TioDecodeException {
        String[] keyvalues;
        if (StrUtil.isBlank((String)queryString)) {
            return true;
        }
        for (String keyvalue : keyvalues = queryString.split("&")) {
            String[] newExistValue;
            String value;
            String[] keyvalueArr = keyvalue.split("=", 2);
            String value1 = null;
            if (keyvalueArr.length == 2) {
                value1 = keyvalueArr[1];
            } else if (keyvalueArr.length > 2) {
                String errorMsg = "Invalid query parameter format in query string, contain multi ==:" + queryString;
                log.error(errorMsg);
                HttpResponse httpResponse = new HttpResponse();
                httpResponse.setStatus(HttpResponseStatus.C400);
                httpResponse.setBody(errorMsg.getBytes(StandardCharsets.UTF_8));
                Tio.bSend((ChannelContext)channelContext, (Packet)httpResponse);
                Tio.close((ChannelContext)channelContext, (String)"Invalid query parameter format");
                return false;
            }
            String key = keyvalueArr[0];
            if (StrUtil.isBlank((String)value1)) {
                value = null;
            } else {
                try {
                    value = URLDecoder.decode(value1, charset);
                }
                catch (UnsupportedEncodingException e) {
                    throw new TioDecodeException((Throwable)e);
                }
            }
            Object[] existValue = params.get(key);
            if (existValue != null) {
                newExistValue = new String[existValue.length + 1];
                System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
                newExistValue[newExistValue.length - 1] = value;
                params.put(key, newExistValue);
                continue;
            }
            newExistValue = new String[]{value};
            params.put(key, newExistValue);
        }
        return true;
    }

    private static void parseBody(HttpRequest httpRequest, RequestLine firstLine, byte[] bodyBytes, ChannelContext channelContext, HttpConfig httpConfig) throws TioDecodeException {
        HttpRequestDecoder.parseBodyFormat(httpRequest, httpRequest.getHeaders());
        HttpConst.RequestBodyFormat bodyFormat = httpRequest.getBodyFormat();
        httpRequest.setBody(bodyBytes);
        switch (bodyFormat) {
            case MULTIPART: {
                if (log.isInfoEnabled()) {
                    String bodyString = null;
                    if (bodyBytes != null && bodyBytes.length > 0 && log.isDebugEnabled()) {
                        try {
                            bodyString = new String(bodyBytes, httpRequest.getCharset());
                            if (bodyString.length() < 2048) {
                                log.debug("{} multipart body value\r\n{}", (Object)channelContext, (Object)bodyString);
                            } else {
                                log.debug("{} multipart body value\r\n{}", (Object)channelContext, (Object)bodyString.substring(0, 2048));
                            }
                        }
                        catch (UnsupportedEncodingException e) {
                            log.error(channelContext.toString(), (Throwable)e);
                        }
                    }
                }
                String contentType = httpRequest.getHeader("content-type");
                String initboundary = HttpParseUtils.getSubAttribute(contentType, "boundary");
                if (log.isDebugEnabled()) {
                    log.debug("{}, initboundary:{}", (Object)channelContext, (Object)initboundary);
                }
                HttpMultiBodyDecoder.decode(httpRequest, firstLine, bodyBytes, initboundary, channelContext, httpConfig);
                break;
            }
            default: {
                String bodyString = null;
                if (bodyBytes != null && bodyBytes.length > 0) {
                    try {
                        bodyString = new String(bodyBytes, httpRequest.getCharset());
                        httpRequest.setBodyString(bodyString);
                        if (EnvUtils.getBoolean((String)"tio.devMode", (boolean)false) && log.isInfoEnabled()) {
                            log.info("{} body value\r\n{}", (Object)channelContext, (Object)bodyString);
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error(channelContext.toString(), (Throwable)e);
                    }
                }
                if (bodyFormat != HttpConst.RequestBodyFormat.URLENCODED) break;
                HttpRequestDecoder.parseUrlencoded(httpRequest, firstLine, bodyBytes, bodyString, channelContext);
            }
        }
    }

    public static void parseBodyFormat(HttpRequest httpRequest, Map<String, String> headers) {
        String contentType = headers.get("content-type");
        if (contentType != null) {
            contentType = contentType.toLowerCase();
        }
        if (HttpRequestDecoder.isText(contentType)) {
            httpRequest.setBodyFormat(HttpConst.RequestBodyFormat.TEXT);
        } else if (contentType.startsWith("multipart/form-data")) {
            httpRequest.setBodyFormat(HttpConst.RequestBodyFormat.MULTIPART);
        } else {
            httpRequest.setBodyFormat(HttpConst.RequestBodyFormat.URLENCODED);
        }
        if (StrUtil.isNotBlank((CharSequence)contentType)) {
            String charset = HttpParseUtils.getSubAttribute(contentType, "charset");
            if (StrUtil.isNotBlank((CharSequence)charset)) {
                httpRequest.setCharset(charset);
            } else {
                httpRequest.setCharset("utf-8");
            }
        }
    }

    private static boolean isText(String contentType) {
        return contentType.startsWith("text/plain") || contentType.startsWith(MimeType.APPLICATION_JSON.getType());
    }

    private static String readLine(ByteBuffer buffer) {
        int startPosition = buffer.position();
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            if (b != 13 || !buffer.hasRemaining()) continue;
            byte next = buffer.get();
            if (next == 10) {
                int endPosition = buffer.position() - 2;
                int length = endPosition - startPosition;
                byte[] lineBytes = new byte[length];
                buffer.position(startPosition);
                buffer.get(lineBytes);
                buffer.get();
                buffer.get();
                return new String(lineBytes, StandardCharsets.UTF_8);
            }
            buffer.position(buffer.position() - 1);
        }
        buffer.position(startPosition);
        return null;
    }

    public static boolean parseHeader(ByteBuffer buffer, Map<String, String> headers, int hasReceivedHeaderLength, HttpConfig httpConfig) throws TioDecodeException {
        String line;
        while ((line = HttpRequestDecoder.readLine(buffer)) != null) {
            if (line.trim().isEmpty()) {
                return true;
            }
            if (line.length() > 8192) {
                throw new TioDecodeException("header line is too long, max length of header line is 8192");
            }
            if ((hasReceivedHeaderLength += line.getBytes(StandardCharsets.UTF_8).length + 2) > 20480) {
                throw new TioDecodeException("header is too long, max length of header is 20480");
            }
            int colonIndex = line.indexOf(58);
            if (colonIndex == -1) {
                throw new TioDecodeException("Invalid header line: " + line);
            }
            String name = line.substring(0, colonIndex).trim().toLowerCase();
            String value = line.substring(colonIndex + 1).trim();
            headers.put(name, value);
        }
        return false;
    }

    public static RequestLine parseRequestLine(ByteBuffer buffer, ChannelContext channelContext) throws TioDecodeException {
        int offset;
        byte[] allbs;
        if (buffer.hasArray()) {
            allbs = buffer.array();
            offset = buffer.arrayOffset();
        } else {
            buffer.mark();
            allbs = new byte[buffer.remaining()];
            buffer.get(allbs);
            buffer.reset();
            offset = -buffer.position();
        }
        int startPos = buffer.position() + offset;
        String methodStr = null;
        String pathStr = null;
        String queryStr = null;
        String protocol = null;
        String version = null;
        int initPosition = buffer.position();
        while (buffer.hasRemaining()) {
            int len;
            byte b = buffer.get();
            if (methodStr == null) {
                if (b == 32) {
                    len = buffer.position() + offset - startPos - 1;
                    methodStr = StrCache.get(allbs, startPos, len);
                    startPos = buffer.position() + offset;
                    continue;
                }
                if (buffer.position() + offset - startPos <= 10) continue;
                return null;
            }
            if (pathStr == null) {
                if (b != 32 && b != 63) continue;
                len = buffer.position() + offset - startPos - 1;
                pathStr = StrCache.get(allbs, startPos, len);
                startPos = buffer.position() + offset;
                if (b != 32) continue;
                queryStr = "";
                continue;
            }
            if (queryStr == null) {
                if (b != 32) continue;
                len = buffer.position() + offset - startPos - 1;
                queryStr = new String(allbs, startPos, len);
                startPos = buffer.position() + offset;
                continue;
            }
            if (protocol == null) {
                if (b != 47) continue;
                len = buffer.position() + offset - startPos - 1;
                protocol = StrCache.get(allbs, startPos, len);
                startPos = buffer.position() + offset;
                continue;
            }
            if (version != null || b != 10) continue;
            byte lastByte = buffer.get(buffer.position() - 2);
            int len2 = buffer.position() + offset - startPos - 1;
            if (lastByte == 13) {
                --len2;
            }
            version = StrCache.get(allbs, startPos, len2);
            RequestLine requestLine = new RequestLine();
            HttpMethod method = HttpMethod.from(methodStr);
            if (method == null) {
                throw new TioDecodeException("Unsupported HTTP method: " + methodStr);
            }
            requestLine.setMethod(method);
            requestLine.setPath(pathStr);
            requestLine.setInitPath(pathStr);
            requestLine.setQueryString(queryStr);
            requestLine.setProtocol(protocol);
            requestLine.setVersion(version);
            return requestLine;
        }
        if (buffer.position() - initPosition > 8192) {
            throw new TioDecodeException("request line is too long");
        }
        return null;
    }

    private static void parseUrlencoded(HttpRequest httpRequest, RequestLine firstLine, byte[] bodyBytes, String bodyString, ChannelContext channelContext) throws TioDecodeException {
        HttpRequestDecoder.decodeParams(httpRequest.getParams(), bodyString, httpRequest.getCharset(), channelContext);
    }

    public static enum Step {
        firstline,
        header,
        body;

    }
}

