/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.common;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Node;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.http.common.Cookie;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpConst;
import com.litongjava.tio.http.common.HttpMethod;
import com.litongjava.tio.http.common.HttpPacket;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.RequestDispatcher;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.http.common.UploadFile;
import com.litongjava.tio.http.common.session.HttpSession;
import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequest
extends HttpPacket {
    private static Logger log = LoggerFactory.getLogger(HttpRequest.class);
    private static final long serialVersionUID = -3849253977016967211L;
    private boolean needForward = false;
    private boolean isForward = false;
    public RequestLine requestLine = null;
    private Map<String, Object[]> params = new HashMap<String, Object[]>();
    private List<Cookie> cookies = null;
    private Map<String, Cookie> cookieMap = null;
    private int contentLength;
    private String connection;
    private String bodyString;
    private HttpConst.RequestBodyFormat bodyFormat;
    private String charset = "utf-8";
    private Boolean isAjax = null;
    private Boolean isSupportGzip = null;
    private HttpSession httpSession;
    private Node remote = null;
    public ChannelContext channelContext;
    public HttpConfig httpConfig;
    private String domain = null;
    private String host = null;
    private long createTime = SystemTimer.currTime;
    private boolean closed = false;
    protected Map<String, String> headers = new HashMap<String, String>();
    private Integer forwardCount = null;

    public HttpRequest(Node remote) {
        this.remote = remote;
    }

    public HttpRequest() {
    }

    public void close() {
        this.close(null);
    }

    public void close(String remark) {
        this.closed = true;
        Tio.remove((ChannelContext)this.channelContext, (String)remark);
    }

    public void addParam(String key, Object value) {
        if (value == null) {
            return;
        }
        Object[] existValue = this.params.get(key);
        if (existValue != null) {
            Object[] newExistValue = new Object[existValue.length + 1];
            if (value instanceof String) {
                newExistValue = new String[existValue.length + 1];
            } else if (value instanceof UploadFile) {
                newExistValue = new UploadFile[existValue.length + 1];
            }
            System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
            newExistValue[newExistValue.length - 1] = value;
            this.params.put(key, newExistValue);
        } else {
            Object[] newExistValue = null;
            if (value instanceof String) {
                newExistValue = new String[]{(String)value};
            } else if (value instanceof UploadFile) {
                newExistValue = new UploadFile[]{(UploadFile)value};
            }
            this.params.put(key, newExistValue);
        }
    }

    public HttpResponse forward(String newPath) throws Exception {
        if (StrUtil.contains((CharSequence)newPath, (char)'?')) {
            this.requestLine.path = StrUtil.subBefore((CharSequence)newPath, (CharSequence)"?", (boolean)false);
            this.requestLine.queryString = StrUtil.subAfter((CharSequence)newPath, (CharSequence)"?", (boolean)false);
        } else {
            this.requestLine.path = newPath;
            this.requestLine.queryString = null;
        }
        if (this.forwardCount == null) {
            this.forwardCount = 1;
        } else {
            Integer n = this.forwardCount;
            Integer n2 = this.forwardCount = Integer.valueOf(this.forwardCount + 1);
        }
        if (this.forwardCount > this.httpConfig.maxForwardCount) {
            log.error("forwardCount[{}] is too large, newPath:{}", (Object)this.forwardCount, (Object)newPath);
            this.close();
            return null;
        }
        this.needForward = true;
        return HttpResponse.NULL_RESPONSE;
    }

    public HttpConst.RequestBodyFormat getBodyFormat() {
        return this.bodyFormat;
    }

    public void setUserAgent(String userAgent) {
        this.headers.put("user-agent", userAgent);
    }

    public String getUserAgent() {
        return this.headers.get("user-agent");
    }

    public String getHost() {
        if (this.host != null) {
            return this.host;
        }
        this.host = this.headers.get("host");
        return this.host;
    }

    public String getAuthorization() {
        return this.headers.get("authorization");
    }

    public String getReferer() {
        return this.getHeader("referer");
    }

    public String getOrigin() {
        return this.getHeader("origin");
    }

    public String getClientIp() {
        return this.remote.getIp();
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addHeaders(Map<String, String> headers) {
        if (headers != null) {
            Set<Map.Entry<String, String>> set = headers.entrySet();
            for (Map.Entry<String, String> entry : set) {
                this.addHeader(entry.getKey(), entry.getValue());
            }
        }
    }

    public String getDomain() {
        if (this.domain != null) {
            return this.domain;
        }
        if (StrUtil.isBlank((String)this.getHost())) {
            return null;
        }
        this.domain = StrUtil.subBefore((CharSequence)this.getHost(), (CharSequence)":", (boolean)false);
        return this.domain;
    }

    public String getBodyString() {
        return this.bodyString;
    }

    public ChannelContext getChannelContext() {
        return this.channelContext;
    }

    public String getCharset() {
        return this.charset;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public Cookie getCookie(String cooiename) {
        if (this.cookieMap == null) {
            return null;
        }
        return this.cookieMap.get(cooiename);
    }

    public Map<String, Cookie> getCookieMap() {
        return this.cookieMap;
    }

    public byte[] getBodyBytes() {
        return this.body;
    }

    public void setBodyBytes(byte[] bodyBytes) {
        this.body = bodyBytes;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public Cookie[] getCookiesArray() {
        if (this.cookies == null) {
            return new Cookie[0];
        }
        return this.cookies.toArray(new Cookie[0]);
    }

    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    public HttpSession getHttpSession() {
        return this.httpSession;
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void removeHeader(String key, String value) {
        this.headers.remove(key);
    }

    public Boolean getIsAjax() {
        if (this.isAjax == null) {
            String X_Requested_With = this.getHeader("x-requested-with");
            this.isAjax = X_Requested_With != null && "XMLHttpRequest".equalsIgnoreCase(X_Requested_With) ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        return this.isAjax;
    }

    public Boolean getIsSupportGzip() {
        return true;
    }

    public Map<String, Object[]> getParams() {
        return this.params;
    }

    public Map<String, Object> getParam() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.getParams() != null) {
            for (String key : this.params.keySet()) {
                Object[] param = this.params.get(key);
                if (param == null || param.length < 1) continue;
                params.put(key, param[0]);
            }
        }
        return params;
    }

    public Object getObject(String name) {
        if (StrUtil.isBlank((String)name)) {
            return null;
        }
        Object[] values = this.params.get(name);
        if (values != null && values.length > 0) {
            Object obj = values[0];
            return obj;
        }
        return null;
    }

    public String getParam(String name) {
        return (String)this.getObject(name);
    }

    public String getString(String name) {
        return this.getParam(name);
    }

    public UploadFile getUploadFile(String name) {
        Object[] values = this.params.get(name);
        if (values != null && values.length > 0) {
            Object obj = values[0];
            return (UploadFile)obj;
        }
        return null;
    }

    public Integer getInt(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((String)value)) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public Short getShort(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((String)value)) {
            return null;
        }
        return Short.parseShort(value);
    }

    public Byte getByte(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((String)value)) {
            return null;
        }
        return Byte.parseByte(value);
    }

    public Long getLong(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((String)value)) {
            return null;
        }
        return Long.parseLong(value);
    }

    public Double getDouble(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((String)value)) {
            return null;
        }
        return Double.parseDouble(value);
    }

    public Float getFloat(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((String)value)) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(value));
    }

    public Boolean getBoolean(String name) {
        String value = this.getParam(name);
        if (StrUtil.isBlank((String)value)) {
            return null;
        }
        return Boolean.valueOf(value);
    }

    public Object[] getParamArray(String name) {
        Object[] values = this.params.get(name);
        if (values == null) {
            values = this.params.get(name + "[]");
        }
        return values;
    }

    public String[] getParamValues(String name) {
        return (String[])this.getParamArray(name);
    }

    public Node getRemote() {
        return this.remote;
    }

    public RequestLine getRequestLine() {
        return this.requestLine;
    }

    public String logstr() {
        String str = "request ID_" + this.getId() + "\r\n" + this.getHeaderString();
        if (null != this.getBodyString()) {
            str = str + this.getBodyString();
        }
        return str;
    }

    public void parseCookie(HttpConfig httpConfig) {
        String cookieline = this.headers.get("cookie");
        if (StrUtil.isNotBlank((CharSequence)cookieline)) {
            this.cookies = new ArrayList<Cookie>();
            this.cookieMap = new HashMap<String, Cookie>();
            Map<String, String> _cookiemap = Cookie.getEqualMap(cookieline);
            Set<Map.Entry<String, String>> set = _cookiemap.entrySet();
            ArrayList<HashMap<String, String>> cookieListMap = new ArrayList<HashMap<String, String>>();
            for (Map.Entry<String, String> cookieMapEntry : set) {
                HashMap<String, String> cookieOneMap = new HashMap<String, String>(1);
                cookieOneMap.put(cookieMapEntry.getKey(), cookieMapEntry.getValue());
                cookieListMap.add(cookieOneMap);
                Cookie cookie = Cookie.buildCookie(cookieOneMap, httpConfig);
                this.cookies.add(cookie);
                this.cookieMap.put(cookie.getName(), cookie);
            }
        }
    }

    public void setBodyFormat(HttpConst.RequestBodyFormat bodyFormat) {
        this.bodyFormat = bodyFormat;
    }

    public void setBodyString(String bodyString) {
        this.bodyString = bodyString;
    }

    public void setChannelContext(ChannelContext channelContext) {
        this.channelContext = channelContext;
        this.charset = channelContext.getTioConfig().getCharset();
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void setCookieMap(Map<String, Cookie> cookieMap) {
        this.cookieMap = cookieMap;
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
        if (headers != null) {
            this.parseCookie(this.httpConfig);
        }
    }

    public void setHttpConfig(HttpConfig httpConfig) {
        this.httpConfig = httpConfig;
    }

    public void setHttpSession(HttpSession httpSession) {
        this.httpSession = httpSession;
    }

    public void setIsAjax(Boolean isAjax) {
        this.isAjax = isAjax;
    }

    public void setIsSupportGzip(Boolean isSupportGzip) {
        this.isSupportGzip = isSupportGzip;
    }

    public void setParams(Map<String, Object[]> params) {
        this.params = params;
    }

    public void setRemote(Node remote) {
        this.remote = remote;
    }

    public void setRequestLine(RequestLine requestLine) {
        this.requestLine = requestLine;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.requestLine.toString());
        if (this.getHeaderString() != null) {
            sb.append(this.getHeaderString()).append("\r\n");
        }
        if (this.getBodyString() != null) {
            sb.append(this.getBodyString());
        }
        return sb.toString();
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setClosed(boolean closed) {
        this.closed = closed;
    }

    public String getConnection() {
        return this.connection;
    }

    public void setConnection(String connection) {
        this.connection = connection;
    }

    public boolean isNeedForward() {
        return this.needForward;
    }

    public void setNeedForward(boolean needForward) {
        this.needForward = needForward;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setForward(boolean isForward) {
        this.isForward = isForward;
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.params.keySet());
    }

    public String getParameter(String paramName) {
        return this.getParam(paramName);
    }

    public Map<String, Object[]> getParameterMap() {
        return this.getParams();
    }

    public String getRequestURI() {
        String path = this.requestLine.getPath();
        return path;
    }

    public StringBuffer getRequestURL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.requestLine.getProtocol().toLowerCase()).append("://").append(this.host).append(this.requestLine.getPath());
        return stringBuffer;
    }

    public HttpMethod getMethod() {
        return this.requestLine.getMethod();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return new RequestDispatcher(path);
    }

    public void setUserId(Object userId) {
        this.setAttribute("userId", userId);
    }

    public Object getUserId() {
        return this.getAttribute("userId");
    }

    public String getUserIdString() {
        Object attribute = this.getUserId();
        if (attribute != null) {
            if (attribute instanceof String) {
                return (String)attribute;
            }
            return attribute.toString();
        }
        return null;
    }

    public Long getUserIdLong() {
        Object attribute = this.getAttribute("userId");
        if (attribute != null) {
            if (attribute instanceof Long) {
                return (Long)attribute;
            }
            return Long.valueOf((String)attribute);
        }
        return null;
    }
}

