/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.http.common;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.exception.LengthOverflowException;
import com.litongjava.tio.core.exception.TioDecodeException;
import com.litongjava.tio.core.utils.ByteBufferUtils;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.http.common.UploadFile;
import com.litongjava.tio.http.common.utils.HttpParseUtils;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMultiBodyDecoder {
    private static Logger log = LoggerFactory.getLogger(HttpMultiBodyDecoder.class);

    public static void decode(HttpRequest request, RequestLine firstLine, byte[] bodyBytes, String initboundary, ChannelContext channelContext, HttpConfig httpConfig) throws TioDecodeException {
        if (StrUtil.isBlank((String)initboundary)) {
            throw new TioDecodeException("boundary is null");
        }
        ByteBuffer buffer = ByteBuffer.wrap(bodyBytes);
        buffer.position(0);
        String boundary = "--" + initboundary;
        String endBoundary = boundary + "--";
        Step step = Step.BOUNDARY;
        try {
            Header multiBodyHeader;
            Step newParseStep;
            do {
                String line;
                if (step == Step.BOUNDARY) {
                    String line2 = ByteBufferUtils.readLine((ByteBuffer)buffer, (String)request.getCharset(), (Integer)512);
                    if (!boundary.equals(line2)) {
                        if (!endBoundary.equals(line2)) {
                            throw new TioDecodeException("line need:" + boundary + ", but is: " + line2 + "");
                        }
                        break;
                    }
                    step = Step.HEADER;
                }
                multiBodyHeader = new Header();
                if (step != Step.HEADER) continue;
                ArrayList<String> lines = new ArrayList<String>(2);
                while (!"".equals(line = ByteBufferUtils.readLine((ByteBuffer)buffer, (String)request.getCharset(), (Integer)512))) {
                    lines.add(line);
                }
                HttpMultiBodyDecoder.parseHeader(lines, multiBodyHeader, channelContext);
                step = Step.BODY;
            } while (step != Step.BODY || (step = (newParseStep = HttpMultiBodyDecoder.parseBody(multiBodyHeader, request, buffer, boundary, endBoundary, channelContext, httpConfig))) != Step.END);
        }
        catch (LengthOverflowException loe) {
            throw new TioDecodeException((Throwable)loe);
        }
        catch (UnsupportedEncodingException e) {
            log.error(channelContext.toString(), (Throwable)e);
        }
    }

    public static Step parseBody(Header header, HttpRequest request, ByteBuffer buffer, String boundary, String endBoundary, ChannelContext channelContext, HttpConfig httpConfig) throws UnsupportedEncodingException, LengthOverflowException, TioDecodeException {
        int initPosition = buffer.position();
        while (buffer.hasRemaining()) {
            String line = ByteBufferUtils.readLine((ByteBuffer)buffer, (String)request.getCharset(), (Integer)httpConfig.getMaxLengthOfMultiBody());
            boolean isEndBoundary = endBoundary.equals(line);
            boolean isBoundary = boundary.equals(line);
            if (!isBoundary && !isEndBoundary) continue;
            int startIndex = initPosition;
            int endIndex = buffer.position() - line.getBytes().length - 2 - 2;
            int length = endIndex - startIndex;
            byte[] dst = new byte[length];
            System.arraycopy(buffer.array(), startIndex, dst, 0, length);
            String filename = header.getFilename();
            if (filename != null) {
                if (StrUtil.isNotBlank((CharSequence)filename)) {
                    UploadFile uploadFile = new UploadFile();
                    uploadFile.setName(filename.replaceAll("%", ""));
                    uploadFile.setData(dst);
                    uploadFile.setSize(dst.length);
                    request.addParam(header.getName(), uploadFile);
                }
            } else {
                request.addParam(header.getName(), new String(dst, request.getCharset()));
            }
            if (isEndBoundary) {
                return Step.END;
            }
            return Step.HEADER;
        }
        log.error("\u6587\u4ef6\u4e0a\u4f20\uff0c\u534f\u8bae\u4e0d\u5bf9\uff0cstep is null");
        throw new TioDecodeException("step is null");
    }

    public static void parseHeader(List<String> lines, Header header, ChannelContext channelContext) throws TioDecodeException {
        if (lines == null || lines.size() == 0) {
            throw new TioDecodeException("multipart_form_data \u683c\u5f0f\u4e0d\u5bf9\uff0c\u6ca1\u6709\u5934\u90e8\u4fe1\u606f");
        }
        try {
            for (String line : lines) {
                String[] keyvalue = line.split(":");
                String key = StrUtil.trim((String)keyvalue[0]).toLowerCase();
                String value = StrUtil.trim((String)keyvalue[1]);
                header.map.put(key, value);
            }
            String contentDisposition = (String)header.map.get(MultiBodyHeaderKey.Content_Disposition);
            String name = HttpParseUtils.getSubAttribute(contentDisposition, "name");
            String filename = HttpParseUtils.getSubAttribute(contentDisposition, "filename");
            String contentType = (String)header.map.get(MultiBodyHeaderKey.Content_Type);
            header.setContentDisposition(contentDisposition);
            header.setName(name);
            header.setFilename(filename);
            header.setContentType(contentType);
        }
        catch (Throwable e) {
            log.error(channelContext.toString(), e);
            throw new TioDecodeException(e.toString());
        }
    }

    public static enum Step {
        BOUNDARY,
        HEADER,
        BODY,
        END;

    }

    public static interface MultiBodyHeaderKey {
        public static final String Content_Disposition = "Content-Disposition".toLowerCase();
        public static final String Content_Type = "Content-Type".toLowerCase();
    }

    public static class Header {
        private String contentDisposition = "form-data";
        private String name = null;
        private String filename = null;
        private String contentType = null;
        private Map<String, String> map = new HashMap<String, String>();

        public String getContentDisposition() {
            return this.contentDisposition;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getFilename() {
            return this.filename;
        }

        public Map<String, String> getMap() {
            return this.map;
        }

        public String getName() {
            return this.name;
        }

        public void setContentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public void setMap(Map<String, String> map) {
            this.map = map;
        }

        public void setName(String name) {
            this.name = name;
        }
    }
}

