/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.server;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.intf.AioHandler;
import com.litongjava.tio.core.intf.AioListener;
import com.litongjava.tio.core.maintain.GlobalIpBlacklist;
import com.litongjava.tio.core.ssl.SslConfig;
import com.litongjava.tio.server.ServerGroupStat;
import com.litongjava.tio.server.intf.ServerAioHandler;
import com.litongjava.tio.server.intf.ServerAioListener;
import com.litongjava.tio.utils.AppendJsonConverter;
import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.hutool.CollUtil;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.lock.SetWithLock;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerTioConfig
extends TioConfig {
    private static final Logger log = LoggerFactory.getLogger(ServerTioConfig.class);
    private ServerAioHandler serverAioHandler = null;
    private ServerAioListener serverAioListener = null;
    private Thread checkHeartbeatThread = null;
    private boolean needCheckHeartbeat = true;
    private boolean isShared = false;
    private int backlog = 1000;

    public ServerTioConfig(String name) {
        super(name);
    }

    public void useSsl(String keyStoreFile, String trustStoreFile, String keyStorePwd) throws Exception {
        if (StrUtil.isNotBlank((CharSequence)keyStoreFile) && StrUtil.isNotBlank((CharSequence)trustStoreFile)) {
            SslConfig sslConfig = SslConfig.forServer(keyStoreFile, trustStoreFile, keyStorePwd);
            this.setSslConfig(sslConfig);
        }
    }

    public void useSsl(InputStream keyStoreInputStream, InputStream trustStoreInputStream, String passwd) throws Exception {
        SslConfig sslConfig = SslConfig.forServer(keyStoreInputStream, trustStoreInputStream, passwd);
        this.setSslConfig(sslConfig);
    }

    @Override
    public AioHandler getAioHandler() {
        return this.getServerAioHandler();
    }

    @Override
    public AioListener getAioListener() {
        return this.getServerAioListener();
    }

    public ServerAioHandler getServerAioHandler() {
        return this.serverAioHandler;
    }

    public ServerAioListener getServerAioListener() {
        return this.serverAioListener;
    }

    public void setServerAioListener(ServerAioListener serverAioListener) {
        this.serverAioListener = serverAioListener;
    }

    @Override
    public boolean isServer() {
        return true;
    }

    public String toString() {
        return "ServerTioConfig [name=" + this.name + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void share(ServerTioConfig tioConfig) {
        Class<ServerTioConfig> clazz = ServerTioConfig.class;
        synchronized (ServerTioConfig.class) {
            if (tioConfig == this) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.clientNodes = tioConfig.clientNodes;
            this.connections = tioConfig.connections;
            this.groups = tioConfig.groups;
            this.users = tioConfig.users;
            this.tokens = tioConfig.tokens;
            this.ids = tioConfig.ids;
            this.bsIds = tioConfig.bsIds;
            this.ipBlacklist = tioConfig.ipBlacklist;
            this.ips = tioConfig.ips;
            if (!tioConfig.isShared && !this.isShared) {
                this.needCheckHeartbeat = false;
            }
            if (tioConfig.isShared && !this.isShared) {
                this.needCheckHeartbeat = false;
            }
            if (!tioConfig.isShared && this.isShared) {
                tioConfig.needCheckHeartbeat = false;
            }
            tioConfig.isShared = true;
            this.isShared = true;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void setServerAioHandler(ServerAioHandler serverAioHandler) {
        this.serverAioHandler = serverAioHandler;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    @Override
    public void init() {
        super.init();
        this.groupStat = new ServerGroupStat();
        GlobalIpBlacklist.INSTANCE.init(this);
        Runnable check = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    log.error(e1.toString(), (Throwable)e1);
                }
                while (ServerTioConfig.this.needCheckHeartbeat && !ServerTioConfig.this.isStopped() && ServerTioConfig.this.heartbeatTimeout > 0L) {
                    try {
                        Thread.sleep(ServerTioConfig.this.heartbeatTimeout);
                    }
                    catch (InterruptedException e1) {
                        log.error(e1.toString(), (Throwable)e1);
                    }
                    long start = SystemTimer.currTime;
                    SetWithLock setWithLock = ServerTioConfig.this.connections;
                    Set set = null;
                    long start1 = 0L;
                    int count = 0;
                    ReentrantReadWriteLock.ReadLock readLock = setWithLock.readLock();
                    readLock.lock();
                    try {
                        start1 = SystemTimer.currTime;
                        set = (Set)setWithLock.getObj();
                        for (ChannelContext channelContext : set) {
                            ++count;
                            long compareTime = Math.max(channelContext.stat.latestTimeOfReceivedByte, channelContext.stat.latestTimeOfSentPacket);
                            long currtime = SystemTimer.currTime;
                            long interval = currtime - compareTime;
                            boolean needRemove = false;
                            if (channelContext.heartbeatTimeout != null && channelContext.heartbeatTimeout > 0L) {
                                needRemove = interval > channelContext.heartbeatTimeout;
                            } else {
                                boolean bl = needRemove = interval > ServerTioConfig.this.heartbeatTimeout;
                            }
                            if (!needRemove || ServerTioConfig.this.serverAioListener.onHeartbeatTimeout(channelContext, interval, channelContext.stat.heartbeatTimeoutCount.incrementAndGet())) continue;
                            log.info("{}, {} ms or not send and receive message", (Object)channelContext, (Object)interval);
                            channelContext.setCloseCode(ChannelContext.CloseCode.HEARTBEAT_TIMEOUT);
                            Tio.remove(channelContext, interval + " ms not send and receive message");
                        }
                    }
                    catch (Throwable e) {
                        log.error("", e);
                    }
                    finally {
                        try {
                            readLock.unlock();
                            if (!ServerTioConfig.this.debug) continue;
                            ServerTioConfig.this.diagnostic(start, set, start1, count);
                        }
                        catch (Throwable e) {
                            log.error("", e);
                        }
                    }
                }
            }
        };
        this.checkHeartbeatThread = new Thread(check, "tio-timer-checkheartbeat-" + this.id + "-" + this.name);
        this.checkHeartbeatThread.setDaemon(true);
        this.checkHeartbeatThread.setPriority(1);
        this.checkHeartbeatThread.start();
    }

    private void diagnostic(long start, Set<ChannelContext> set, long start1, int count) {
        StringBuilder builder = new StringBuilder();
        builder.append("\r\n").append(this.name);
        builder.append("\r\n \u251c \u5f53\u524d\u65f6\u95f4:").append(SystemTimer.currTime);
        builder.append("\r\n \u251c \u8fde\u63a5\u7edf\u8ba1");
        builder.append("\r\n \u2502 \t \u251c \u5171\u63a5\u53d7\u8fc7\u8fde\u63a5\u6570 :").append(((ServerGroupStat)this.groupStat).accepted.get());
        builder.append("\r\n \u2502 \t \u251c \u5f53\u524d\u8fde\u63a5\u6570 :").append(set.size());
        builder.append("\r\n \u2502 \t \u251c \u5f02IP\u8fde\u63a5\u6570 :").append(((Map)this.ips.getIpmap().getObj()).size());
        builder.append("\r\n \u2502 \t \u2514 \u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u6570 :").append(this.groupStat.closed.get());
        builder.append("\r\n \u251c \u6d88\u606f\u7edf\u8ba1");
        builder.append("\r\n \u2502 \t \u251c \u5df2\u5904\u7406\u6d88\u606f :").append(this.groupStat.handledPackets.get());
        builder.append("\r\n \u2502 \t \u251c \u5df2\u63a5\u6536\u6d88\u606f(packet/byte) :").append(this.groupStat.receivedPackets.get()).append("/").append(this.groupStat.receivedBytes.get());
        builder.append("\r\n \u2502 \t \u251c \u5df2\u53d1\u9001\u6d88\u606f(packet/byte) :").append(this.groupStat.sentPackets.get()).append("/").append(this.groupStat.sentBytes.get()).append("b");
        builder.append("\r\n \u2502 \t \u251c \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u5b57\u8282\u6570 :").append(this.groupStat.getBytesPerTcpReceive());
        builder.append("\r\n \u2502 \t \u2514 \u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u4e1a\u52a1\u5305 :").append(this.groupStat.getPacketsPerTcpReceive());
        builder.append("\r\n \u2514 IP\u7edf\u8ba1\u65f6\u6bb5 ");
        if (CollUtil.isNotEmpty(this.ipStats.durationList)) {
            builder.append("\r\n   \t \u2514 ").append(AppendJsonConverter.convertListLongToJson(this.ipStats.durationList));
        } else {
            builder.append("\r\n   \t \u2514 ").append("\u6ca1\u6709\u8bbe\u7f6eip\u7edf\u8ba1\u65f6\u95f4");
        }
        builder.append("\r\n \u251c \u8282\u70b9\u7edf\u8ba1");
        builder.append("\r\n \u2502 \t \u251c clientNodes :").append(((Map)this.clientNodes.getObjWithLock().getObj()).size());
        builder.append("\r\n \u2502 \t \u251c \u6240\u6709\u8fde\u63a5 :").append(((Set)this.connections.getObj()).size());
        builder.append("\r\n \u2502 \t \u251c \u7ed1\u5b9auser\u6570 :").append(((Map)this.users.getMap().getObj()).size());
        builder.append("\r\n \u2502 \t \u251c \u7ed1\u5b9atoken\u6570 :").append(((Map)this.tokens.getMap().getObj()).size());
        builder.append("\r\n \u2502 \t \u2514 \u7b49\u5f85\u540c\u6b65\u6d88\u606f\u54cd\u5e94 :").append(((Map)this.waitingResps.getObj()).size());
        builder.append("\r\n \u251c \u7fa4\u7ec4");
        builder.append("\r\n \u2502 \t \u2514 groupmap:").append(((Map)this.groups.getGroupmap().getObj()).size());
        builder.append("\r\n \u2514 \u62c9\u9ed1IP ");
        if (this.ipBlacklist != null) {
            builder.append("\r\n   \t \u2514 ").append(AppendJsonConverter.convertCollectionStringToJson(this.ipBlacklist.getAll()));
        }
        builder.append("\r\n \u2514 \u6b63\u5728\u5904\u7406\u7684\u8bf7\u6c42\u6570\u91cf: ").append(this.getCacheFactory().getCache("reqeust_processing").keysCollection().size());
        log.warn(builder.toString());
        long end = SystemTimer.currTime;
        long iv1 = start1 - start;
        long iv = end - start1;
        log.warn("{}, \u68c0\u67e5\u5fc3\u8df3, \u5171{}\u4e2a\u8fde\u63a5, \u53d6\u9501\u8017\u65f6{}ms, \u5faa\u73af\u8017\u65f6{}ms, \u5fc3\u8df3\u8d85\u65f6\u65f6\u95f4:{}ms", new Object[]{this.name, count, iv1, iv, this.heartbeatTimeout});
    }
}

