/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.server;

import com.litongjava.enhance.buffer.VirtualBuffer;
import com.litongjava.tio.core.ReadCompletionHandler;
import com.litongjava.tio.core.pool.BufferPageUtils;
import com.litongjava.tio.core.ssl.SslUtils;
import com.litongjava.tio.core.stat.IpStat;
import com.litongjava.tio.core.utils.IpBlacklistUtils;
import com.litongjava.tio.server.ServerChannelContext;
import com.litongjava.tio.server.ServerGroupStat;
import com.litongjava.tio.server.ServerTioConfig;
import com.litongjava.tio.server.TioServer;
import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.CollUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.CompletionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptCompletionHandler
implements CompletionHandler<AsynchronousSocketChannel, TioServer> {
    private static final Logger log = LoggerFactory.getLogger(AcceptCompletionHandler.class);
    private static final boolean DIAGNOSTIC_LOG_ENABLED = EnvUtils.getBoolean((String)"tio.core.diagnostic", (boolean)false);

    @Override
    public void completed(AsynchronousSocketChannel clientSocketChannel, TioServer tioServer) {
        AsynchronousServerSocketChannel serverSocketChannel = tioServer.getServerSocketChannel();
        if (tioServer.isWaitingStop()) {
            log.info("The server will be shut down and no new requests will be accepted:{}", (Object)tioServer.getServerNode());
        } else {
            serverSocketChannel.accept(tioServer, this);
        }
        if (serverSocketChannel == null) {
            log.info("receive serverSocketChannel is null skip");
            return;
        }
        if (!serverSocketChannel.isOpen()) {
            log.info("receive serverSocketChannel is not open skip");
            return;
        }
        String clientIp = null;
        int port = 0;
        try {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)clientSocketChannel.getRemoteAddress();
            clientIp = inetSocketAddress.getHostString();
            port = inetSocketAddress.getPort();
            if (DIAGNOSTIC_LOG_ENABLED) {
                log.info("new connection:{},{}", (Object)clientIp, (Object)port);
            }
        }
        catch (IOException e1) {
            log.error("Failed to get client ip and port", (Throwable)e1);
            try {
                clientSocketChannel.close();
            }
            catch (Exception closeEx) {
                log.error("Failed to close socket after exception", (Throwable)closeEx);
            }
            return;
        }
        ServerTioConfig serverTioConfig = tioServer.getServerTioConfig();
        try {
            if (IpBlacklistUtils.isInBlacklist(serverTioConfig, clientIp)) {
                log.info("{} on the blacklist, {}", (Object)clientIp, (Object)serverTioConfig.getName());
                clientSocketChannel.close();
                return;
            }
            if (serverTioConfig.statOn) {
                ((ServerGroupStat)serverTioConfig.groupStat).accepted.incrementAndGet();
            }
            clientSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            clientSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_RCVBUF, (Object)65536);
            clientSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)65536);
            clientSocketChannel.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            ServerChannelContext channelContext = new ServerChannelContext(serverTioConfig, clientSocketChannel, clientIp, port);
            channelContext.setClosed(false);
            channelContext.stat.setTimeFirstConnected(SystemTimer.currTime);
            channelContext.setServerNode(tioServer.getServerNode());
            boolean isConnected = true;
            boolean isReconnect = false;
            if (serverTioConfig.getServerAioListener() != null && !SslUtils.isSsl(channelContext.tioConfig)) {
                try {
                    serverTioConfig.getServerAioListener().onAfterConnected(channelContext, isConnected, isReconnect);
                }
                catch (Throwable e) {
                    log.error("ServerAioListener onAfterConnected:", e);
                }
            }
            if (CollUtil.isNotEmpty(serverTioConfig.ipStats.durationList)) {
                try {
                    for (Long v : serverTioConfig.ipStats.durationList) {
                        IpStat ipStat = serverTioConfig.ipStats.get(v, channelContext);
                        ipStat.getRequestCount().incrementAndGet();
                        serverTioConfig.getIpStatListener().onAfterConnected(channelContext, isConnected, isReconnect, ipStat);
                    }
                }
                catch (Exception e) {
                    log.error("IpStatListener onAfterConnected:", (Throwable)e);
                }
            }
            if (!tioServer.isWaitingStop()) {
                ReadCompletionHandler readCompletionHandler = new ReadCompletionHandler(channelContext);
                VirtualBuffer attachment = BufferPageUtils.allocate(channelContext.getReadBufferSize());
                ByteBuffer readByteBuffer = attachment.buffer();
                readByteBuffer.position(0);
                readByteBuffer.limit(readByteBuffer.capacity());
                clientSocketChannel.read(readByteBuffer, attachment, readCompletionHandler);
            }
        }
        catch (Throwable e) {
            log.error("Failed to read data from :{},{}", new Object[]{clientIp, port, e});
        }
    }

    @Override
    public void failed(Throwable exc, TioServer tioServer) {
        if (tioServer.isWaitingStop()) {
            log.info("The server will be shut down and no new requests will be accepted:{}", (Object)tioServer.getServerNode());
        } else {
            AsynchronousServerSocketChannel serverSocketChannel = tioServer.getServerSocketChannel();
            serverSocketChannel.accept(tioServer, this);
            log.error("[" + tioServer.getServerNode() + "] listening exception", exc);
        }
    }
}

