/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.utils;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Tio;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioUtils {
    private static final Logger log = LoggerFactory.getLogger(TioUtils.class);

    public static boolean checkBeforeIO(ChannelContext channelContext) {
        if (channelContext.isWaitingClose) {
            return false;
        }
        Boolean isopen = null;
        if (channelContext.asynchronousSocketChannel != null) {
            isopen = channelContext.asynchronousSocketChannel.isOpen();
            if (channelContext.isClosed || channelContext.isRemoved) {
                if (isopen.booleanValue()) {
                    try {
                        Tio.close(channelContext, "asynchronousSocketChannel is open, but channelContext isClosed: " + channelContext.isClosed + ", isRemoved: " + channelContext.isRemoved, ChannelContext.CloseCode.CHANNEL_NOT_OPEN);
                    }
                    catch (Throwable e) {
                        log.error(e.toString(), e);
                    }
                }
                return false;
            }
        } else {
            log.error("{}, Plese check, asynchronousSocketChannel is null, isClosed:{}, isRemoved:{}, {} ", new Object[]{channelContext, channelContext.isClosed, channelContext.isRemoved});
            return false;
        }
        if (!isopen.booleanValue()) {
            log.info("connection might close by peer,{}, isOpen:{}, isClosed:{}, isRemoved:{}", new Object[]{channelContext, isopen, channelContext.isClosed, channelContext.isRemoved});
            Tio.close(channelContext, "asynchronousSocketChannel is not open, connection might close by peer", ChannelContext.CloseCode.CHANNEL_NOT_OPEN);
            return false;
        }
        return true;
    }
}

