/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.udp.task;

import com.litongjava.tio.core.udp.UdpConf;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpSendRunnable
implements Runnable {
    private static Logger log = LoggerFactory.getLogger(UdpSendRunnable.class);
    private LinkedBlockingQueue<DatagramPacket> queue;
    private UdpConf udpConf;
    private boolean isStopped = false;
    private DatagramSocket datagramSocket;

    public UdpSendRunnable(LinkedBlockingQueue<DatagramPacket> queue, UdpConf udpConf, DatagramSocket datagramSocket) {
        this.queue = queue;
        this.udpConf = udpConf;
        this.datagramSocket = datagramSocket;
    }

    @Override
    public void run() {
        DatagramSocket datagramSocket = this.datagramSocket;
        while (!this.isStopped) {
            try {
                DatagramPacket datagramPacket = this.queue.take();
                if (datagramSocket == null) {
                    datagramSocket = new DatagramSocket();
                    datagramSocket.setSoTimeout(this.udpConf.getTimeout());
                }
                datagramSocket.send(datagramPacket);
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
            finally {
                if (this.queue.size() != 0 || this.datagramSocket != null || datagramSocket == null) continue;
                datagramSocket.close();
                datagramSocket = null;
            }
        }
    }

    public void stop() {
        this.isStopped = true;
    }
}

