/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.ssl.facade;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.ssl.SslVo;
import com.litongjava.tio.core.ssl.facade.Buffers;
import com.litongjava.tio.core.ssl.facade.Handshaker;
import com.litongjava.tio.core.ssl.facade.IHandshakeCompletedListener;
import com.litongjava.tio.core.ssl.facade.ISSLFacade;
import com.litongjava.tio.core.ssl.facade.ISSLListener;
import com.litongjava.tio.core.ssl.facade.ISessionClosedListener;
import com.litongjava.tio.core.ssl.facade.ITaskHandler;
import com.litongjava.tio.core.ssl.facade.Worker;
import com.litongjava.tio.core.utils.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLFacade
implements ISSLFacade {
    private static final Logger log = LoggerFactory.getLogger(SSLFacade.class);
    private AtomicLong sslSeq = new AtomicLong();
    private Handshaker _handshaker;
    private IHandshakeCompletedListener _hcl;
    private final Worker _worker;
    private boolean _clientMode;
    private ChannelContext channelContext;

    public SSLFacade(ChannelContext channelContext, SSLContext context, boolean client, boolean clientAuthRequired, ITaskHandler taskHandler) {
        this.channelContext = channelContext;
        String who = client ? "client" : "server";
        SSLEngine engine = this.makeSSLEngine(context, client, clientAuthRequired);
        Buffers buffers = new Buffers(engine.getSession(), channelContext);
        this._worker = new Worker(who, engine, buffers, channelContext);
        this._handshaker = new Handshaker(client, this._worker, taskHandler, channelContext);
        this._clientMode = client;
    }

    @Override
    public boolean isClientMode() {
        return this._clientMode;
    }

    @Override
    public void setHandshakeCompletedListener(IHandshakeCompletedListener hcl) {
        this._hcl = hcl;
        this.attachCompletionListener();
    }

    @Override
    public void setSSLListener(ISSLListener l) {
        this._worker.setSSLListener(l);
    }

    @Override
    public void setCloseListener(ISessionClosedListener l) {
        this._worker.setSessionClosedListener(l);
    }

    @Override
    public void beginHandshake() throws SSLException {
        this._handshaker.begin();
    }

    @Override
    public boolean isHandshakeCompleted() {
        return this._handshaker == null || this._handshaker.isFinished();
    }

    @Override
    public void encrypt(SslVo sslVo) throws SSLException {
        long seq = this.sslSeq.incrementAndGet();
        ByteBuffer src = sslVo.getByteBuffer();
        ByteBuffer[] byteBuffers = ByteBufferUtils.split(src, 8192);
        if (byteBuffers == null) {
            log.debug("{}, \u51c6\u5907, SSL\u52a0\u5bc6{}, \u660e\u6587:{}", new Object[]{this.channelContext, this.channelContext.getId() + "_" + seq, sslVo});
            SSLEngineResult result = this._worker.wrap(sslVo, sslVo.getByteBuffer());
            log.debug("{}, \u5b8c\u6210, SSL\u52a0\u5bc6{}, \u660e\u6587:{}, \u7ed3\u679c:{}", new Object[]{this.channelContext, this.channelContext.getId() + "_" + seq, sslVo, result});
        } else {
            log.debug("{}, \u51c6\u5907, SSL\u52a0\u5bc6{}, \u5305\u8fc7\u5927\uff0c\u88ab\u62c6\u6210\u4e86[{}]\u4e2a\u5305\u8fdb\u884c\u53d1\u9001, \u660e\u6587:{}", new Object[]{this.channelContext, this.channelContext.getId() + "_" + seq, byteBuffers.length, sslVo});
            ByteBuffer[] encryptedByteBuffers = new ByteBuffer[byteBuffers.length];
            int alllen = 0;
            for (int i = 0; i < byteBuffers.length; ++i) {
                ByteBuffer encryptedByteBuffer;
                SslVo sslVo1 = new SslVo(byteBuffers[i], sslVo.getObj());
                SSLEngineResult result = this._worker.wrap(sslVo1, byteBuffers[i]);
                encryptedByteBuffers[i] = encryptedByteBuffer = sslVo1.getByteBuffer();
                alllen += encryptedByteBuffer.limit();
                log.debug("{}, \u5b8c\u6210, SSL\u52a0\u5bc6{}, \u660e\u6587:{}, \u62c6\u5305[{}]\u7684\u7ed3\u679c:{}", new Object[]{this.channelContext, this.channelContext.getId() + "_" + seq, sslVo, i + 1, result});
            }
            ByteBuffer encryptedByteBuffer = ByteBuffer.allocate(alllen);
            for (int i = 0; i < encryptedByteBuffers.length; ++i) {
                encryptedByteBuffer.put(encryptedByteBuffers[i]);
            }
            encryptedByteBuffer.flip();
            sslVo.setByteBuffer(encryptedByteBuffer);
        }
    }

    @Override
    public void decrypt(ByteBuffer byteBuffer) throws SSLException {
        long seq = this.sslSeq.incrementAndGet();
        log.debug("{}, \u51c6\u5907, SSL\u89e3\u5bc6{}, \u5bc6\u6587:{}", new Object[]{this.channelContext, this.channelContext.getId() + "_" + seq, byteBuffer});
        SSLEngineResult result = this._worker.unwrap(byteBuffer);
        log.debug("{}, \u5b8c\u6210, SSL\u89e3\u5bc6{}, \u5bc6\u6587:{}, \u7ed3\u679c:{}", new Object[]{this.channelContext, this.channelContext.getId() + "_" + seq, byteBuffer, result});
        this._handshaker.handleUnwrapResult(result);
    }

    @Override
    public void close() {
        this._worker.close(true);
    }

    @Override
    public boolean isCloseCompleted() {
        return this._worker.isCloseCompleted();
    }

    @Override
    public void terminate() {
        this._worker.close(false);
    }

    private void attachCompletionListener() {
        this._handshaker.addCompletedListener(new IHandshakeCompletedListener(){

            @Override
            public void onComplete() {
                if (SSLFacade.this._hcl != null) {
                    SSLFacade.this._hcl.onComplete();
                    SSLFacade.this._hcl = null;
                }
            }
        });
    }

    private SSLEngine makeSSLEngine(SSLContext context, boolean client, boolean clientAuthRequired) {
        SSLEngine engine = context.createSSLEngine();
        engine.setUseClientMode(client);
        engine.setNeedClientAuth(clientAuthRequired);
        return engine;
    }
}

