/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.ssl;

import com.litongjava.aio.Packet;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.ssl.facade.IHandshakeCompletedListener;
import com.litongjava.tio.core.task.AfterSslHandshakeCompleted;
import com.litongjava.tio.core.task.SendPacketTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslHandshakeCompletedListener
implements IHandshakeCompletedListener {
    private static Logger log = LoggerFactory.getLogger(SslHandshakeCompletedListener.class);
    private ChannelContext channelContext;

    public SslHandshakeCompletedListener(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    @Override
    public void onComplete() {
        Packet packet;
        ConcurrentLinkedQueue<Packet> forSendAfterSslHandshakeCompleted;
        log.info("{}, Complete SSL handshake", (Object)this.channelContext);
        this.channelContext.sslFacadeContext.setHandshakeCompleted(true);
        if (this.channelContext.tioConfig.getAioListener() != null) {
            try {
                this.channelContext.tioConfig.getAioListener().onAfterConnected(this.channelContext, true, this.channelContext.isReconnect);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
        if ((forSendAfterSslHandshakeCompleted = new AfterSslHandshakeCompleted().getForSendAfterSslHandshakeCompleted(false)) == null || forSendAfterSslHandshakeCompleted.size() == 0) {
            return;
        }
        log.info("{} There are {} data items pending transmission at the business layer before the SSL handshake", (Object)this.channelContext, (Object)forSendAfterSslHandshakeCompleted.size());
        while ((packet = forSendAfterSslHandshakeCompleted.poll()) != null) {
            new SendPacketTask(this.channelContext).sendPacket(packet);
        }
    }
}

