/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.ssl;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.ssl.SslHandshakeCompletedListener;
import com.litongjava.tio.core.ssl.SslListener;
import com.litongjava.tio.core.ssl.SslSessionClosedListener;
import com.litongjava.tio.core.ssl.facade.DefaultTaskHandler;
import com.litongjava.tio.core.ssl.facade.ISSLFacade;
import com.litongjava.tio.core.ssl.facade.SSLFacade;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslFacadeContext {
    private static Logger log = LoggerFactory.getLogger(SslFacadeContext.class);
    private ChannelContext channelContext = null;
    private SSLContext sslContext;
    private ISSLFacade sslFacade = null;
    private boolean isHandshakeCompleted = false;

    public SslFacadeContext(ChannelContext channelContext) throws Exception {
        this.channelContext = channelContext;
        this.channelContext.setSslFacadeContext(this);
        this.isHandshakeCompleted = false;
        this.sslContext = SSLContext.getInstance("TLS");
        KeyManager[] keyManagers = channelContext.tioConfig.sslConfig.getKeyManagerFactory().getKeyManagers();
        TrustManager[] trustManagers = channelContext.tioConfig.sslConfig.getTrustManagerFactory().getTrustManagers();
        this.sslContext.init(keyManagers, trustManagers, null);
        DefaultTaskHandler taskHandler = new DefaultTaskHandler();
        boolean isClient = true;
        if (this.channelContext.isServer()) {
            isClient = false;
        }
        this.sslFacade = new SSLFacade(this.channelContext, this.sslContext, isClient, false, taskHandler);
        this.sslFacade.setHandshakeCompletedListener(new SslHandshakeCompletedListener(this.channelContext));
        this.sslFacade.setSSLListener(new SslListener(this.channelContext));
        this.sslFacade.setCloseListener(new SslSessionClosedListener(this.channelContext));
    }

    public void beginHandshake() throws Exception {
        log.info("Start SSL Handshake {}", (Object)this.channelContext);
        this.sslFacade.beginHandshake();
    }

    public boolean isHandshakeCompleted() {
        return this.isHandshakeCompleted;
    }

    public void setHandshakeCompleted(boolean isHandshakeCompleted) {
        this.isHandshakeCompleted = isHandshakeCompleted;
    }

    public ChannelContext getChannelContext() {
        return this.channelContext;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public ISSLFacade getSslFacade() {
        return this.sslFacade;
    }
}

