/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.ssl;

import com.litongjava.tio.utils.hutool.ResourceUtil;
import com.litongjava.tio.utils.hutool.StrUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public class SslConfig {
    private InputStream keyStoreInputStream = null;
    private InputStream trustStoreInputStream = null;
    private String passwd = null;
    private KeyManagerFactory keyManagerFactory;
    private TrustManagerFactory trustManagerFactory;

    private SslConfig(InputStream keyStoreInputStream, InputStream trustStoreInputStream, String passwd) throws Exception {
        this.keyStoreInputStream = keyStoreInputStream;
        this.trustStoreInputStream = trustStoreInputStream;
        this.passwd = passwd;
        this.init();
    }

    public static SslConfig forServer(String keyStoreFile, String trustStoreFile, String passwd) throws Exception {
        InputStream keyStoreInputStream = null;
        InputStream trustStoreInputStream = null;
        keyStoreInputStream = StrUtil.startWithIgnoreCase((CharSequence)keyStoreFile, (CharSequence)"classpath:") ? ResourceUtil.getResourceAsStream((String)keyStoreFile) : new FileInputStream(keyStoreFile);
        trustStoreInputStream = StrUtil.startWithIgnoreCase((CharSequence)trustStoreFile, (CharSequence)"classpath:") ? ResourceUtil.getResourceAsStream((String)trustStoreFile) : new FileInputStream(trustStoreFile);
        return SslConfig.forServer(keyStoreInputStream, trustStoreInputStream, passwd);
    }

    public static SslConfig forServer(InputStream keyStoreInputStream, InputStream trustStoreInputStream, String passwd) throws Exception {
        SslConfig sslConfig = new SslConfig(keyStoreInputStream, trustStoreInputStream, passwd);
        return sslConfig;
    }

    public static SslConfig forClient() throws Exception {
        SslConfig sslConfig = new SslConfig(null, null, null);
        return sslConfig;
    }

    public void init() throws Exception {
        KeyStore keyStore = null;
        KeyStore trustStore = null;
        char[] passChars = null;
        if (this.passwd != null) {
            passChars = this.passwd.toCharArray();
        }
        if (this.keyStoreInputStream != null) {
            keyStore = KeyStore.getInstance("JKS");
            keyStore.load(this.keyStoreInputStream, passChars);
        }
        if (this.trustStoreInputStream != null) {
            trustStore = KeyStore.getInstance("JKS");
            trustStore.load(this.trustStoreInputStream, passChars);
        }
        this.keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
        this.keyManagerFactory.init(keyStore, passChars);
        this.trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
        this.trustManagerFactory.init(trustStore);
    }

    public KeyManagerFactory getKeyManagerFactory() {
        return this.keyManagerFactory;
    }

    public void setKeyManagerFactory(KeyManagerFactory keyManagerFactory) {
        this.keyManagerFactory = keyManagerFactory;
    }

    public TrustManagerFactory getTrustManagerFactory() {
        return this.trustManagerFactory;
    }

    public void setTrustManagerFactory(TrustManagerFactory trustManagerFactory) {
        this.trustManagerFactory = trustManagerFactory;
    }
}

