/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.maintain;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.lock.LockUtils;
import com.litongjava.tio.utils.lock.MapWithLock;
import com.litongjava.tio.utils.lock.SetWithLock;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Users {
    private static Logger log = LoggerFactory.getLogger(Users.class);
    private MapWithLock<String, SetWithLock<ChannelContext>> mapStrWithLock = new MapWithLock();

    public void bind(String userId, ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)userId)) {
            return;
        }
        try {
            SetWithLock setWithLock = (SetWithLock)this.mapStrWithLock.get((Object)userId);
            if (setWithLock == null) {
                LockUtils.runWriteOrWaitRead((String)("_tio_users_bind__" + userId), (Object)this, () -> {
                    if (this.mapStrWithLock.get((Object)userId) == null) {
                        this.mapStrWithLock.put((Object)userId, (Object)new SetWithLock(new HashSet()));
                    }
                });
                setWithLock = (SetWithLock)this.mapStrWithLock.get((Object)userId);
            }
            setWithLock.add((Object)channelContext);
            channelContext.setUserId(userId);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public SetWithLock<ChannelContext> find(TioConfig tioConfig, String userid) {
        if (tioConfig.isShortConnection) {
            return null;
        }
        if (StrUtil.isBlank((CharSequence)userid)) {
            return null;
        }
        return (SetWithLock)this.mapStrWithLock.get((Object)userid);
    }

    public MapWithLock<String, SetWithLock<ChannelContext>> getMap() {
        return this.mapStrWithLock;
    }

    public void unbind(ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        String userid = channelContext.userId;
        if (StrUtil.isBlank((CharSequence)userid)) {
            log.debug("{}, {}, unbind user", (Object)channelContext.tioConfig.getName(), (Object)channelContext.toString());
            return;
        }
        try {
            SetWithLock setWithLock = (SetWithLock)this.mapStrWithLock.get((Object)userid);
            if (setWithLock == null) {
                log.warn("{}, {}, userid:{}, can't find SetWithLock", new Object[]{channelContext.tioConfig.getName(), channelContext.toString(), userid});
                return;
            }
            setWithLock.remove((Object)channelContext);
            if (setWithLock.size() == 0) {
                this.mapStrWithLock.remove((Object)userid);
            }
            channelContext.setUserId(null);
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(TioConfig tioConfig, String userid) {
        if (tioConfig.isShortConnection) {
            return;
        }
        if (StrUtil.isBlank((CharSequence)userid)) {
            return;
        }
        try {
            ReentrantReadWriteLock.WriteLock lock = this.mapStrWithLock.writeLock();
            lock.lock();
            try {
                Map m = (Map)this.mapStrWithLock.getObj();
                SetWithLock setWithLock = (SetWithLock)m.get(userid);
                if (setWithLock == null) {
                    return;
                }
                ReentrantReadWriteLock.WriteLock writeLock = setWithLock.writeLock();
                writeLock.lock();
                try {
                    Set set = (Set)setWithLock.getObj();
                    if (set.size() > 0) {
                        for (ChannelContext channelContext : set) {
                            channelContext.setUserId(null);
                        }
                        set.clear();
                    }
                    m.remove(userid);
                    writeLock.unlock();
                }
                catch (Throwable e) {
                    try {
                        log.error(e.getMessage(), e);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        writeLock.unlock();
                    }
                }
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                lock.unlock();
            }
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
    }
}

