/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.maintain;

import com.litongjava.tio.client.ClientTioConfig;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.utils.hutool.FileUtil;
import java.io.File;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaintainUtils {
    private static final Logger log = LoggerFactory.getLogger(MaintainUtils.class);
    public static final String TEMP_DIR = "TIO_TEMP_FILE/";

    public static void remove(ChannelContext channelContext) {
        TioConfig tioConfig = channelContext.tioConfig;
        if (!tioConfig.isServer()) {
            ClientTioConfig clientTioConfig = (ClientTioConfig)tioConfig;
            clientTioConfig.closeds.remove((Object)channelContext);
            clientTioConfig.connecteds.remove((Object)channelContext);
        }
        tioConfig.connections.remove((Object)channelContext);
        if (channelContext.isBind) {
            tioConfig.ips.unbind(channelContext);
            tioConfig.ids.unbind(channelContext);
            MaintainUtils.close(channelContext);
        }
    }

    public static void close(ChannelContext channelContext) {
        TioConfig tioConfig = channelContext.tioConfig;
        tioConfig.users.unbind(channelContext);
        tioConfig.tokens.unbind(channelContext);
        tioConfig.groups.unbind(channelContext);
        tioConfig.bsIds.unbind(channelContext);
        MaintainUtils.deleteTempDir(channelContext);
    }

    public static Set<ChannelContext> createSet(Comparator<ChannelContext> comparator) {
        if (comparator == null) {
            return new HashSet<ChannelContext>();
        }
        return new TreeSet<ChannelContext>(comparator);
    }

    public static void deleteTempDir(ChannelContext channelContext) {
        if (channelContext.hasTempDir) {
            try {
                File dirFile = MaintainUtils.tempDir(channelContext, false);
                FileUtil.del((File)dirFile);
            }
            catch (Exception e) {
                log.error(e.toString(), (Throwable)e);
            }
        }
    }

    public static File tempDir(ChannelContext channelContext, boolean forceCreate) {
        File dirFile = new File(TEMP_DIR + channelContext.tioConfig.getId() + "/" + channelContext.getId());
        if (!dirFile.exists()) {
            if (forceCreate) {
                dirFile.mkdirs();
                channelContext.hasTempDir = true;
            }
        } else {
            channelContext.hasTempDir = true;
        }
        return dirFile;
    }

    public static File tempReceivedFile(ChannelContext channelContext) {
        File tempDir = MaintainUtils.tempDir(channelContext, true);
        File tempReceivedFile = new File(tempDir, "received");
        return tempReceivedFile;
    }

    public static File tempWriteFile(ChannelContext channelContext) {
        File tempDir = MaintainUtils.tempDir(channelContext, true);
        File tempReceivedFile = new File(tempDir, "write");
        return tempReceivedFile;
    }
}

