/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.maintain;

import com.litongjava.model.time.Time;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.server.ServerTioConfig;
import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheFactory;
import java.io.Serializable;
import java.util.Collection;
import java.util.function.Consumer;

public class IpBlacklist {
    private String id;
    private static final String CACHE_NAME_PREFIX = "TIO_IP_BLACK_LIST";
    private static final Long TIME_TO_LIVE_SECONDS = Time.DAY_1 * 120L;
    private static final Long TIME_TO_IDLE_SECONDS = null;
    private String cacheName = null;
    private AbsCache cache = null;
    private ServerTioConfig serverTioConfig;

    public IpBlacklist(ServerTioConfig serverTioConfig) {
        this.id = "__global__";
        this.serverTioConfig = serverTioConfig;
        this.cacheName = CACHE_NAME_PREFIX + this.id;
        CacheFactory cacheFactory = serverTioConfig.getCacheFactory();
        this.cache = cacheFactory.register(this.cacheName, TIME_TO_LIVE_SECONDS, TIME_TO_IDLE_SECONDS, null);
    }

    public IpBlacklist(String id, ServerTioConfig serverTioConfig) {
        this.id = id;
        this.serverTioConfig = serverTioConfig;
        this.cacheName = CACHE_NAME_PREFIX + this.id;
        this.cache = serverTioConfig.getCacheFactory().register(this.cacheName, TIME_TO_LIVE_SECONDS, TIME_TO_IDLE_SECONDS, null);
    }

    public boolean add(final String ip) {
        this.cache.put(ip, (Serializable)Long.valueOf(SystemTimer.currTime));
        if (this.serverTioConfig != null) {
            Tio.remove(this.serverTioConfig, ip, "ip[" + ip + "]\u88ab\u52a0\u5165\u4e86\u9ed1\u540d\u5355, " + this.serverTioConfig.getName());
        } else {
            TioConfig.ALL_SERVER_GROUPCONTEXTS.stream().forEach(new Consumer<ServerTioConfig>(){

                @Override
                public void accept(ServerTioConfig tioConfig) {
                    Tio.remove(tioConfig, ip, "ip[" + ip + "]\u88ab\u52a0\u5165\u4e86\u9ed1\u540d\u5355, " + tioConfig.getName());
                }
            });
        }
        return true;
    }

    public void clear() {
        this.cache.clear();
    }

    public Collection<String> getAll() {
        return this.cache.keysCollection();
    }

    public boolean isInBlacklist(String ip) {
        return this.cache.get(ip) != null;
    }

    public void remove(String ip) {
        this.cache.remove(ip);
    }
}

