/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core.maintain;

import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Node;
import com.litongjava.tio.utils.lock.MapWithLock;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientNodes {
    private static final Logger log = LoggerFactory.getLogger(ClientNodes.class);
    private final MapWithLock<Node, ChannelContext> mapWithLock = new MapWithLock();

    public static Node getKey(ChannelContext channelContext) {
        Node clientNode = channelContext.getClientNode();
        return Objects.requireNonNull(clientNode, "client node is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelContext find(Node clientNode) {
        ReentrantReadWriteLock.ReadLock lock = this.mapWithLock.readLock();
        lock.lock();
        try {
            Map m = (Map)this.mapWithLock.getObj();
            ChannelContext channelContext = (ChannelContext)((Object)m.get(clientNode));
            return channelContext;
        }
        finally {
            lock.unlock();
        }
    }

    public ChannelContext find(String ip, int port) {
        return this.find(new Node(ip, port));
    }

    public MapWithLock<Node, ChannelContext> getObjWithLock() {
        return this.mapWithLock;
    }

    public void put(ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        try {
            Node clientNode = ClientNodes.getKey(channelContext);
            this.mapWithLock.put((Object)clientNode, (Object)channelContext);
        }
        catch (Exception e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public void remove(ChannelContext channelContext) {
        if (channelContext.tioConfig.isShortConnection) {
            return;
        }
        try {
            Node clientNode = ClientNodes.getKey(channelContext);
            this.mapWithLock.remove((Object)clientNode);
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
    }
}

