/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.core;

import com.litongjava.aio.Packet;
import com.litongjava.aio.PacketMeta;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.core.Tio;
import com.litongjava.tio.core.TioConfig;
import com.litongjava.tio.core.stat.IpStat;
import com.litongjava.tio.core.task.SendPacketTask;
import com.litongjava.tio.core.vo.WriteCompletionVo;
import com.litongjava.tio.utils.SystemTimer;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.CollUtil;
import java.nio.channels.CompletionHandler;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriteCompletionHandler
implements CompletionHandler<Integer, WriteCompletionVo> {
    private static final Logger log = LoggerFactory.getLogger(WriteCompletionHandler.class);
    private static final boolean DIAGNOSTIC_LOG_ENABLED = EnvUtils.getBoolean((String)"tio.core.diagnostic", (boolean)false);
    private ChannelContext channelContext = null;

    public WriteCompletionHandler(ChannelContext channelContext) {
        this.channelContext = channelContext;
    }

    @Override
    public void completed(Integer bytesWritten, WriteCompletionVo writeCompletionVo) {
        if (EnvUtils.getBoolean((String)"tio.core.diagnostic", (boolean)false)) {
            log.info("write:{},{}", (Object)this.channelContext.getClientNode(), (Object)bytesWritten);
        }
        if (bytesWritten > 0) {
            this.channelContext.stat.latestTimeOfSentByte = SystemTimer.currTime;
        }
        if (writeCompletionVo.getByteBuffer().hasRemaining()) {
            this.channelContext.asynchronousSocketChannel.write(writeCompletionVo.getByteBuffer(), writeCompletionVo, this);
        } else {
            this.handle(bytesWritten, null, writeCompletionVo);
            this.processNextPacket(this.channelContext);
        }
    }

    @Override
    public void failed(Throwable throwable, WriteCompletionVo writeCompletionVo) {
        this.handle(0, throwable, writeCompletionVo);
        this.processNextPacket(this.channelContext);
    }

    private void processNextPacket(ChannelContext channelContext) {
        channelContext.isSending.set(false);
        new SendPacketTask(channelContext).processSendQueue();
    }

    public void handle(Integer bytesWritten, Throwable throwable, WriteCompletionVo writeCompletionVo) {
        boolean isSentSuccess;
        this.channelContext.stat.latestTimeOfSentPacket = SystemTimer.currTime;
        Object attachment = writeCompletionVo.getObj();
        TioConfig tioConfig = this.channelContext.tioConfig;
        boolean bl = isSentSuccess = bytesWritten > 0;
        if (isSentSuccess) {
            if (tioConfig.statOn) {
                tioConfig.groupStat.sentBytes.addAndGet(bytesWritten.intValue());
                this.channelContext.stat.sentBytes.addAndGet(bytesWritten.intValue());
            }
            if (CollUtil.isNotEmpty(tioConfig.ipStats.durationList)) {
                for (Long l : tioConfig.ipStats.durationList) {
                    IpStat ipStat = this.channelContext.tioConfig.ipStats.get(l, this.channelContext);
                    ipStat.getSentBytes().addAndGet(bytesWritten.intValue());
                }
            }
        }
        try {
            boolean isPacket = attachment instanceof Packet;
            if (isPacket) {
                if (isSentSuccess && CollUtil.isNotEmpty(tioConfig.ipStats.durationList)) {
                    for (Long v : tioConfig.ipStats.durationList) {
                        IpStat ipStat = this.channelContext.tioConfig.ipStats.get(v, this.channelContext);
                        ipStat.getSentPackets().incrementAndGet();
                    }
                }
                this.handleOne(bytesWritten, throwable, (Packet)attachment, isSentSuccess);
            } else {
                List list = (List)attachment;
                for (Object obj : list) {
                    this.handleOne(bytesWritten, throwable, (Packet)obj, isSentSuccess);
                }
            }
            if (!isSentSuccess) {
                Tio.close(this.channelContext, throwable, "Write data return:" + bytesWritten, ChannelContext.CloseCode.WRITE_COUNT_IS_NEGATIVE);
            }
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
    }

    public void handleOne(Integer result, Throwable throwable, Packet packet, Boolean isSentSuccess) {
        PacketMeta meta = packet.getMeta();
        if (meta != null) {
            meta.setIsSentSuccess(isSentSuccess);
            if (meta.getCountDownLatch() != null) {
                meta.getCountDownLatch().countDown();
            }
        }
        try {
            this.channelContext.processAfterSent(packet, isSentSuccess);
        }
        catch (Throwable e) {
            log.error(e.toString(), e);
        }
        if (!packet.isKeepConnection()) {
            String msg = "remove conneciton because KeepedConnection is false:" + packet.logstr();
            if (DIAGNOSTIC_LOG_ENABLED) {
                log.info(msg);
            }
            Tio.close(this.channelContext, msg);
        }
    }
}

