/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.websocket;

import com.litongjava.tio.boot.exception.TioBootExceptionHandler;
import com.litongjava.tio.boot.server.TioBootServer;
import com.litongjava.tio.boot.websocket.WebSocketRouter;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.websocket.common.WebSocketRequest;
import com.litongjava.tio.websocket.common.WebSocketSessionContext;
import com.litongjava.tio.websocket.server.handler.IWebSocketHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioBootWebSocketDispatcher
implements IWebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(TioBootWebSocketDispatcher.class);
    private WebSocketRouter webSocketRouter = null;

    public void setWebSocketRouter(WebSocketRouter webSocketRouter) {
        this.webSocketRouter = webSocketRouter;
    }

    public HttpResponse handshake(HttpRequest httpRequest, HttpResponse httpResponse, ChannelContext channelContext) throws Exception {
        String path = httpRequest.getRequestLine().getPath();
        if (this.webSocketRouter == null) {
            return null;
        }
        IWebSocketHandler handler = this.webSocketRouter.find(path);
        if (handler != null) {
            HttpResponse handshake = null;
            try {
                handshake = handler.handshake(httpRequest, httpResponse, channelContext);
            }
            catch (Exception e) {
                this.httpErrorHandler(httpRequest, e);
            }
            return handshake;
        }
        HttpResponse response = new HttpResponse(httpRequest);
        response.setStatus(404);
        return response;
    }

    public void onAfterHandshaked(HttpRequest httpRequest, HttpResponse httpResponse, ChannelContext channelContext) throws Exception {
        String path = httpRequest.getRequestLine().getPath();
        if (this.webSocketRouter == null) {
            log.error("webSocketRoutes is null,please check");
            return;
        }
        IWebSocketHandler handler = this.webSocketRouter.find(path);
        if (handler != null) {
            try {
                handler.onAfterHandshaked(httpRequest, httpResponse, channelContext);
            }
            catch (Exception e) {
                this.httpErrorHandler(httpRequest, e);
            }
        }
    }

    public Object onBytes(WebSocketRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        Object result;
        block3: {
            WebSocketSessionContext wsSessionContext = (WebSocketSessionContext)channelContext.get();
            HttpRequest httpRequest = wsSessionContext.getHandshakeRequest();
            String path = httpRequest.getRequestLine().path;
            if (this.webSocketRouter == null) {
                log.error("webSocket router is null,please check");
                return null;
            }
            IWebSocketHandler handler = this.webSocketRouter.find(path);
            result = null;
            try {
                result = handler.onBytes(wsRequest, bytes, channelContext);
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                sb.append("\r\n").append("Remote Address: ").append(httpRequest.getClientIp());
                sb.append("\r\n").append("Request: ").append(httpRequest.getRequestLine().toString());
                log.error(sb.toString(), (Throwable)e);
                TioBootExceptionHandler exceptionHandler = TioBootServer.me().getExceptionHandler();
                if (exceptionHandler == null) break block3;
                exceptionHandler.wsBytesHandler(wsRequest, bytes, channelContext, httpRequest, e);
            }
        }
        return result;
    }

    public Object onClose(WebSocketRequest wsRequest, byte[] bytes, ChannelContext channelContext) throws Exception {
        Object packet;
        block3: {
            WebSocketSessionContext wsSessionContext = (WebSocketSessionContext)channelContext.get();
            HttpRequest httpRequest = wsSessionContext.getHandshakeRequest();
            String path = httpRequest.getRequestLine().path;
            if (this.webSocketRouter == null) {
                log.error("webSocket router is null,please check");
                return null;
            }
            IWebSocketHandler handler = this.webSocketRouter.find(path);
            packet = null;
            try {
                packet = handler.onClose(wsRequest, bytes, channelContext);
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                sb.append("\r\n").append("Remote Address: ").append(httpRequest.getClientIp());
                sb.append("\r\n").append("Request: ").append(httpRequest.getRequestLine().toString());
                log.error(sb.toString(), (Throwable)e);
                TioBootExceptionHandler exceptionHandler = TioBootServer.me().getExceptionHandler();
                if (exceptionHandler == null) break block3;
                exceptionHandler.wsBytesHandler(wsRequest, bytes, channelContext, httpRequest, e);
            }
        }
        return packet;
    }

    public Object onText(WebSocketRequest wsRequest, String text, ChannelContext channelContext) throws Exception {
        Object packet;
        block3: {
            WebSocketSessionContext wsSessionContext = (WebSocketSessionContext)channelContext.get();
            HttpRequest httpRequest = wsSessionContext.getHandshakeRequest();
            String path = httpRequest.getRequestLine().path;
            if (this.webSocketRouter == null) {
                log.error("webSocket router is null,please check");
                return null;
            }
            IWebSocketHandler handler = this.webSocketRouter.find(path);
            packet = null;
            try {
                packet = handler.onText(wsRequest, text, channelContext);
            }
            catch (Exception e) {
                StringBuilder sb = new StringBuilder();
                sb.append("\r\n").append("Remote Address: ").append(httpRequest.getClientIp());
                sb.append("\r\n").append("Request: ").append(httpRequest.getRequestLine().toString());
                log.error(sb.toString(), (Throwable)e);
                TioBootExceptionHandler exceptionHandler = TioBootServer.me().getExceptionHandler();
                if (exceptionHandler == null) break block3;
                exceptionHandler.wsTextHandler(wsRequest, text, channelContext, httpRequest, e);
            }
        }
        return packet;
    }

    public void httpErrorHandler(HttpRequest request, Throwable throwable) {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n").append("Remote Address: ").append(request.getClientIp());
        sb.append("\r\n").append("Request: ").append(request.getRequestLine().toString());
        log.error(sb.toString(), throwable);
        TioBootExceptionHandler exceptionHandler = TioBootServer.me().getExceptionHandler();
        if (exceptionHandler != null) {
            exceptionHandler.handler(request, throwable);
        }
    }
}

