/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.watch;

import com.litongjava.tio.boot.cache.StaticResourcesCache;
import com.litongjava.tio.utils.cache.AbsCache;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryWatcher {
    private static final Logger log = LoggerFactory.getLogger(DirectoryWatcher.class);
    private final WatchService watchService;
    private final Path rootDir;
    private final Map<WatchKey, Path> keyPathMap = new HashMap<WatchKey, Path>();
    private volatile boolean running = false;
    private Thread watcherThread;

    public DirectoryWatcher(Path rootDir) throws IOException {
        this.rootDir = rootDir;
        this.watchService = FileSystems.getDefault().newWatchService();
    }

    public void start() throws IOException {
        if (this.running) {
            return;
        }
        this.registerAll(this.rootDir);
        this.running = true;
        this.watcherThread = new Thread(this::processEvents, "DirectoryWatcher-Thread");
        this.watcherThread.setDaemon(true);
        this.watcherThread.start();
        log.info("DirectoryWatcher started on {}", (Object)this.rootDir);
    }

    public void stop() {
        this.running = false;
        if (this.watcherThread != null) {
            this.watcherThread.interrupt();
        }
        try {
            this.watchService.close();
        }
        catch (IOException e) {
            log.error("Error closing WatchService", (Throwable)e);
        }
        log.info("DirectoryWatcher stopped on {}", (Object)this.rootDir);
    }

    private void registerAll(Path startDir) throws IOException {
        Files.walkFileTree(startDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                DirectoryWatcher.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE);
        this.keyPathMap.put(key, dir);
        log.debug("Registered directory to WatchService: {}", (Object)dir);
    }

    private void processEvents() {
        while (this.running) {
            WatchKey key;
            try {
                key = this.watchService.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (ClosedWatchServiceException e) {
                break;
            }
            Path dir = this.keyPathMap.get(key);
            if (dir == null) {
                key.reset();
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) {
                    log.warn("Overflow event occurred in directory watcher: {}", (Object)dir);
                    continue;
                }
                WatchEvent<?> ev = event;
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                    try {
                        if (Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) {
                            this.registerAll(child);
                        }
                    }
                    catch (IOException e) {
                        log.error("Error registering newly created subdirectory: {}", (Object)child, (Object)e);
                    }
                }
                File changedFile = child.toFile();
                if (kind != StandardWatchEventKinds.ENTRY_CREATE && kind != StandardWatchEventKinds.ENTRY_MODIFY && kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                log.info("File system event [{}] on: {}", (Object)kind.name(), (Object)changedFile);
                try {
                    AbsCache staticResCache = StaticResourcesCache.getStaticResCache();
                    if (staticResCache == null) continue;
                    String path = StaticResourcesCache.getHttpConfig().getPath(changedFile);
                    staticResCache.remove(path);
                }
                catch (IOException e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keyPathMap.remove(key);
            if (!this.keyPathMap.isEmpty()) continue;
            break;
        }
    }
}

