/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.utils;

import com.jfinal.kit.StrKit;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.utils.date.DateParseUtils;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.Json;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class TioRequestParamUtils {
    public static final String to_type = "to_type";
    public static final String toType = "toType";
    public static final String _to_type = "_to_type";
    public static final String _toType = "_toType";
    public static final String input_type = "input_type";
    public static final String inputType = "inutType";
    public static final String _input_type = "_input_type";
    public static final String _inputType = "_inputType";
    public static List<String> types = new ArrayList<String>();

    public static Map<String, Object> getRequestMap(HttpRequest request) {
        Map<String, Object> requestMap = TioRequestParamUtils.getOriginalMap(request);
        return TioRequestParamUtils.proceseRequestMap(requestMap);
    }

    public static Map<String, Object> proceseRequestMap(Map<String, Object> requestMap) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, String> toTypeMap = new HashMap<String, String>();
        HashMap<String, List<Object>> arrayParams = new HashMap<String, List<Object>>();
        HashMap<String, String> paramType = new HashMap<String, String>();
        HashMap<String, String> inputTypeMap = new HashMap<String, String>();
        Set<Map.Entry<String, Object>> entrySet = requestMap.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String paramKey;
            String paramName = entry.getKey();
            Object paramValue = entry.getValue();
            if (paramName.contains("[")) {
                String arrayName = paramName.substring(0, paramName.indexOf(91));
                if (!arrayParams.containsKey(arrayName)) {
                    arrayParams.put(arrayName, new ArrayList());
                }
                ((List)arrayParams.get(arrayName)).add(paramValue);
                continue;
            }
            if (paramName.endsWith(_inputType) && types.contains(paramValue)) {
                int lastIndexOf = paramName.lastIndexOf(_inputType);
                if (lastIndexOf == -1) continue;
                paramKey = paramName.substring(0, lastIndexOf);
                inputTypeMap.put(paramKey, (String)paramValue);
                continue;
            }
            if (paramName.endsWith(_input_type) && types.contains(paramValue)) {
                int lastIndexOf = paramName.lastIndexOf(_input_type);
                if (lastIndexOf == -1) continue;
                paramKey = paramName.substring(0, lastIndexOf);
                inputTypeMap.put(paramKey, (String)paramValue);
                continue;
            }
            if (paramName.endsWith(input_type) && types.contains(paramValue)) {
                int lastIndexOf = paramName.lastIndexOf(input_type);
                if (lastIndexOf == -1) continue;
                paramKey = paramName.substring(0, lastIndexOf);
                inputTypeMap.put(paramKey, (String)paramValue);
                continue;
            }
            if (paramName.endsWith(inputType) && types.contains(paramValue)) {
                int lastIndexOf = paramName.lastIndexOf(inputType);
                if (lastIndexOf == -1) continue;
                paramKey = paramName.substring(0, lastIndexOf);
                inputTypeMap.put(paramKey, (String)paramValue);
                continue;
            }
            if (paramName.endsWith(_to_type) && types.contains(paramValue)) {
                int lastIndexOf = paramName.lastIndexOf(_to_type);
                if (lastIndexOf == -1) continue;
                paramKey = paramName.substring(0, lastIndexOf);
                toTypeMap.put(paramKey, (String)paramValue);
                continue;
            }
            if (paramName.endsWith(_toType) && types.contains(paramValue)) {
                int lastIndexOf = paramName.lastIndexOf(_toType);
                if (lastIndexOf == -1) continue;
                paramKey = paramName.substring(0, lastIndexOf);
                toTypeMap.put(paramKey, (String)paramValue);
                continue;
            }
            if (paramName.endsWith(toType) && types.contains(paramValue)) {
                int lastIndexOf = paramName.lastIndexOf(toType);
                if (lastIndexOf == -1) continue;
                paramKey = paramName.substring(0, lastIndexOf);
                toTypeMap.put(paramKey, (String)paramValue);
                continue;
            }
            if (paramName.endsWith(to_type) && types.contains(paramValue)) {
                int lastIndexOf = paramName.lastIndexOf(to_type);
                if (lastIndexOf == -1) continue;
                paramKey = paramName.substring(0, lastIndexOf);
                toTypeMap.put(paramKey, (String)paramValue);
                continue;
            }
            if (paramName.length() > 4 && (paramName.endsWith("Type") || paramName.endsWith("type"))) {
                if (types.contains(paramValue)) {
                    paramType.put(paramName, (String)paramValue);
                    continue;
                }
                map.put(paramName, (String)paramValue);
                continue;
            }
            map.put(paramName, paramValue);
        }
        TioRequestParamUtils.convertValueType(map, arrayParams, paramType, inputTypeMap, toTypeMap);
        return map;
    }

    public static Map<String, Object> getOriginalMap(HttpRequest request) {
        String contentType = request.getContentType();
        if (contentType != null && contentType.contains("application/json")) {
            Map<String, Object> requestMap = TioRequestParamUtils.getRequestMap0(request);
            String bodyString = request.getBodyString();
            if (StrUtil.isNotEmpty((String)bodyString)) {
                requestMap.putAll(Json.getJson().parseToMap(bodyString, String.class, Object.class));
            }
            return requestMap;
        }
        return TioRequestParamUtils.getRequestMap0(request);
    }

    private static Map<String, Object> getRequestMap0(HttpRequest request) {
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        Enumeration parameterNames = request.getParameterNames();
        while (parameterNames.hasMoreElements()) {
            String paramName = (String)parameterNames.nextElement();
            Object object = request.getObject(paramName);
            requestMap.put(paramName, object);
        }
        return requestMap;
    }

    public static void convertValueType(Map<String, Object> map, Map<String, List<Object>> arrayParams, Map<String, String> paramType, Map<String, String> inputTypeMap, Map<String, String> toTypeMap) {
        for (Map.Entry<String, List<Object>> entry : arrayParams.entrySet()) {
            map.put(entry.getKey(), entry.getValue().toArray(new String[0]));
        }
        for (Map.Entry<String, Object> entry : paramType.entrySet()) {
            Number[] values;
            Object paramValue;
            String typeKey = entry.getKey();
            int lastIndexOf = typeKey.lastIndexOf("Type");
            String paramKey = null;
            if (lastIndexOf != -1) {
                paramKey = typeKey.substring(0, lastIndexOf);
            } else {
                lastIndexOf = typeKey.lastIndexOf("_");
                paramKey = typeKey.substring(0, lastIndexOf);
            }
            if (!StrKit.notNull((Object[])new Object[]{paramValue = map.get(paramKey)})) continue;
            Object paramTypeValue = entry.getValue();
            if (paramValue instanceof String) {
                String stringValue = (String)paramValue;
                if (!StrKit.notBlank((String)stringValue)) continue;
                if ("int".equals(paramTypeValue) || "integer".equals(paramTypeValue)) {
                    map.put(paramKey, Integer.parseInt(stringValue));
                    continue;
                }
                if ("long".equals(paramTypeValue)) {
                    map.put(paramKey, Long.parseLong(stringValue));
                    continue;
                }
                if ("bool".equals(paramTypeValue)) {
                    map.put(paramKey, Boolean.parseBoolean(stringValue));
                    continue;
                }
                if ("uuid".equals(paramTypeValue)) {
                    map.put(paramKey, UUID.fromString(stringValue));
                    continue;
                }
                if (!"ISO8601".equals(paramTypeValue)) continue;
                map.put(paramKey, DateParseUtils.parseIso8601Date((String)stringValue));
                continue;
            }
            if (!(paramValue instanceof List)) continue;
            List list = (List)paramValue;
            int size = list.size();
            if ("string[]".equals(paramTypeValue)) {
                String toType;
                String inputType = inputTypeMap.remove(paramKey);
                if (StrKit.notNull((Object[])new Object[]{inputType}) && "ISO8601".equals(inputType)) {
                    list = DateParseUtils.convertToIso8601Date((List)list);
                }
                if (StrKit.notNull((Object[])new Object[]{toType = toTypeMap.remove(paramKey)}) && "ISO8601".equals(toType)) {
                    list = DateParseUtils.convertToIso8601FromDefault((List)list);
                }
                map.put(paramKey, list);
                continue;
            }
            if ("int[]".equals(paramTypeValue)) {
                values = new Integer[size];
                for (int i = 0; i < size; ++i) {
                    values[i] = Integer.parseInt((String)list.get(i));
                }
                map.put(paramKey, values);
                continue;
            }
            if (!"long[]".equals(paramTypeValue)) continue;
            values = new Long[size];
            for (int i = 0; i < size; ++i) {
                values[i] = Long.parseLong((String)list.get(i));
            }
            map.put(paramKey, values);
        }
        for (Map.Entry<String, Object> entry : toTypeMap.entrySet()) {
            OffsetDateTime outputValue;
            String inputType;
            Object inputValue;
            String paramKey = entry.getKey();
            String toTypeValue = (String)entry.getValue();
            Object object = map.get(paramKey);
            if (object instanceof String) {
                inputValue = (String)object;
                if (!StrKit.notNull((Object[])new Object[]{toTypeValue})) continue;
                inputType = inputTypeMap.get(paramKey);
                outputValue = TioRequestParamUtils.convert((String)inputValue, inputType, toTypeValue);
                map.put(paramKey, outputValue);
                continue;
            }
            if (!(object instanceof Long)) continue;
            inputValue = (Long)object;
            if (!StrKit.notNull((Object[])new Object[]{toTypeValue})) continue;
            inputType = inputTypeMap.get(paramKey);
            outputValue = TioRequestParamUtils.convert((Long)inputValue, inputType, toTypeValue);
            map.put(paramKey, outputValue);
        }
    }

    public static OffsetDateTime convert(Long inputValue, String inputTypeValue, String toTypeValue) {
        if ("ISO8601".equals(toTypeValue)) {
            if ("second".equals(inputTypeValue)) {
                return DateParseUtils.convertToIso8601FromSecond((Long)inputValue);
            }
            if ("millisecond".equals(inputTypeValue)) {
                return DateParseUtils.convertToIso8601Frommillisecond((Long)inputValue);
            }
            return DateParseUtils.convertToIso8601Frommillisecond((Long)inputValue);
        }
        return null;
    }

    public static OffsetDateTime convert(String inputValue, String inputTypeValue, String toTypeValue) {
        if ("ISO8601".equals(toTypeValue)) {
            if (inputTypeValue == null) {
                return DateParseUtils.convertToIso8601FromDefault((String)inputValue);
            }
            if ("second".contentEquals(inputTypeValue)) {
                return DateParseUtils.convertToIso8601FromSecond((String)inputValue);
            }
            if ("millisecond".contentEquals(inputTypeValue)) {
                return DateParseUtils.convertToIso8601Frommillisecond((String)inputValue);
            }
        }
        return null;
    }

    static {
        types.add("int");
        types.add("integer");
        types.add("long");
        types.add("bool");
        types.add("uuid");
        types.add("int[]");
        types.add("long[]");
        types.add("string[]");
        types.add("ISO8601");
        types.add("second");
        types.add("millisecond");
    }
}

