/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.utils;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.litongjava.tio.http.server.util.ClassUtils;
import com.litongjava.tio.utils.hutool.BeanUtil;
import com.litongjava.tio.utils.hutool.ClassUtil;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.lock.LockUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioAsmUtils {
    private static final Logger log = LoggerFactory.getLogger(TioAsmUtils.class);
    private static Map<Class<?>, MethodAccess> classMethodAccessMap = new HashMap();

    public static MethodAccess getMethodAccess(Map<Class<?>, MethodAccess> classMethodaccessMap, Class<?> clazz) throws Exception {
        MethodAccess ret = classMethodaccessMap.get(clazz);
        if (ret == null) {
            LockUtils.runWriteOrWaitRead((String)("_tio_http_h_ma_" + clazz.getName()), clazz, () -> {
                if (classMethodaccessMap.get(clazz) == null) {
                    classMethodaccessMap.put(clazz, MethodAccess.get((Class)clazz));
                }
            });
            ret = classMethodaccessMap.get(clazz);
        }
        return ret;
    }

    public static void injectParametersIntoObject(Map<String, Object[]> params, int i, String paramName, Class<?> paramType, Object[] paramValues) {
        if (ClassUtils.isSimpleTypeOrArray(paramType)) {
            Object[] value = params.get(paramName);
            if (value != null && value.length > 0) {
                if (paramType.isArray()) {
                    if (value.getClass() == String[].class) {
                        try {
                            paramValues[i] = StrUtil.convert(paramType, (String[])((String[])value));
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        paramValues[i] = value;
                    }
                } else if (value[0] == null) {
                    paramValues[i] = null;
                } else if (value[0].getClass() == String.class) {
                    try {
                        paramValues[i] = StrUtil.convert(paramType, (String)((String)value[0]));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    paramValues[i] = value[0];
                }
            }
        } else {
            try {
                paramValues[i] = paramType.newInstance();
            }
            catch (InstantiationException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            Set<Map.Entry<String, Object[]>> set = params.entrySet();
            for (Map.Entry<String, Object[]> entry : set) {
                try {
                    Class<?>[] clazzes;
                    String fieldName = entry.getKey();
                    Object[] fieldValue = entry.getValue();
                    PropertyDescriptor propertyDescriptor = BeanUtil.getPropertyDescriptor(paramType, (String)fieldName, (boolean)false);
                    if (propertyDescriptor == null) continue;
                    Method writeMethod = propertyDescriptor.getWriteMethod();
                    if (writeMethod == null) {
                        for (Method method : paramType.getMethods()) {
                            if (!method.getName().equals(propertyDescriptor.getName()) && !method.getName().equals("set" + StrUtil.upperFirst((CharSequence)propertyDescriptor.getName())) || method.getParameterCount() != 1) continue;
                            writeMethod = method;
                            break;
                        }
                        if (writeMethod == null) continue;
                    }
                    if ((clazzes = (writeMethod = ClassUtil.setAccessible((Method)writeMethod)).getParameterTypes()) == null || clazzes.length != 1) {
                        log.info("The length of the method parameters is not 1:{}.{}", (Object)paramType.getName(), (Object)writeMethod.getName());
                        continue;
                    }
                    Class<?> clazz = clazzes[0];
                    if (!ClassUtils.isSimpleTypeOrArray(clazz) || fieldValue == null || fieldValue.length <= 0) continue;
                    if (clazz.isArray()) {
                        Object theValue = null;
                        theValue = fieldValue.getClass() == String[].class ? StrUtil.convert(clazz, (String[])((String[])fieldValue)) : fieldValue;
                        TioAsmUtils.getMethodAccess(classMethodAccessMap, paramType).invoke(paramValues[i], writeMethod.getName(), new Object[]{theValue});
                        continue;
                    }
                    Object theValue = null;
                    theValue = fieldValue[0] == null ? fieldValue[0] : (fieldValue[0].getClass() == String.class ? StrUtil.convert(clazz, (String)((String)fieldValue[0])) : fieldValue[0]);
                    TioAsmUtils.getMethodAccess(classMethodAccessMap, paramType).invoke(paramValues[i], writeMethod.getName(), new Object[]{theValue});
                }
                catch (Throwable e) {
                    log.error(e.toString(), e);
                }
            }
        }
    }
}

