/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.swagger;

import com.litongjava.tio.boot.http.handler.controller.TioBootHttpControllerRouter;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.JsonUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import springfox.documentation.service.ApiInfo;

public class TioSwaggerGenerateUtils {
    private static final Logger log = LoggerFactory.getLogger(TioSwaggerGenerateUtils.class);
    private static Set<Class<?>> definitionsToGenerate = new HashSet();

    /*
     * WARNING - void declaration
     */
    public static String generateSwaggerJson(TioBootHttpControllerRouter router, ApiInfo apiInfo) {
        LinkedHashMap<String, Object> swagger = new LinkedHashMap<String, Object>();
        swagger.put("swagger", "2.0");
        swagger.put("info", apiInfo);
        int port = EnvUtils.getInt((String)"server.port", (int)80);
        String contextPath = EnvUtils.get((String)"server.context-path");
        if (contextPath == null) {
            contextPath = "/";
        }
        swagger.put("host", "127.0.0.1:" + port);
        swagger.put("basePath", contextPath);
        swagger.put("schemes", Arrays.asList("http"));
        LinkedHashMap paths = new LinkedHashMap();
        HashSet responseClasses = new HashSet();
        for (Map.Entry<String, Method> entry : router.PATH_METHOD_MAP.entrySet()) {
            ApiResponses apiResponses;
            void var10_10;
            String path;
            String key = entry.getKey();
            if (key.contains(" ")) {
                String[] parts = key.split(" ", 2);
                String string = parts[0].toLowerCase();
                path = parts[1];
            } else {
                String string = "post";
                path = key;
            }
            String swaggerPath = path.replaceAll("\\{", "{").replaceAll("}", "}");
            LinkedHashMap pathItem = (LinkedHashMap)paths.get(swaggerPath);
            if (pathItem == null) {
                pathItem = new LinkedHashMap();
                paths.put(swaggerPath, pathItem);
            }
            LinkedHashMap<String, Object> operation = new LinkedHashMap<String, Object>();
            Method method = entry.getValue();
            Class<?> controllerClass = method.getDeclaringClass();
            Api apiAnnotation = controllerClass.getAnnotation(Api.class);
            if (apiAnnotation != null && apiAnnotation.tags().length > 0) {
                operation.put("tags", Arrays.asList(apiAnnotation.tags()));
            } else {
                operation.put("tags", Collections.singletonList(controllerClass.getSimpleName()));
            }
            ApiOperation apiOperation = method.getAnnotation(ApiOperation.class);
            if (apiOperation != null) {
                operation.put("summary", apiOperation.value());
                operation.put("description", apiOperation.notes());
            } else {
                operation.put("summary", path);
                operation.put("description", "Request method " + var10_10.toUpperCase() + ", request type application/x-www-form-urlencoded or application/json");
            }
            operation.put("operationId", method.getName() + "Using" + var10_10.toUpperCase());
            ApiImplicitParams apiImplicitParams = method.getAnnotation(ApiImplicitParams.class);
            ArrayList parameters = new ArrayList();
            boolean hasNonHeaderParam = false;
            if (apiImplicitParams != null) {
                for (ApiImplicitParam param : apiImplicitParams.value()) {
                    if (!"header".equalsIgnoreCase(param.paramType())) {
                        hasNonHeaderParam = true;
                    }
                    LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
                    paramMap.put("name", param.name());
                    paramMap.put("in", param.paramType());
                    paramMap.put("description", param.value());
                    paramMap.put("required", param.required());
                    LinkedHashMap<String, String> schema = new LinkedHashMap<String, String>();
                    if (StrUtil.isNotBlank((CharSequence)param.dataType())) {
                        schema.put("type", TioSwaggerGenerateUtils.mapSwaggerType(param.dataType()));
                    } else {
                        schema.put("type", "string");
                    }
                    paramMap.put("schema", schema);
                    parameters.add(paramMap);
                }
            }
            String[] paramNames = router.METHOD_PARAM_NAME_MAP.get(method);
            Class<?>[] paramTypes = router.METHOD_PARAM_TYPE_MAP.get(method);
            boolean hasBodyParam = false;
            if (paramNames != null && paramTypes != null) {
                for (int i = 0; i < paramNames.length; ++i) {
                    LinkedHashMap<String, String> schema;
                    Class<?> paramType = paramTypes[i];
                    String paramName = paramNames[i];
                    if (TioSwaggerGenerateUtils.isPrimitiveOrWrapper(paramType) || paramType == String.class) {
                        if (!hasNonHeaderParam) {
                            LinkedHashMap<String, Object> paramMap = new LinkedHashMap<String, Object>();
                            paramMap.put("name", paramName);
                            paramMap.put("in", "query");
                            paramMap.put("description", "request parameter");
                            paramMap.put("required", true);
                            schema = new LinkedHashMap<String, String>();
                            schema.put("type", TioSwaggerGenerateUtils.mapSwaggerType(paramType.getSimpleName()));
                            paramMap.put("schema", schema);
                            parameters.add(paramMap);
                        }
                        operation.put("consumes", Collections.singletonList("*/*"));
                        continue;
                    }
                    LinkedHashMap<String, Object> bodyParam = new LinkedHashMap<String, Object>();
                    bodyParam.put("name", paramName);
                    bodyParam.put("in", "body");
                    bodyParam.put("description", "request body");
                    bodyParam.put("required", true);
                    schema = new LinkedHashMap();
                    schema.put("$ref", "#/definitions/" + paramType.getSimpleName());
                    bodyParam.put("schema", schema);
                    parameters.add(bodyParam);
                    operation.put("consumes", Collections.singletonList("application/json"));
                    hasBodyParam = true;
                    definitionsToGenerate.add(paramType);
                }
            } else {
                operation.put("consumes", Collections.singletonList("*/*"));
            }
            if (!parameters.isEmpty()) {
                operation.put("parameters", parameters);
            }
            if ((apiResponses = method.getAnnotation(ApiResponses.class)) != null) {
                operation.put("produces", Collections.singletonList("application/json"));
                operation.put("responses", TioSwaggerGenerateUtils.createApiResponses(apiResponses, method));
            } else {
                Class<?> returnType = method.getReturnType();
                if (returnType.getName().equals("com.litongjava.model.body.RespBodyVo")) {
                    operation.put("produces", Collections.singletonList("application/json"));
                    operation.put("responses", TioSwaggerGenerateUtils.createCustomResponseForRespBodyVo());
                    responseClasses.add(returnType);
                } else if (returnType.getName().equals("com.litongjava.tio.http.common.HttpResponse")) {
                    operation.put("produces", Collections.singletonList("*/*"));
                    operation.put("responses", TioSwaggerGenerateUtils.createStandardHttpResponse());
                } else {
                    operation.put("produces", Collections.singletonList("application/json"));
                    operation.put("responses", TioSwaggerGenerateUtils.createStandardHttpResponse());
                }
            }
            pathItem.put(var10_10, operation);
        }
        swagger.put("paths", paths);
        LinkedHashMap<String, Map<String, Object>> definitions = new LinkedHashMap<String, Map<String, Object>>();
        HashSet classesToProcess = new HashSet(definitionsToGenerate);
        definitionsToGenerate.clear();
        while (!classesToProcess.isEmpty()) {
            Iterator iterator = classesToProcess.iterator();
            Class clazz = (Class)iterator.next();
            iterator.remove();
            if (TioSwaggerGenerateUtils.isGenericCollection(clazz)) {
                log.info("Skipping generic collection class: {}", (Object)clazz.getSimpleName());
                continue;
            }
            try {
                definitions.put(clazz.getSimpleName(), TioSwaggerGenerateUtils.generateDefinition(clazz));
            }
            catch (ClassNotFoundException e) {
                log.error("Failed to generate definition for class: {}", (Object)clazz, (Object)e);
            }
            for (Class<?> newClass : definitionsToGenerate) {
                if (definitions.containsKey(newClass.getSimpleName()) || classesToProcess.contains(newClass) || TioSwaggerGenerateUtils.isGenericCollection(newClass)) continue;
                classesToProcess.add(newClass);
            }
            definitionsToGenerate.clear();
        }
        for (Class clazz : responseClasses) {
            if (TioSwaggerGenerateUtils.isGenericCollection(clazz)) {
                log.info("Skipping generic collection class: {}", (Object)clazz.getSimpleName());
                continue;
            }
            try {
                definitions.put(clazz.getSimpleName(), TioSwaggerGenerateUtils.generateDefinition(clazz));
            }
            catch (ClassNotFoundException e) {
                log.error("Failed to generate definition for class: {}", (Object)clazz, (Object)e);
            }
        }
        swagger.put("definitions", definitions);
        String json = JsonUtils.toJson(swagger);
        return json;
    }

    private static Map<String, Object> createCustomResponseForRespBodyVo() {
        LinkedHashMap<String, Object> responses = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> response200 = new LinkedHashMap<String, Object>();
        response200.put("description", "Success");
        LinkedHashMap<String, Object> schema = new LinkedHashMap<String, Object>();
        schema.put("type", "object");
        LinkedHashMap<String, Map<String, String>> properties = new LinkedHashMap<String, Map<String, String>>();
        properties.put("code", Collections.singletonMap("type", "integer"));
        properties.put("data", Collections.singletonMap("type", "object"));
        properties.put("msg", Collections.singletonMap("type", "string"));
        properties.put("ok", Collections.singletonMap("type", "boolean"));
        schema.put("properties", properties);
        response200.put("schema", schema);
        responses.put("200", response200);
        responses.put("400", TioSwaggerGenerateUtils.createDefaultResponse("Bad Request"));
        responses.put("401", TioSwaggerGenerateUtils.createDefaultResponse("Unauthorized"));
        responses.put("403", TioSwaggerGenerateUtils.createDefaultResponse("Forbidden"));
        responses.put("404", TioSwaggerGenerateUtils.createDefaultResponse("Not Found"));
        responses.put("500", TioSwaggerGenerateUtils.createDefaultResponse("Internal Server Error"));
        return responses;
    }

    private static Map<String, Object> createStandardHttpResponse() {
        LinkedHashMap<String, Object> responses = new LinkedHashMap<String, Object>();
        responses.put("200", TioSwaggerGenerateUtils.createDefaultResponse("Standard HTTP Response"));
        responses.put("400", TioSwaggerGenerateUtils.createDefaultResponse("Bad Request"));
        responses.put("401", TioSwaggerGenerateUtils.createDefaultResponse("Unauthorized"));
        responses.put("403", TioSwaggerGenerateUtils.createDefaultResponse("Forbidden"));
        responses.put("404", TioSwaggerGenerateUtils.createDefaultResponse("Not Found"));
        responses.put("500", TioSwaggerGenerateUtils.createDefaultResponse("Internal Server Error"));
        return responses;
    }

    private static Map<String, Object> createApiResponses(ApiResponses apiResponses, Method method) {
        LinkedHashMap<String, Object> responses = new LinkedHashMap<String, Object>();
        for (ApiResponse apiResponse : apiResponses.value()) {
            LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
            response.put("description", apiResponse.message());
            Class responseClass = apiResponse.response();
            if (responseClass != null && responseClass != Void.class) {
                response.put("schema", Collections.singletonMap("$ref", "#/definitions/" + responseClass.getSimpleName()));
                definitionsToGenerate.add(responseClass);
            }
            responses.put(String.valueOf(apiResponse.code()), response);
        }
        return responses;
    }

    private static Map<String, Object> generateDefinition(Class<?> clazz) throws ClassNotFoundException {
        LinkedHashMap<String, Object> definition = new LinkedHashMap<String, Object>();
        definition.put("type", "object");
        definition.put("title", clazz.getSimpleName());
        ApiModel apiModel = clazz.getAnnotation(ApiModel.class);
        if (apiModel != null) {
            if (StrUtil.isNotBlank((CharSequence)apiModel.value())) {
                definition.put("title", apiModel.value());
            }
            if (StrUtil.isNotBlank((CharSequence)apiModel.description())) {
                definition.put("description", apiModel.description());
            }
        }
        LinkedHashMap<String, Map<String, String>> properties = new LinkedHashMap<String, Map<String, String>>();
        ArrayList<String> requiredFields = new ArrayList<String>();
        if (clazz.getName().equals("com.litongjava.model.body.RespBodyVo")) {
            properties.put("code", Collections.singletonMap("type", "integer"));
            properties.put("data", Collections.singletonMap("type", "object"));
            properties.put("msg", Collections.singletonMap("type", "string"));
            properties.put("ok", Collections.singletonMap("type", "boolean"));
        } else if (!clazz.getName().equals("com.litongjava.tio.http.common.HttpRequest")) {
            Field[] declaredFields = null;
            try {
                declaredFields = clazz.getDeclaredFields();
            }
            catch (Exception e) {
                log.error("Failed to build class: {}, error: {}", clazz, (Object)e);
            }
            if (declaredFields != null) {
                for (Field field : declaredFields) {
                    if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
                    if (field.getType().equals(clazz)) {
                        log.warn("Skipping self-referencing field: {} in class: {}", (Object)field.getName(), (Object)clazz.getSimpleName());
                        continue;
                    }
                    LinkedHashMap<String, Object> fieldInfo = new LinkedHashMap<String, Object>();
                    Class<?> fieldClass = field.getType();
                    String fieldType = fieldClass.getSimpleName();
                    ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
                    if (apiModelProperty != null) {
                        if (StrUtil.isNotBlank((CharSequence)apiModelProperty.value())) {
                            fieldInfo.put("description", apiModelProperty.value());
                        }
                        if (apiModelProperty.required()) {
                            requiredFields.add(field.getName());
                        }
                        if (StrUtil.isNotBlank((CharSequence)apiModelProperty.dataType())) {
                            fieldType = apiModelProperty.dataType();
                        }
                        if (StrUtil.isNotBlank((CharSequence)apiModelProperty.allowableValues())) {
                            String allowableValues = apiModelProperty.allowableValues();
                            String[] values = allowableValues.split(",");
                            fieldInfo.put("enum", Arrays.asList(values));
                        }
                        if (StrUtil.isNotBlank((CharSequence)apiModelProperty.example())) {
                            fieldInfo.put("example", apiModelProperty.example());
                        }
                    }
                    if (fieldClass.isEnum()) {
                        fieldInfo.put("type", "string");
                        ?[] enumConstants = fieldClass.getEnumConstants();
                        ArrayList<String> enumValues = new ArrayList<String>();
                        for (Object enumConstant : enumConstants) {
                            enumValues.add(enumConstant.toString());
                        }
                        fieldInfo.put("enum", enumValues);
                    } else if (Collection.class.isAssignableFrom(fieldClass)) {
                        fieldInfo.put("type", "array");
                        Type genericType = field.getGenericType();
                        if (genericType instanceof ParameterizedType) {
                            Type[] actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments();
                            if (actualTypeArguments.length > 0) {
                                String itemTypeName = actualTypeArguments[0].getTypeName();
                                try {
                                    Class<?> itemClass = Class.forName(itemTypeName);
                                    if (TioSwaggerGenerateUtils.isPrimitiveOrWrapper(itemClass) || itemClass == String.class) {
                                        LinkedHashMap<String, String> items = new LinkedHashMap<String, String>();
                                        items.put("type", TioSwaggerGenerateUtils.mapSwaggerType(itemClass.getSimpleName()));
                                        fieldInfo.put("items", items);
                                    } else {
                                        fieldInfo.put("items", Collections.singletonMap("$ref", "#/definitions/" + itemClass.getSimpleName()));
                                        if (!TioSwaggerGenerateUtils.isGenericCollection(itemClass)) {
                                            definitionsToGenerate.add(itemClass);
                                        }
                                    }
                                }
                                catch (ClassNotFoundException e) {
                                    fieldInfo.put("items", Collections.singletonMap("type", "object"));
                                }
                            } else {
                                fieldInfo.put("items", Collections.singletonMap("type", "object"));
                            }
                        } else {
                            fieldInfo.put("items", Collections.singletonMap("type", "object"));
                        }
                    } else if (Map.class.isAssignableFrom(fieldClass)) {
                        fieldInfo.put("type", "object");
                        fieldInfo.put("additionalProperties", true);
                    } else if (!(TioSwaggerGenerateUtils.isPrimitiveOrWrapper(fieldClass) || fieldType.equalsIgnoreCase("String") || fieldClass.isEnum())) {
                        fieldInfo.put("$ref", "#/definitions/" + fieldClass.getSimpleName());
                        if (!TioSwaggerGenerateUtils.isGenericCollection(fieldClass)) {
                            definitionsToGenerate.add(fieldClass);
                        }
                    } else {
                        fieldInfo.put("type", TioSwaggerGenerateUtils.mapSwaggerType(fieldType));
                    }
                    properties.put(field.getName(), fieldInfo);
                }
            }
        }
        definition.put("properties", properties);
        if (!requiredFields.isEmpty()) {
            definition.put("required", requiredFields);
        }
        return definition;
    }

    private static boolean isPrimitiveOrWrapper(Class<?> clazz) {
        return clazz.isPrimitive() || clazz == Integer.class || clazz == Long.class || clazz == Boolean.class || clazz == Double.class || clazz == Float.class || clazz == Character.class || clazz == Byte.class || clazz == Short.class || clazz == Void.class;
    }

    private static boolean isGenericCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz);
    }

    private static String mapSwaggerType(String dataType) {
        if (StrUtil.isBlank((String)dataType)) {
            return "string";
        }
        switch (dataType.toLowerCase()) {
            case "int": 
            case "integer": {
                return "integer";
            }
            case "long": {
                return "long";
            }
            case "boolean": {
                return "boolean";
            }
            case "float": {
                return "float";
            }
            case "double": {
                return "double";
            }
            case "string": {
                return "string";
            }
            case "list": {
                return "array";
            }
            case "map": {
                return "object";
            }
        }
        return "object";
    }

    private static Map<String, Object> createDefaultResponse(String description) {
        LinkedHashMap<String, Object> response = new LinkedHashMap<String, Object>();
        response.put("description", description);
        return response;
    }
}

