/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.server;

import com.litongjava.aio.Packet;
import com.litongjava.tio.core.ChannelContext;
import com.litongjava.tio.server.intf.ServerAioListener;
import com.litongjava.tio.websocket.common.WebSocketSessionContext;

public class TioBootAioListener
implements ServerAioListener {
    private ServerAioListener tcpListener = null;

    public TioBootAioListener() {
    }

    public TioBootAioListener(ServerAioListener tcpListener) {
        this.tcpListener = tcpListener;
    }

    public void onAfterConnected(ChannelContext channelContext, boolean isConnected, boolean isReconnect) throws Exception {
        WebSocketSessionContext wsSessionContext = new WebSocketSessionContext();
        channelContext.set((Object)wsSessionContext);
        if (this.tcpListener != null) {
            this.tcpListener.onAfterConnected(channelContext, isConnected, isReconnect);
        }
    }

    public void onAfterDecoded(ChannelContext channelContext, Packet packet, int packetSize) throws Exception {
        if (this.tcpListener != null) {
            this.tcpListener.onAfterDecoded(channelContext, packet, packetSize);
        }
    }

    public void onAfterReceivedBytes(ChannelContext channelContext, int receivedBytes) throws Exception {
        if (this.tcpListener != null) {
            this.tcpListener.onAfterReceivedBytes(channelContext, receivedBytes);
        }
    }

    public void onAfterSent(ChannelContext channelContext, Packet packet, boolean isSentSuccess) throws Exception {
        if (this.tcpListener != null) {
            this.tcpListener.onAfterSent(channelContext, packet, isSentSuccess);
        }
    }

    public void onAfterHandled(ChannelContext channelContext, Packet packet, long cost) throws Exception {
        if (this.tcpListener != null) {
            this.tcpListener.onAfterHandled(channelContext, packet, cost);
        }
    }

    public void onBeforeClose(ChannelContext channelContext, Throwable throwable, String remark, boolean isRemove) throws Exception {
        if (this.tcpListener != null) {
            this.tcpListener.onBeforeClose(channelContext, throwable, remark, isRemove);
        }
    }

    public boolean onHeartbeatTimeout(ChannelContext channelContext, Long interval, int heartbeatTimeoutCount) {
        if (this.tcpListener != null) {
            return this.tcpListener.onHeartbeatTimeout(channelContext, interval, heartbeatTimeoutCount);
        }
        return false;
    }
}

