/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.satoken;

import cn.dev33.satoken.SaManager;
import cn.dev33.satoken.application.ApplicationInfo;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.exception.SaTokenException;
import cn.dev33.satoken.util.SaFoxUtil;
import com.litongjava.tio.http.common.Cookie;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SaRequestForTioHttp
implements SaRequest {
    protected HttpRequest request;

    public SaRequestForTioHttp(HttpRequest request) {
        this.request = request;
    }

    public Object getSource() {
        return this.request;
    }

    public String getParam(String name) {
        return this.request.getParameter(name);
    }

    public List<String> getParamNames() {
        Enumeration parameterNames = this.request.getParameterNames();
        ArrayList<String> list = new ArrayList<String>();
        while (parameterNames.hasMoreElements()) {
            list.add((String)parameterNames.nextElement());
        }
        return list;
    }

    public Map<String, String> getParamMap() {
        Map parameterMap = this.request.getParameterMap();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(parameterMap.size());
        for (String key : parameterMap.keySet()) {
            Object[] values = (Object[])parameterMap.get(key);
            map.put(key, String.valueOf(values[0]));
        }
        return map;
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public String getCookieValue(String name) {
        Cookie[] cookies = this.request.getCookiesArray();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (cookie == null || !name.equals(cookie.getName())) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public String getRequestPath() {
        return ApplicationInfo.cutPathPrefix((String)this.request.getRequestURI());
    }

    public String getUrl() {
        String currDomain = SaManager.getConfig().getCurrDomain();
        if (!SaFoxUtil.isEmpty((Object)currDomain)) {
            return currDomain + this.getRequestPath();
        }
        return this.request.getRequestURL().toString();
    }

    public String getMethod() {
        return this.request.getMethod().toString();
    }

    public Object forward(String path) {
        try {
            HttpResponse response = (HttpResponse)SaManager.getSaTokenContextOrSecond().getResponse().getSource();
            this.request.getRequestDispatcher(path).forward(this.request, response);
            return null;
        }
        catch (Exception e) {
            throw new SaTokenException((Throwable)e).setCode(20001);
        }
    }
}

