/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.i18n;

import com.jfinal.kit.StrKit;
import com.litongjava.jfinal.aop.AopInterceptor;
import com.litongjava.jfinal.aop.AopInvocation;
import com.litongjava.jfinal.core.Const;
import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.boot.i18n.I18n;
import com.litongjava.tio.boot.i18n.Res;
import com.litongjava.tio.http.common.Cookie;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;

public class I18nInterceptor
implements AopInterceptor {
    private String localeParaName = "_locale";
    private String resName = "_res";
    private boolean isSwitchView = false;

    public I18nInterceptor() {
    }

    public I18nInterceptor(String localeParaName, String resName) {
        if (StrKit.isBlank((String)localeParaName)) {
            throw new IllegalArgumentException("localeParaName can not be blank.");
        }
        if (StrKit.isBlank((String)resName)) {
            throw new IllegalArgumentException("resName can not be blank.");
        }
        this.localeParaName = localeParaName;
        this.resName = resName;
    }

    public I18nInterceptor(String localeParaName, String resName, boolean isSwitchView) {
        this(localeParaName, resName);
        this.isSwitchView = isSwitchView;
    }

    public I18nInterceptor(boolean isSwitchView) {
        this.isSwitchView = isSwitchView;
    }

    protected String getLocaleParaName() {
        return this.localeParaName;
    }

    protected String getResName() {
        return this.resName;
    }

    protected String getBaseName() {
        return I18n.defaultBaseName;
    }

    public void intercept(AopInvocation inv) {
        Cookie cookie;
        HttpRequest request = TioRequestContext.getRequest();
        HttpResponse response = TioRequestContext.getResponse();
        String localeParaName = this.getLocaleParaName();
        String locale = request.getParam(localeParaName);
        if (StrKit.notBlank((String)locale)) {
            cookie = new Cookie(null, localeParaName, locale, Long.valueOf(Const.DEFAULT_I18N_MAX_AGE_OF_COOKIE));
            response.addCookie(cookie);
        } else {
            cookie = request.getCookie(localeParaName);
            if (cookie != null && StrKit.isBlank((String)(locale = cookie.getValue()))) {
                locale = I18n.defaultLocale;
            }
        }
        inv.invoke();
        if (!this.isSwitchView) {
            Res res = I18n.use(this.getBaseName(), locale);
            request.setAttribute(locale, (Object)res);
        }
    }
}

