/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.utils;

import com.jfinal.template.Template;
import com.litongjava.model.http.response.ResponseVo;
import com.litongjava.tio.boot.encrypt.TioEncryptor;
import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.boot.server.TioBootServer;
import com.litongjava.tio.boot.utils.TioAsmUtils;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.session.HttpSession;
import com.litongjava.tio.http.common.utils.MimeTypeUtils;
import com.litongjava.tio.http.server.util.ClassUtils;
import com.litongjava.tio.http.server.util.Resps;
import com.litongjava.tio.server.ServerChannelContext;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.Json;
import com.litongjava.tio.utils.json.JsonUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioActionResponseProcessor {
    private static final Logger log = LoggerFactory.getLogger(TioActionResponseProcessor.class);

    public static HttpResponse afterExecuteAction(Object actionRetrunValue) {
        HttpRequest request = TioRequestContext.getRequest();
        HttpResponse response = TioRequestContext.getResponse();
        String charset = request.getCharset();
        if (actionRetrunValue == null) {
            return response;
        }
        if (actionRetrunValue instanceof HttpResponse) {
            response = (HttpResponse)actionRetrunValue;
        } else if (actionRetrunValue instanceof String) {
            String string = (String)actionRetrunValue;
            TioActionResponseProcessor.processString(response, charset, string);
        } else if (actionRetrunValue instanceof Integer) {
            TioActionResponseProcessor.processString(response, charset, actionRetrunValue.toString());
        } else if (actionRetrunValue instanceof Long) {
            TioActionResponseProcessor.processString(response, charset, actionRetrunValue.toString());
        } else if (actionRetrunValue instanceof byte[]) {
            TioActionResponseProcessor.processBytes(actionRetrunValue, response);
        } else if (actionRetrunValue instanceof Template) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            Enumeration attrs = request.getAttributeNames();
            while (attrs.hasMoreElements()) {
                String attrName = (String)attrs.nextElement();
                data.put(attrName, request.getAttribute(attrName));
            }
            String renderToString = ((Template)actionRetrunValue).renderToString(data);
            response = Resps.html((HttpResponse)response, (String)renderToString);
        } else if (actionRetrunValue instanceof ResponseVo) {
            ResponseVo responseVo = (ResponseVo)actionRetrunValue;
            int code = responseVo.getCode();
            response.setStatus(code);
            if (responseVo.getBody() != null) {
                TioActionResponseProcessor.processJson(response, responseVo.getBody(), charset);
            }
            if (responseVo.getBodyString() != null) {
                TioActionResponseProcessor.processString(response, responseVo.getBodyString(), charset);
            }
            if (responseVo.getBodyBytes() != null) {
                TioActionResponseProcessor.processBytes(responseVo.getBodyBytes(), response);
            }
        } else {
            TioActionResponseProcessor.processJson(response, actionRetrunValue, charset);
        }
        return response;
    }

    private static void processJson(HttpResponse response, Object actionRetrunValue, String charset) {
        byte[] bytes = Json.getJson().toJsonBytes(actionRetrunValue);
        TioEncryptor tioEncryptor = TioBootServer.me().getTioEncryptor();
        if (tioEncryptor != null) {
            bytes = tioEncryptor.encrypt(bytes);
        }
        response.setBody(bytes);
        String mimeTypeStr = MimeTypeUtils.getJson((String)charset);
        response.setContentType(mimeTypeStr);
    }

    private static void processBytes(Object actionRetrunValue, HttpResponse response) {
        byte[] bytes = (byte[])actionRetrunValue;
        TioEncryptor tioEncryptor = TioBootServer.me().getTioEncryptor();
        if (tioEncryptor != null) {
            bytes = tioEncryptor.encrypt(bytes);
        }
        response.setBody(bytes);
    }

    private static void processString(HttpResponse response, String charset, String string) {
        try {
            byte[] bytes = string.getBytes(charset);
            TioEncryptor tioEncryptor = TioBootServer.me().getTioEncryptor();
            if (tioEncryptor != null) {
                bytes = tioEncryptor.encrypt(bytes);
            }
            response.setBody(bytes);
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.toString(), (Throwable)e);
        }
        String mimeTypeStr = MimeTypeUtils.getText((String)charset);
        response.setContentType(mimeTypeStr);
    }

    public static Object[] buildFunctionParamValues(HttpRequest request, HttpConfig httpConfig, boolean compatibilityAssignment, String[] paramNames, Class<?>[] parameterTypes, Type[] types) {
        Object[] paramValues = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            Map params;
            Class<?> paramType = parameterTypes[i];
            if (paramType == HttpRequest.class) {
                paramValues[i] = request;
                continue;
            }
            if (paramType == HttpResponse.class) {
                paramValues[i] = TioRequestContext.getResponse();
                continue;
            }
            if (compatibilityAssignment) {
                if (paramType == HttpSession.class) {
                    paramValues[i] = request.getHttpSession();
                    continue;
                }
                if (paramType == HttpConfig.class) {
                    paramValues[i] = httpConfig;
                    continue;
                }
                if (paramType == ServerChannelContext.class) {
                    paramValues[i] = request.channelContext;
                    continue;
                }
            }
            if ((params = request.getParams()) != null && params.size() > 0) {
                try {
                    TioAsmUtils.injectParametersIntoObject(params, i, paramNames[i], paramType, paramValues);
                }
                catch (Exception e) {
                    log.error("error while inject request parameters:{},{}", paramType, paramValues[i]);
                }
                continue;
            }
            String bodyString = request.getBodyString();
            if (!StrUtil.isNotBlank((CharSequence)bodyString)) continue;
            paramValues[i] = TioActionResponseProcessor.parseJson(bodyString, paramType, types[0]);
        }
        return paramValues;
    }

    private static Object parseJson(String bodyString, Class<?> paramType, Type genericType) {
        if (!ClassUtils.isSimpleTypeOrArray(paramType)) {
            try {
                if (List.class.isAssignableFrom(paramType)) {
                    Type[] actualTypeArguments;
                    if (genericType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)genericType).getActualTypeArguments()).length > 0) {
                        Class genericClass = (Class)actualTypeArguments[0];
                        if (bodyString.startsWith("[") && bodyString.endsWith("]")) {
                            return JsonUtils.parseArray((String)bodyString, (Class)genericClass);
                        }
                    }
                    return JsonUtils.parse((String)bodyString, paramType);
                }
                return JsonUtils.parse((String)bodyString, paramType);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        log.error("{}:Attempting to deserialize JSON into a simple type or array, which is not supported directly.", paramType);
        return null;
    }
}

