/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.interceptor;

import com.litongjava.tio.http.server.intf.HttpRequestInterceptor;
import java.util.ArrayList;
import java.util.List;

public class HttpInterceptorModel {
    private String name;
    private boolean alloweStaticFile;
    private List<String> allowedUrls;
    private List<String> blockedUrls;
    private HttpRequestInterceptor interceptor;

    public HttpInterceptorModel addAllowUrl(String string) {
        if (this.allowedUrls == null) {
            this.allowedUrls = new ArrayList<String>();
        }
        this.allowedUrls.add(string);
        return this;
    }

    public HttpInterceptorModel addAllowUrls(String ... strings) {
        if (this.allowedUrls == null) {
            this.allowedUrls = new ArrayList<String>();
        }
        for (String string : strings) {
            this.allowedUrls.add(string);
        }
        return this;
    }

    public HttpInterceptorModel addBlockUrl(String string) {
        if (this.blockedUrls == null) {
            this.blockedUrls = new ArrayList<String>();
        }
        this.blockedUrls.add(string);
        return this;
    }

    public HttpInterceptorModel addBlockeUrls(String ... strings) {
        if (this.blockedUrls == null) {
            this.blockedUrls = new ArrayList<String>();
        }
        for (String string : strings) {
            this.blockedUrls.add(string);
        }
        return this;
    }

    public static HttpInterceptorModelBuilder builder() {
        return new HttpInterceptorModelBuilder();
    }

    public String getName() {
        return this.name;
    }

    public boolean isAlloweStaticFile() {
        return this.alloweStaticFile;
    }

    public List<String> getAllowedUrls() {
        return this.allowedUrls;
    }

    public List<String> getBlockedUrls() {
        return this.blockedUrls;
    }

    public HttpRequestInterceptor getInterceptor() {
        return this.interceptor;
    }

    public HttpInterceptorModel setName(String name) {
        this.name = name;
        return this;
    }

    public HttpInterceptorModel setAlloweStaticFile(boolean alloweStaticFile) {
        this.alloweStaticFile = alloweStaticFile;
        return this;
    }

    public HttpInterceptorModel setAllowedUrls(List<String> allowedUrls) {
        this.allowedUrls = allowedUrls;
        return this;
    }

    public HttpInterceptorModel setBlockedUrls(List<String> blockedUrls) {
        this.blockedUrls = blockedUrls;
        return this;
    }

    public HttpInterceptorModel setInterceptor(HttpRequestInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpInterceptorModel)) {
            return false;
        }
        HttpInterceptorModel other = (HttpInterceptorModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAlloweStaticFile() != other.isAlloweStaticFile()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<String> this$allowedUrls = this.getAllowedUrls();
        List<String> other$allowedUrls = other.getAllowedUrls();
        if (this$allowedUrls == null ? other$allowedUrls != null : !((Object)this$allowedUrls).equals(other$allowedUrls)) {
            return false;
        }
        List<String> this$blockedUrls = this.getBlockedUrls();
        List<String> other$blockedUrls = other.getBlockedUrls();
        if (this$blockedUrls == null ? other$blockedUrls != null : !((Object)this$blockedUrls).equals(other$blockedUrls)) {
            return false;
        }
        HttpRequestInterceptor this$interceptor = this.getInterceptor();
        HttpRequestInterceptor other$interceptor = other.getInterceptor();
        return !(this$interceptor == null ? other$interceptor != null : !this$interceptor.equals(other$interceptor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpInterceptorModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAlloweStaticFile() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<String> $allowedUrls = this.getAllowedUrls();
        result = result * 59 + ($allowedUrls == null ? 43 : ((Object)$allowedUrls).hashCode());
        List<String> $blockedUrls = this.getBlockedUrls();
        result = result * 59 + ($blockedUrls == null ? 43 : ((Object)$blockedUrls).hashCode());
        HttpRequestInterceptor $interceptor = this.getInterceptor();
        result = result * 59 + ($interceptor == null ? 43 : $interceptor.hashCode());
        return result;
    }

    public String toString() {
        return "HttpInterceptorModel(name=" + this.getName() + ", alloweStaticFile=" + this.isAlloweStaticFile() + ", allowedUrls=" + this.getAllowedUrls() + ", blockedUrls=" + this.getBlockedUrls() + ", interceptor=" + this.getInterceptor() + ")";
    }

    public HttpInterceptorModel() {
    }

    public HttpInterceptorModel(String name, boolean alloweStaticFile, List<String> allowedUrls, List<String> blockedUrls, HttpRequestInterceptor interceptor) {
        this.name = name;
        this.alloweStaticFile = alloweStaticFile;
        this.allowedUrls = allowedUrls;
        this.blockedUrls = blockedUrls;
        this.interceptor = interceptor;
    }

    public static class HttpInterceptorModelBuilder {
        private String name;
        private boolean alloweStaticFile;
        private List<String> allowedUrls;
        private List<String> blockedUrls;
        private HttpRequestInterceptor interceptor;

        HttpInterceptorModelBuilder() {
        }

        public HttpInterceptorModelBuilder name(String name) {
            this.name = name;
            return this;
        }

        public HttpInterceptorModelBuilder alloweStaticFile(boolean alloweStaticFile) {
            this.alloweStaticFile = alloweStaticFile;
            return this;
        }

        public HttpInterceptorModelBuilder allowedUrls(List<String> allowedUrls) {
            this.allowedUrls = allowedUrls;
            return this;
        }

        public HttpInterceptorModelBuilder blockedUrls(List<String> blockedUrls) {
            this.blockedUrls = blockedUrls;
            return this;
        }

        public HttpInterceptorModelBuilder interceptor(HttpRequestInterceptor interceptor) {
            this.interceptor = interceptor;
            return this;
        }

        public HttpInterceptorModel build() {
            return new HttpInterceptorModel(this.name, this.alloweStaticFile, this.allowedUrls, this.blockedUrls, this.interceptor);
        }

        public String toString() {
            return "HttpInterceptorModel.HttpInterceptorModelBuilder(name=" + this.name + ", alloweStaticFile=" + this.alloweStaticFile + ", allowedUrls=" + this.allowedUrls + ", blockedUrls=" + this.blockedUrls + ", interceptor=" + this.interceptor + ")";
        }
    }
}

