/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.interceptor;

import com.litongjava.tio.boot.http.interceptor.HttpInteceptorConfigure;
import com.litongjava.tio.boot.http.interceptor.HttpInterceptorModel;
import com.litongjava.tio.boot.server.TioBootServer;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.RequestLine;
import com.litongjava.tio.http.server.intf.HttpRequestInterceptor;
import java.util.List;
import java.util.Map;

public class DefaultHttpRequestInterceptorDispatcher
implements HttpRequestInterceptor {
    private HttpInteceptorConfigure configure = null;
    public static final String static_file_reges = ".*\\.[a-zA-Z0-9]+$";

    public HttpResponse doBeforeHandler(HttpRequest request, RequestLine requestLine, HttpResponse responseFromCache) throws Exception {
        if (this.configure == null) {
            this.configure = TioBootServer.me().getHttpInteceptorConfigure();
            if (this.configure == null) {
                return null;
            }
        }
        Map<String, HttpInterceptorModel> inteceptors = this.configure.getInteceptors();
        String path = requestLine.getPath();
        for (HttpInterceptorModel model : inteceptors.values()) {
            HttpResponse response;
            HttpRequestInterceptor interceptor;
            boolean isBlock = this.isMatched(path, model);
            if (!isBlock || (interceptor = model.getInterceptor()) == null || (response = interceptor.doBeforeHandler(request, requestLine, responseFromCache)) == null) continue;
            return response;
        }
        return null;
    }

    public void doAfterHandler(HttpRequest request, RequestLine requestLine, HttpResponse response, long cost) throws Exception {
        if (this.configure == null) {
            this.configure = TioBootServer.me().getHttpInteceptorConfigure();
            if (this.configure == null) {
                return;
            }
        }
        Map<String, HttpInterceptorModel> inteceptors = this.configure.getInteceptors();
        String path = requestLine.getPath();
        for (HttpInterceptorModel model : inteceptors.values()) {
            HttpRequestInterceptor interceptor;
            boolean isBlock = this.isMatched(path, model);
            if (!isBlock || (interceptor = model.getInterceptor()) == null) continue;
            interceptor.doAfterHandler(request, requestLine, response, cost);
        }
    }

    private boolean isMatched(String path, HttpInterceptorModel model) {
        boolean isAllowed;
        List<String> blockedUrls = model.getBlockedUrls();
        List<String> allowedUrls = model.getAllowedUrls();
        boolean alloweStaticFile = model.isAlloweStaticFile();
        boolean bl = isAllowed = allowedUrls != null && !allowedUrls.isEmpty() && this.isUrlAllowed(path, allowedUrls, alloweStaticFile);
        if (isAllowed) {
            return false;
        }
        boolean isBlocked = blockedUrls != null && !blockedUrls.isEmpty() && this.isUrlBlocked(path, blockedUrls, alloweStaticFile);
        return isBlocked;
    }

    private boolean isUrlBlocked(String path, List<String> blockedUrls, boolean isAlloweStaticFile) {
        return blockedUrls.stream().anyMatch(urlPattern -> this.pathMatchesPattern(path, (String)urlPattern, isAlloweStaticFile));
    }

    private boolean isUrlAllowed(String path, List<String> allowedUrls, boolean isAlloweStaticFile) {
        return allowedUrls.stream().anyMatch(urlPattern -> this.pathMatchesPattern(path, (String)urlPattern, isAlloweStaticFile));
    }

    private boolean pathMatchesPattern(String path, String pattern, boolean isAlloweStaticFile) {
        if (isAlloweStaticFile && path.matches(static_file_reges)) {
            return true;
        }
        if (pattern.endsWith("/**")) {
            return path.startsWith(pattern.substring(0, pattern.length() - 3));
        }
        if (pattern.endsWith("/*")) {
            return path.startsWith(pattern.substring(0, pattern.length() - 2));
        }
        return path.equals(pattern);
    }
}

