/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.handler.controller;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.litongjava.annotation.Delete;
import com.litongjava.annotation.Get;
import com.litongjava.annotation.Post;
import com.litongjava.annotation.Put;
import com.litongjava.annotation.RequestPath;
import com.litongjava.controller.ControllerFactory;
import com.litongjava.controller.DefaultControllerFactory;
import com.litongjava.controller.PathUnitVo;
import com.litongjava.controller.VariablePathVo;
import com.litongjava.tio.boot.server.TioBootServer;
import com.litongjava.tio.boot.utils.ParameterNameUtil;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.hutool.ArrayUtil;
import com.litongjava.tio.utils.hutool.ClassScanAnnotationHandler;
import com.litongjava.tio.utils.hutool.ClassScanHandler;
import com.litongjava.tio.utils.hutool.ClassUtil;
import com.litongjava.tio.utils.hutool.FileUtil;
import com.litongjava.tio.utils.hutool.StrUtil;
import com.litongjava.tio.utils.json.MapJsonUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioBootHttpControllerRouter {
    private static final Logger log = LoggerFactory.getLogger(TioBootHttpControllerRouter.class);
    public static final String META_PATH_KEY = "TIO_HTTP_META_PATH";
    public final Map<String, Object> PATH_BEAN_MAP = new TreeMap<String, Object>();
    public static final Map<Class<?>, Object> CLASS_BEAN_MAP = new HashMap();
    public static final Map<Object, MethodAccess> BEAN_METHODACCESS_MAP = new HashMap<Object, MethodAccess>();
    public static final Map<String, Class<?>> PATH_CLASS_MAP = new TreeMap();
    public static final Map<Class<?>, String> CLASS_PATH_MAP = new HashMap();
    public final Map<String, Method> PATH_METHOD_MAP = new TreeMap<String, Method>();
    public final Map<Method, String[]> METHOD_PARAM_NAME_MAP = new HashMap<Method, String[]>();
    public final Map<Method, Class<?>[]> METHOD_PARAM_TYPE_MAP = new HashMap<Method, Class<?>[]>();
    public final Map<String, String> PATH_FORWARD_MAP = new HashMap<String, String>();
    public final Map<Method, Object> METHOD_BEAN_MAP = new HashMap<Method, Object>();
    public final Map<String, String> PATH_METHOD_STR_MAP = new TreeMap<String, String>();
    public final Map<String, VariablePathVo[]> VARIABLE_PATH_MAP = new TreeMap<String, VariablePathVo[]>();
    public final Map<String, String> VARIABLE_PATH_METHOD_STR_MAP = new TreeMap<String, String>();
    private final StringBuilder errorStr = new StringBuilder();
    private List<Class<?>> scannedClasses = new ArrayList();

    public TioBootHttpControllerRouter() {
    }

    public TioBootHttpControllerRouter(String[] scanPackages) {
        this(scanPackages, null);
    }

    public TioBootHttpControllerRouter(String scanPackage) {
        this(scanPackage, null);
    }

    public TioBootHttpControllerRouter(String[] scanPackages, ControllerFactory controllerFactory) {
        this.addRoutes(scanPackages, controllerFactory);
    }

    public TioBootHttpControllerRouter(String scanPackage, ControllerFactory controllerFactory) {
        this(new String[]{scanPackage}, controllerFactory);
    }

    public TioBootHttpControllerRouter(Class<?>[] scanRootClasses) {
        this(TioBootHttpControllerRouter.toPackages(scanRootClasses), null);
    }

    public TioBootHttpControllerRouter(Class<?> scanRootClasse) {
        this(scanRootClasse.getPackage().getName(), null);
    }

    public TioBootHttpControllerRouter(Class<?>[] scanRootClasses, ControllerFactory controllerFactory) {
        this.addRoutes(TioBootHttpControllerRouter.toPackages(scanRootClasses), controllerFactory);
    }

    public TioBootHttpControllerRouter(Class<?> scanRootClasse, ControllerFactory controllerFactory) {
        this(new String[]{scanRootClasse.getPackage().getName()}, controllerFactory);
    }

    public void addControllers(List<Class<?>> scannedClasses) {
        if (scannedClasses == null || scannedClasses.size() < 1) {
            return;
        }
        this.scannedClasses.addAll(scannedClasses);
    }

    public void scan(ControllerFactory controllerFactory) {
        for (Class<?> clazz : this.scannedClasses) {
            this.processClazz(clazz, controllerFactory);
        }
        this.scannedClasses.clear();
        this.afterProcessClazz();
    }

    public static String[] toPackages(Class<?>[] scanRootClasses) {
        String[] scanPackages = new String[scanRootClasses.length];
        int i = 0;
        for (Class<?> clazz : scanRootClasses) {
            scanPackages[i++] = clazz.getPackage().getName();
        }
        return scanPackages;
    }

    public void addRoutes(String[] scanPackages) {
        this.addRoutes(scanPackages, null);
    }

    public void addRoutes(String[] scanPackages, ControllerFactory controllerFactory) {
        if (controllerFactory == null) {
            controllerFactory = DefaultControllerFactory.me;
        }
        final ControllerFactory controllerFactory1 = controllerFactory;
        if (scanPackages != null) {
            for (String pkg : scanPackages) {
                try {
                    ClassUtil.scanPackage((String)pkg, (ClassScanHandler)new ClassScanAnnotationHandler(RequestPath.class){

                        public void handlerAnnotation(Class<?> clazz) {
                            TioBootHttpControllerRouter.this.processClazz(clazz, controllerFactory1);
                        }
                    });
                }
                catch (Exception e) {
                    log.error(e.toString(), (Throwable)e);
                }
            }
            this.afterProcessClazz();
        }
    }

    public void processClazz(Class<?> clazz, ControllerFactory controllerFactory) {
        String beanPath = null;
        RequestPath requestPath = clazz.getAnnotation(RequestPath.class);
        if (requestPath != null) {
            beanPath = requestPath.value();
        } else {
            Get get = clazz.getAnnotation(Get.class);
            if (get != null) {
                beanPath = get.value();
            } else {
                Post post = clazz.getAnnotation(Post.class);
                if (post != null) {
                    beanPath = post.value();
                } else {
                    Put put = clazz.getAnnotation(Put.class);
                    if (put != null) {
                        beanPath = put.value();
                    } else {
                        Delete delete = clazz.getAnnotation(Delete.class);
                        if (delete != null) {
                            beanPath = delete.value();
                        } else {
                            return;
                        }
                    }
                }
            }
        }
        try {
            Object obj;
            Object bean = controllerFactory.getInstance(clazz);
            if (bean != null && !TioBootServer.me().getServerTioConfig().runOnAndroid) {
                MethodAccess access = null;
                try {
                    access = MethodAccess.get(clazz);
                    BEAN_METHODACCESS_MAP.put(bean, access);
                }
                catch (UnsupportedOperationException e) {
                    log.warn("ReflectASM is not supported on this platform for {}, using native reflection instead", (Object)clazz.getName());
                }
            }
            if ((obj = this.PATH_BEAN_MAP.get(beanPath)) != null) {
                if (!"".equals(beanPath)) {
                    log.error("mapping[{}] already exists in class [{}]", (Object)beanPath, (Object)obj.getClass().getName());
                    this.errorStr.append("mapping[" + beanPath + "] already exists in class [" + obj.getClass().getName() + "]\r\n\r\n");
                } else {
                    this.PATH_BEAN_MAP.put(beanPath, bean);
                    CLASS_BEAN_MAP.put(clazz, bean);
                    PATH_CLASS_MAP.put(beanPath, clazz);
                    CLASS_PATH_MAP.put(clazz, beanPath);
                }
            }
            Method[] methods = clazz.getDeclaredMethods();
            this.processClazzMethods(bean, beanPath, methods);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void processClazzMethods(Object bean, String beanPath, Method[] methods) {
        for (Method method : methods) {
            Delete delete;
            Put put;
            Post post;
            Get get;
            Class<?> returnType;
            int modifiers = method.getModifiers();
            if (Modifier.isPrivate(modifiers) || (returnType = method.getReturnType()) == Void.TYPE) continue;
            String methodPath = null;
            String httpMethodType = null;
            String forwardPath = null;
            RequestPath requestPath = method.getAnnotation(RequestPath.class);
            if (requestPath != null) {
                methodPath = requestPath.value();
                forwardPath = requestPath.forward();
            }
            if ((get = method.getAnnotation(Get.class)) != null) {
                methodPath = get.value();
                forwardPath = get.forward();
                httpMethodType = "GET";
            }
            if ((post = method.getAnnotation(Post.class)) != null) {
                methodPath = post.value();
                forwardPath = post.forward();
                httpMethodType = "POST";
            }
            if ((put = method.getAnnotation(Put.class)) != null) {
                methodPath = put.value();
                forwardPath = put.forward();
                httpMethodType = "PUT";
            }
            if ((delete = method.getAnnotation(Delete.class)) != null) {
                methodPath = delete.value();
                forwardPath = delete.forward();
                httpMethodType = "DELETE";
            }
            if (methodPath == null) {
                methodPath = "/" + method.getName();
            }
            String completePath = beanPath + methodPath;
            Class<?>[] parameterTypes = method.getParameterTypes();
            try {
                String[] parameterNames = ParameterNameUtil.getParameterNames(method);
                String key = null;
                String existingMethodStr = null;
                if (httpMethodType == null) {
                    key = completePath;
                    existingMethodStr = this.PATH_METHOD_STR_MAP.get(key);
                } else {
                    key = httpMethodType + " " + completePath;
                    existingMethodStr = this.PATH_METHOD_STR_MAP.get(key);
                }
                if (existingMethodStr != null) {
                    log.error("mapping[{}] already exists in method [{}]", (Object)completePath, (Object)existingMethodStr);
                    this.errorStr.append("mapping[" + completePath + "] already exists in method [" + existingMethodStr + "]\r\n\r\n");
                    continue;
                }
                String methodStr = this.methodToStr(method, parameterNames);
                this.PATH_METHOD_MAP.put(key, method);
                this.PATH_METHOD_STR_MAP.put(key, methodStr);
                this.METHOD_PARAM_NAME_MAP.put(method, parameterNames);
                this.METHOD_PARAM_TYPE_MAP.put(method, parameterTypes);
                if (forwardPath != null && !forwardPath.trim().isEmpty()) {
                    String forwardKey = httpMethodType + " " + forwardPath;
                    this.PATH_FORWARD_MAP.put(key, forwardPath);
                    this.PATH_METHOD_STR_MAP.put(forwardKey, methodStr);
                    this.PATH_METHOD_MAP.put(forwardKey, method);
                }
                this.METHOD_BEAN_MAP.put(method, bean);
            }
            catch (Throwable e) {
                log.error(e.toString(), e);
            }
        }
    }

    public void afterProcessClazz() {
        this.processVariablePath();
        this.printMapping();
    }

    private void printMapping() {
        String pathClassMapStr = MapJsonUtils.toPrettyJson(PATH_CLASS_MAP);
        String pathMethodstrMapStr = MapJsonUtils.toPrettyJson(this.PATH_METHOD_STR_MAP);
        String variablePathMethodstrMapStr = MapJsonUtils.toPrettyJson(this.VARIABLE_PATH_METHOD_STR_MAP);
        if (EnvUtils.getBoolean((String)"server.http.controller.printMapping", (boolean)true)) {
            if (PATH_CLASS_MAP.size() > 0) {
                log.info("controller class  mapping\r\n{}", (Object)pathClassMapStr);
            }
            if (this.PATH_METHOD_STR_MAP.size() > 0) {
                log.info("controller method mapping\r\n{}", (Object)pathMethodstrMapStr);
            }
            if (this.VARIABLE_PATH_METHOD_STR_MAP.size() > 0) {
                log.info("controller restful mapping\r\n{}", (Object)variablePathMethodstrMapStr);
            }
        }
        if (EnvUtils.getBoolean((String)"server.http.controller.writeMapping", (boolean)false)) {
            try {
                FileUtil.writeString((String)pathClassMapStr, (String)"tio_boot_path_class.json", (String)"utf-8");
                FileUtil.writeString((String)pathMethodstrMapStr, (String)"tio_boot_path_method.json", (String)"utf-8");
                FileUtil.writeString((String)variablePathMethodstrMapStr, (String)"tio_boot_variablepath_method.json", (String)"utf-8");
                if (this.errorStr.length() > 0) {
                    FileUtil.writeString((String)this.errorStr.toString(), (String)"tio_boot_error.txt", (String)"utf-8");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void processVariablePath() {
        Set<Map.Entry<String, Method>> set = this.PATH_METHOD_MAP.entrySet();
        for (Map.Entry<String, Method> entry : set) {
            String key = entry.getKey();
            Method method = entry.getValue();
            if (!StrUtil.contains((CharSequence)key, (char)'{') || !StrUtil.contains((CharSequence)key, (char)'}')) continue;
            String httpMethod = null;
            String path = null;
            int spaceIndex = key.indexOf(32);
            if (spaceIndex == -1) {
                path = key;
            } else {
                httpMethod = key.substring(0, spaceIndex).toUpperCase();
                path = key.substring(spaceIndex + 1);
            }
            String[] pathUnits = StrUtil.split((String)path, (String)"/");
            PathUnitVo[] pathUnitVos = new PathUnitVo[pathUnits.length];
            boolean isVarPath = false;
            for (int i = 0; i < pathUnits.length; ++i) {
                PathUnitVo pathUnitVo = new PathUnitVo();
                String pathUnit = pathUnits[i];
                if (StrUtil.contains((CharSequence)pathUnit, (char)'{') || StrUtil.contains((CharSequence)pathUnit, (char)'}')) {
                    if (StrUtil.startWith((CharSequence)pathUnit, (CharSequence)"{") && StrUtil.endWith((CharSequence)pathUnit, (CharSequence)"}")) {
                        String varName = StrUtil.subBetween((CharSequence)pathUnit, (CharSequence)"{", (CharSequence)"}");
                        if (ArrayUtil.contains((Object[])this.METHOD_PARAM_NAME_MAP.get(method), (Object)varName)) {
                            isVarPath = true;
                            pathUnitVo.setVar(true);
                            pathUnitVo.setPath(varName);
                        } else {
                            log.error("path:{}, method [{}] does not contain parameter named {}", new Object[]{path, method, varName});
                            this.errorStr.append("path:{" + path + "}, method [" + method + "] does not contain parameter named " + varName + "\r\n\r\n");
                        }
                    } else {
                        pathUnitVo.setVar(false);
                        pathUnitVo.setPath(pathUnit);
                    }
                } else {
                    pathUnitVo.setVar(false);
                    pathUnitVo.setPath(pathUnit);
                }
                pathUnitVos[i] = pathUnitVo;
            }
            if (!isVarPath) continue;
            VariablePathVo variablePathVo = new VariablePathVo(path, method, pathUnitVos);
            this.addVariablePathVo(httpMethod, pathUnits.length, variablePathVo);
        }
    }

    public static <T> T getController(Class<T> clazz) {
        return (T)CLASS_BEAN_MAP.get(clazz);
    }

    public static String getRequestPath(Class<?> clazz) {
        return CLASS_PATH_MAP.get(clazz);
    }

    private void addVariablePathVo(String httpMethod, Integer pathUnitCount, VariablePathVo variablePathVo) {
        String key = null;
        key = httpMethod != null ? httpMethod.toUpperCase() + " " + pathUnitCount : pathUnitCount + "";
        VariablePathVo[] existValue = this.VARIABLE_PATH_MAP.get(key);
        if (existValue == null) {
            existValue = new VariablePathVo[]{variablePathVo};
            this.VARIABLE_PATH_MAP.put(key, existValue);
        } else {
            VariablePathVo[] newExistValue = new VariablePathVo[existValue.length + 1];
            System.arraycopy(existValue, 0, newExistValue, 0, existValue.length);
            newExistValue[newExistValue.length - 1] = variablePathVo;
            this.VARIABLE_PATH_MAP.put(key, newExistValue);
        }
        String methodStr = this.methodToStr(variablePathVo.getMethod(), this.METHOD_PARAM_NAME_MAP.get(variablePathVo.getMethod()));
        if (httpMethod != null) {
            this.VARIABLE_PATH_METHOD_STR_MAP.put(httpMethod + " " + variablePathVo.getPath(), methodStr);
        } else {
            this.VARIABLE_PATH_METHOD_STR_MAP.put(variablePathVo.getPath(), methodStr);
        }
    }

    private String methodToStr(Method method, String[] parameterNames) {
        return method.getDeclaringClass().getName() + "." + method.getName() + "(" + ArrayUtil.join((String[])parameterNames, (String)",") + ")";
    }

    public Method getActionByPath(String path, String httpMethod, HttpRequest request) {
        String key = httpMethod.toUpperCase() + " " + path;
        Method method = this.PATH_METHOD_MAP.get(key);
        if (method != null) {
            return method;
        }
        method = this.PATH_METHOD_MAP.get(path);
        if (method != null) {
            return method;
        }
        String[] pathUnitsOfRequest = StrUtil.split((String)path, (String)"/");
        String varPathKey = httpMethod.toUpperCase() + " " + pathUnitsOfRequest.length;
        VariablePathVo[] variablePathVos = this.VARIABLE_PATH_MAP.get(varPathKey);
        if (variablePathVos == null) {
            variablePathVos = this.VARIABLE_PATH_MAP.get(pathUnitsOfRequest.length + "");
        }
        if (variablePathVos != null) {
            TreeMap<Integer, VariablePathVo> matched = new TreeMap<Integer, VariablePathVo>();
            for (VariablePathVo variablePathVo : variablePathVos) {
                PathUnitVo[] pathUnitVos = variablePathVo.getPathUnits();
                boolean isMatch = true;
                Integer fixedSegments = 0;
                for (int i = 0; i < pathUnitVos.length; ++i) {
                    PathUnitVo pathUnitVo = pathUnitVos[i];
                    String pathOfVo = pathUnitVo.getPath();
                    String pathUnitOfRequest = pathUnitsOfRequest[i];
                    if (pathUnitVo.isVar()) {
                        request.addParam(pathOfVo, (Object)pathUnitOfRequest);
                        continue;
                    }
                    if (!StrUtil.equals((CharSequence)pathOfVo, (CharSequence)pathUnitOfRequest)) {
                        isMatch = false;
                        break;
                    }
                    Integer n = fixedSegments;
                    Integer n2 = fixedSegments = Integer.valueOf(fixedSegments + 1);
                }
                if (!isMatch) continue;
                matched.put(fixedSegments, variablePathVo);
            }
            if (matched.size() > 0) {
                Integer maxKey = (Integer)matched.lastKey();
                VariablePathVo variablePathVo = (VariablePathVo)matched.get(maxKey);
                String metapath = variablePathVo.getPath();
                String forward = this.PATH_FORWARD_MAP.get(httpMethod.toUpperCase() + " " + metapath);
                if (StrUtil.isNotBlank((CharSequence)forward)) {
                    request.requestLine.path = forward;
                }
                method = variablePathVo.getMethod();
                return method;
            }
        }
        return null;
    }
}

