/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.handler.controller;

import com.esotericsoftware.reflectasm.MethodAccess;
import com.litongjava.annotation.EnableCORS;
import com.litongjava.annotation.GatewayCheck;
import com.litongjava.annotation.RequiresAuthentication;
import com.litongjava.annotation.RequiresPermissions;
import com.litongjava.tio.boot.aspect.IGateWayCheckAspect;
import com.litongjava.tio.boot.aspect.IRequiresAuthenticationAspect;
import com.litongjava.tio.boot.aspect.IRequiresPermissionsAspect;
import com.litongjava.tio.boot.http.controller.ControllerInterceptor;
import com.litongjava.tio.boot.http.handler.controller.TioBootHttpControllerRouter;
import com.litongjava.tio.boot.http.utils.TioActionResponseProcessor;
import com.litongjava.tio.boot.logging.LoggingInterceptor;
import com.litongjava.tio.boot.server.TioBootServer;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.server.model.HttpCors;
import com.litongjava.tio.http.server.util.CORSUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class DynamicRequestController {
    private IGateWayCheckAspect gatewayCheckAspect;
    private IRequiresAuthenticationAspect requiresAuthenticationAspect;
    private IRequiresPermissionsAspect requiresPermissionsAspect;

    public HttpResponse process(HttpRequest request, HttpConfig httpConfig, boolean compatibilityAssignment, TioBootHttpControllerRouter routes, Method actionMethod) {
        HttpResponse response = this.performPreActionChecks(request, routes, actionMethod);
        if (response != null) {
            return response;
        }
        ControllerInterceptor controllerInterceptor = TioBootServer.me().getControllerInterceptor();
        if (controllerInterceptor != null) {
            response = controllerInterceptor.before(request, actionMethod);
            if (response != null) {
                return response;
            }
            Object actionReturnValue = this.executeAction(request, httpConfig, compatibilityAssignment, routes, actionMethod);
            Object targetController = routes.METHOD_BEAN_MAP.get(actionMethod);
            actionReturnValue = controllerInterceptor.after(request, targetController, actionMethod, actionReturnValue);
            response = this.processPostAction(targetController, actionMethod, actionReturnValue);
        } else {
            Object actionReturnValue = this.executeAction(request, httpConfig, compatibilityAssignment, routes, actionMethod);
            Object targetController = routes.METHOD_BEAN_MAP.get(actionMethod);
            response = this.processPostAction(targetController, actionMethod, actionReturnValue);
        }
        return response;
    }

    private HttpResponse performPreActionChecks(HttpRequest request, TioBootHttpControllerRouter routes, Method actionMethod) {
        RequiresPermissions requiresPermissionsAnnotation;
        GatewayCheck gatewayCheckAnnotation;
        Object targetController = routes.METHOD_BEAN_MAP.get(actionMethod);
        if (actionMethod.isAnnotationPresent(GatewayCheck.class) && (gatewayCheckAnnotation = actionMethod.getAnnotation(GatewayCheck.class)) != null) {
            if (this.gatewayCheckAspect == null) {
                this.gatewayCheckAspect = TioBootServer.me().getGateWayCheckAspect();
            }
            if (this.gatewayCheckAspect != null) {
                return this.gatewayCheckAspect.check(request, targetController, actionMethod, gatewayCheckAnnotation);
            }
        }
        if (actionMethod.isAnnotationPresent(RequiresAuthentication.class)) {
            if (this.requiresAuthenticationAspect == null) {
                this.requiresAuthenticationAspect = TioBootServer.me().getRequiresAuthenticationAspect();
            }
            if (this.requiresAuthenticationAspect != null) {
                return this.requiresAuthenticationAspect.check(request, targetController, actionMethod);
            }
        }
        if (actionMethod.isAnnotationPresent(RequiresPermissions.class) && (requiresPermissionsAnnotation = actionMethod.getAnnotation(RequiresPermissions.class)) != null) {
            if (this.requiresPermissionsAspect == null) {
                this.requiresPermissionsAspect = TioBootServer.me().getRequiresPermissionsAspect();
            }
            if (this.requiresPermissionsAspect != null) {
                return this.requiresPermissionsAspect.check(request, targetController, actionMethod, requiresPermissionsAnnotation);
            }
        }
        return null;
    }

    private Object executeAction(HttpRequest request, HttpConfig httpConfig, boolean compatibilityAssignment, TioBootHttpControllerRouter routes, Method actionMethod) {
        LoggingInterceptor loggingInterceptor;
        String[] paramNames = routes.METHOD_PARAM_NAME_MAP.get(actionMethod);
        Class<?>[] parameterTypes = routes.METHOD_PARAM_TYPE_MAP.get(actionMethod);
        Object actionReturnValue = null;
        Object targetController = routes.METHOD_BEAN_MAP.get(actionMethod);
        MethodAccess methodAccess = TioBootHttpControllerRouter.BEAN_METHODACCESS_MAP.get(targetController);
        boolean runOnAndroid = TioBootServer.me().getServerTioConfig().runOnAndroid;
        Object[] paramValues = null;
        if (parameterTypes != null && parameterTypes.length > 0) {
            paramValues = TioActionResponseProcessor.buildFunctionParamValues(request, httpConfig, compatibilityAssignment, paramNames, parameterTypes, actionMethod.getGenericParameterTypes());
        }
        if ((loggingInterceptor = TioBootServer.me().getLoggingInterceptor()) != null) {
            loggingInterceptor.before(request, targetController, actionMethod, paramValues);
        }
        if (!runOnAndroid && methodAccess != null) {
            actionReturnValue = paramValues == null ? methodAccess.invoke(targetController, actionMethod.getName(), new Object[0]) : methodAccess.invoke(targetController, actionMethod.getName(), paramValues);
        } else if (paramValues == null) {
            try {
                actionReturnValue = actionMethod.invoke(targetController, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            try {
                actionReturnValue = actionMethod.invoke(targetController, paramValues);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        if (loggingInterceptor != null) {
            actionReturnValue = loggingInterceptor.after(request, targetController, actionMethod, paramValues, actionReturnValue);
        }
        return actionReturnValue;
    }

    private HttpResponse processPostAction(Object targetController, Method actionMethod, Object actionReturnValue) {
        HttpResponse response = TioActionResponseProcessor.afterExecuteAction(actionReturnValue);
        EnableCORS enableCORS = actionMethod.getAnnotation(EnableCORS.class);
        if (enableCORS == null) {
            enableCORS = targetController.getClass().getAnnotation(EnableCORS.class);
        }
        if (enableCORS != null) {
            CORSUtils.enableCORS((HttpResponse)response, (HttpCors)new HttpCors(enableCORS));
        }
        return response;
    }
}

