/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.handler.common;

import com.litongjava.tio.boot.http.TioRequestContext;
import com.litongjava.tio.boot.utils.HttpFileDataUtils;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.server.util.CORSUtils;
import com.litongjava.tio.utils.http.ContentTypeUtils;
import com.litongjava.tio.utils.hutool.FilenameUtils;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpFileDataHandler {
    private static final Logger log = LoggerFactory.getLogger(HttpFileDataHandler.class);

    public HttpResponse index(HttpRequest request) {
        String path = request.getRequestLine().getPath();
        log.info(path);
        HttpResponse response = TioRequestContext.getResponse();
        CORSUtils.enableCORS((HttpResponse)response);
        File file = new File("." + File.separator + path);
        String suffix = FilenameUtils.getSuffix((String)path);
        String contentType = ContentTypeUtils.getContentType((String)suffix);
        if (!file.exists()) {
            response.setStatus(404);
            return response;
        }
        long fileLength = file.length();
        long lastModified = file.lastModified();
        String etag = HttpFileDataUtils.generateETag(file, lastModified, fileLength);
        HttpFileDataUtils.setCacheHeaders(response, lastModified, etag, contentType, suffix);
        if (HttpFileDataUtils.isClientCacheValid(request, lastModified, etag)) {
            response.setStatus(304);
            return response;
        }
        String range = request.getHeader("range");
        if (range != null && range.startsWith("bytes=")) {
            return HttpFileDataUtils.handleRangeRequest(response, file, range, fileLength, contentType);
        }
        return HttpFileDataUtils.handleFullFileRequest(response, file, fileLength, contentType);
    }
}

