/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.http.forward;

import com.litongjava.tio.boot.http.forward.RequestProxyCallback;
import com.litongjava.tio.boot.utils.OkHttpRequestUtils;
import com.litongjava.tio.boot.utils.OkHttpResponseUtils;
import com.litongjava.tio.http.common.HeaderName;
import com.litongjava.tio.http.common.HeaderValue;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.http.common.HttpResponse;
import com.litongjava.tio.http.common.HttpResponseStatus;
import com.litongjava.tio.http.common.ResponseHeaderKey;
import com.litongjava.tio.http.common.utils.HttpIpUtils;
import com.litongjava.tio.utils.http.OkHttpClientPool;
import com.litongjava.tio.utils.snowflake.SnowflakeIdUtils;
import com.litongjava.tio.utils.thread.TioThreadUtils;
import java.io.IOException;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class TioHttpProxy {
    public static void reverseProxy(String targetUrl, HttpRequest httpRequest, HttpResponse httpResponse) {
        TioHttpProxy.reverseProxy(targetUrl, httpRequest, httpResponse, null);
    }

    public static void reverseProxy(String targetUrl, HttpRequest httpRequest, HttpResponse httpResponse, RequestProxyCallback callback) {
        long id = SnowflakeIdUtils.id();
        httpRequest.getHeaders().remove("host");
        String realIp = HttpIpUtils.getRealIp((HttpRequest)httpRequest);
        if (callback != null) {
            TioThreadUtils.submit(() -> {
                try {
                    callback.saveRequest(id, realIp, httpRequest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        httpRequest.addHeader("x-forwarded-for", realIp);
        Request okHttpReqeust = OkHttpRequestUtils.buildOkHttpRequest(targetUrl, httpRequest);
        OkHttpClient httpClient = OkHttpClientPool.getHttpClient();
        long startTime = System.currentTimeMillis();
        try (Response okHttpResponse = httpClient.newCall(okHttpReqeust).execute();){
            long endTime = System.currentTimeMillis();
            OkHttpResponseUtils.toTioHttpResponse(okHttpResponse, httpResponse);
            HttpResponseStatus status = httpResponse.getStatus();
            Map headers = httpResponse.getHeaders();
            HeaderValue contentEncoding = (HeaderValue)headers.get(HeaderName.Content_Encoding);
            if (contentEncoding != null && HeaderValue.Content_Encoding.gzip.equals((Object)contentEncoding)) {
                httpResponse.setSkipGzipped(true);
            }
            byte[] body = httpResponse.getBody();
            if (callback != null) {
                TioThreadUtils.submit(() -> {
                    try {
                        callback.saveResponse(id, endTime - startTime, status.status, headers, contentEncoding, body);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                });
            }
            httpResponse.removeHeaders(ResponseHeaderKey.Transfer_Encoding);
            httpResponse.removeHeaders(ResponseHeaderKey.Server);
            httpResponse.removeHeaders(ResponseHeaderKey.Date);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

