/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.context;

import com.litongjava.aio.AioId;
import com.litongjava.annotation.AImport;
import com.litongjava.annotation.RequestPath;
import com.litongjava.context.BootConfiguration;
import com.litongjava.context.Context;
import com.litongjava.context.ServerListener;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.jfinal.aop.context.AopContext;
import com.litongjava.jfinal.aop.process.BeanProcess;
import com.litongjava.jfinal.aop.process.BeforeStartConfigurationProcess;
import com.litongjava.jfinal.aop.process.ComponentAnnotation;
import com.litongjava.jfinal.aop.scanner.ComponentScanner;
import com.litongjava.jfinal.aop.scanner.DefaultComponentScanner;
import com.litongjava.model.cache.ICache;
import com.litongjava.tio.boot.decode.TioDecodeExceptionHandler;
import com.litongjava.tio.boot.http.handler.controller.TioBootHttpControllerRouter;
import com.litongjava.tio.boot.http.handler.internal.AopControllerFactory;
import com.litongjava.tio.boot.http.handler.internal.RequestStatisticsHandler;
import com.litongjava.tio.boot.http.handler.internal.ResponseStatisticsHandler;
import com.litongjava.tio.boot.http.handler.internal.StaticResourceHandler;
import com.litongjava.tio.boot.http.handler.internal.TioBootHttpRequestDispatcher;
import com.litongjava.tio.boot.http.handler.internal.TioServerSessionRateLimiter;
import com.litongjava.tio.boot.http.interceptor.DefaultHttpRequestInterceptorDispatcher;
import com.litongjava.tio.boot.server.TioBootAioListener;
import com.litongjava.tio.boot.server.TioBootServer;
import com.litongjava.tio.boot.server.TioBootServerHandler;
import com.litongjava.tio.boot.swagger.TioSwaggerGenerateUtils;
import com.litongjava.tio.boot.swagger.TioSwaggerV2Config;
import com.litongjava.tio.boot.utils.ClassCheckUtils;
import com.litongjava.tio.boot.websocket.DefaultWebSocketRouter;
import com.litongjava.tio.boot.websocket.TioBootWebSocketDispatcher;
import com.litongjava.tio.boot.websocket.WebSocketRouter;
import com.litongjava.tio.http.common.HttpConfig;
import com.litongjava.tio.http.common.handler.ITioHttpRequestHandler;
import com.litongjava.tio.http.common.session.id.ISessionIdGenerator;
import com.litongjava.tio.http.common.session.id.impl.UUIDSessionIdGenerator;
import com.litongjava.tio.http.common.session.limiter.SessionRateLimiter;
import com.litongjava.tio.http.server.handler.HttpRequestHandler;
import com.litongjava.tio.http.server.intf.HttpRequestInterceptor;
import com.litongjava.tio.http.server.router.DefaultHttpRequestFunctionRouter;
import com.litongjava.tio.http.server.router.DefaultHttpRequestRouter;
import com.litongjava.tio.http.server.router.HttpRequestFunctionRouter;
import com.litongjava.tio.http.server.router.HttpRequestGroovyRouter;
import com.litongjava.tio.http.server.router.HttpRequestRouter;
import com.litongjava.tio.server.ServerTioConfig;
import com.litongjava.tio.server.intf.ServerAioHandler;
import com.litongjava.tio.server.intf.ServerAioListener;
import com.litongjava.tio.utils.cache.AbsCache;
import com.litongjava.tio.utils.cache.CacheFactory;
import com.litongjava.tio.utils.cache.caffeine.CaffeineCacheFactory;
import com.litongjava.tio.utils.cache.mapcache.ConcurrentMapCacheFactory;
import com.litongjava.tio.utils.cache.redismap.RedisMapCacheFactory;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.json.MapJsonUtils;
import com.litongjava.tio.utils.thread.TioThreadUtils;
import com.litongjava.tio.websocket.common.WebSocketSnowflakeId;
import com.litongjava.tio.websocket.server.WebsocketServerConfig;
import com.litongjava.tio.websocket.server.handler.IWebSocketHandler;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TioApplicationContext
implements Context {
    private static final Logger log = LoggerFactory.getLogger(TioApplicationContext.class);
    private final TioBootServer tioBootServer = TioBootServer.me();
    private int port;

    public Context run(Class<?>[] primarySources, String[] args) {
        return this.run(primarySources, null, args);
    }

    public Context run(Class<?>[] primarySources, BootConfiguration tioBootConfiguration, String[] args) {
        boolean shouldStartServer;
        HttpRequestFunctionRouter requestFunctionRouter;
        HttpRequestRouter httpRequestRouter;
        long scanClassStartTime = 0L;
        long scanClassEndTime = 0L;
        EnvUtils.buildCmdArgsMap((String[])args);
        EnvUtils.load();
        TioThreadUtils.start();
        List<Class<?>> scannedClasses = null;
        boolean printScannedClasses = EnvUtils.getBoolean((String)"aop.print.scanned.classes", (boolean)false);
        if (ClassCheckUtils.check("com.litongjava.jfinal.aop.Aop")) {
            scanClassStartTime = System.currentTimeMillis();
            ComponentAnnotation.addComponentAnnotation(RequestPath.class);
            ComponentScanner componentScanner = AopContext.me().getComponentScanner();
            if (componentScanner != null) {
                try {
                    scannedClasses = componentScanner.scan((Class[])primarySources, printScannedClasses);
                }
                catch (Exception exception) {}
            } else {
                try {
                    scannedClasses = new DefaultComponentScanner().scan((Class[])primarySources, printScannedClasses);
                }
                catch (Exception e) {
                    log.error("Error during component scanning", (Throwable)e);
                }
            }
            if (scannedClasses != null) {
                log.info("Scanned classes count: {}", (Object)scannedClasses.size());
            }
            for (Class<?> primarySource : primarySources) {
                Class[] imports;
                if (!primarySource.isAnnotationPresent(AImport.class)) continue;
                AImport importAnnotation = primarySource.getAnnotation(AImport.class);
                for (Class clazz : imports = importAnnotation.value()) {
                    scannedClasses.add(clazz);
                }
            }
            scannedClasses = this.processBeforeStartConfiguration(scannedClasses);
            scanClassEndTime = System.currentTimeMillis();
        } else {
            log.info("AOP class not found: {}", (Object)"com.litongjava.jfinal.aop.Aop");
        }
        long initServerStartTime = System.currentTimeMillis();
        this.port = EnvUtils.getInt((String)"server.port", (int)80);
        String contextPath = EnvUtils.get((String)"server.context-path", (String)"");
        HttpConfig httpConfig = this.configureHttp(this.port, contextPath);
        httpConfig.setBindIp(EnvUtils.get((String)"server.address", (String)"0.0.0.0"));
        TioBootHttpControllerRouter controllerRouter = new TioBootHttpControllerRouter();
        this.tioBootServer.setControllerRouter(controllerRouter);
        CacheFactory cacheFactory = this.determineCacheFactory();
        log.info("Using cache: {}", cacheFactory.getClass());
        ITioHttpRequestHandler usedHttpRequestHandler = this.tioBootServer.getHttpRequestDispatcher();
        if (usedHttpRequestHandler == null) {
            usedHttpRequestHandler = new TioBootHttpRequestDispatcher();
            this.tioBootServer.setHttpRequestDispatcher(usedHttpRequestHandler);
        }
        IWebSocketHandler defaultWebSocketHandler = this.tioBootServer.getWebSocketHandlerDispatcher();
        WebSocketRouter webSocketRouter = this.tioBootServer.getWebSocketRouter();
        if (defaultWebSocketHandler == null) {
            TioBootWebSocketDispatcher webSocketDispatcher = new TioBootWebSocketDispatcher();
            if (webSocketRouter == null) {
                webSocketRouter = new DefaultWebSocketRouter();
            }
            webSocketDispatcher.setWebSocketRouter(webSocketRouter);
            this.tioBootServer.setWebSocketRouter(webSocketRouter);
            defaultWebSocketHandler = webSocketDispatcher;
            this.tioBootServer.setWebSocketHandlerDispatcher(defaultWebSocketHandler);
        }
        WebsocketServerConfig wsServerConfig = new WebsocketServerConfig(Integer.valueOf(this.port));
        ServerAioHandler serverAioHandler = this.tioBootServer.getServerAioHandler();
        TioDecodeExceptionHandler decodeExceptionHandler = this.tioBootServer.getDecodeExceptionHandler();
        TioBootServerHandler serverHandler = new TioBootServerHandler(wsServerConfig, defaultWebSocketHandler, httpConfig, usedHttpRequestHandler, serverAioHandler, decodeExceptionHandler);
        ServerAioListener externalServerListener = this.tioBootServer.getServerAioListener();
        TioBootAioListener serverAioListener = new TioBootAioListener(externalServerListener);
        ServerTioConfig serverTioConfig = new ServerTioConfig("tio-boot");
        serverTioConfig.setServerAioListener((ServerAioListener)serverAioListener);
        serverTioConfig.setServerAioHandler((ServerAioHandler)serverHandler);
        serverTioConfig.setCacheFactory(cacheFactory);
        serverTioConfig.setDefaultIpRemovalListenerWrapper();
        serverTioConfig.statOn = EnvUtils.getBoolean((String)"server.stat.enable", (boolean)false);
        Integer workerThreads = EnvUtils.getInteger((String)"server.worker.threads");
        if (workerThreads != null) {
            serverTioConfig.setWorkerThreads(workerThreads.intValue());
        }
        int heartbeatTimeout = EnvUtils.getInt((String)"server.beartbeat.timeout", (int)0);
        log.info("Server heartbeat timeout: {}", (Object)heartbeatTimeout);
        serverTioConfig.setHeartbeatTimeout((long)heartbeatTimeout);
        WebSocketSnowflakeId snowflakeId = new WebSocketSnowflakeId();
        serverTioConfig.setTioUuid((AioId)snowflakeId);
        serverTioConfig.setReadBufferSize(EnvUtils.getInt((String)"server.read.buffer.size", (int)30720));
        serverTioConfig.setAttribute("TIO_HTTP_REQ_HANDLER", (Object)usedHttpRequestHandler);
        if (httpConfig.isUseSession()) {
            if (httpConfig.getSessionStore() == null) {
                long sessionTimeout = httpConfig.getSessionTimeout();
                AbsCache sessionCache = cacheFactory.register(httpConfig.getSessionCacheName(), null, Long.valueOf(sessionTimeout));
                httpConfig.setSessionStore((ICache)sessionCache);
            }
            if (httpConfig.getSessionIdGenerator() == null) {
                httpConfig.setSessionIdGenerator((ISessionIdGenerator)UUIDSessionIdGenerator.INSTANCE);
            }
        }
        this.tioBootServer.init(serverTioConfig, wsServerConfig, httpConfig);
        HttpRequestInterceptor defaultHttpInterceptorDispatcher = this.tioBootServer.getHttpRequestInterceptorDispatcher();
        if (defaultHttpInterceptorDispatcher == null) {
            defaultHttpInterceptorDispatcher = new DefaultHttpRequestInterceptorDispatcher();
            this.tioBootServer.setHttpRequestInterceptorDispatcher(defaultHttpInterceptorDispatcher);
        }
        if ((httpRequestRouter = this.tioBootServer.getRequestRouter()) == null) {
            httpRequestRouter = new DefaultHttpRequestRouter();
            this.tioBootServer.setRequestRouter(httpRequestRouter);
        }
        if ((requestFunctionRouter = this.tioBootServer.getRequestFunctionRouter()) == null) {
            requestFunctionRouter = new DefaultHttpRequestFunctionRouter();
            this.tioBootServer.setRequestFunctionRouter(requestFunctionRouter);
        }
        long initServerEndTime = System.currentTimeMillis();
        long configStartTime = System.currentTimeMillis();
        if (tioBootConfiguration != null) {
            try {
                tioBootConfiguration.config();
            }
            catch (Exception e) {
                if (EnvUtils.getBoolean((String)"boot.exception.exit", (boolean)true)) {
                    log.error("Failed to configure BootConfiguration:", (Throwable)e);
                    System.exit(1);
                }
                throw new RuntimeException("Failed to configure BootConfiguration", e);
            }
        }
        if (ClassCheckUtils.check("com.litongjava.jfinal.aop.Aop") && scannedClasses != null && !scannedClasses.isEmpty()) {
            this.initAnnotation(scannedClasses);
        }
        HttpRequestGroovyRouter groovyRouter = this.tioBootServer.getRequestGroovyRouter();
        RequestStatisticsHandler requestStatisticsHandler = this.tioBootServer.getRequestStatisticsHandler();
        ResponseStatisticsHandler responseStatisticsHandler = this.tioBootServer.getResponseStatisticsHandler();
        HttpRequestHandler forwardHandler = this.tioBootServer.getForwardHandler();
        HttpRequestHandler notFoundHandler = this.tioBootServer.getNotFoundHandler();
        StaticResourceHandler staticResourceHandler = this.tioBootServer.getStaticResourceHandler();
        HttpRequestInterceptor httpRequestValidationInterceptor = this.tioBootServer.getHttpRequestValidationInterceptor();
        if (usedHttpRequestHandler instanceof TioBootHttpRequestDispatcher) {
            ((TioBootHttpRequestDispatcher)usedHttpRequestHandler).init(httpConfig, cacheFactory, defaultHttpInterceptorDispatcher, httpRequestValidationInterceptor, httpRequestRouter, groovyRouter, requestFunctionRouter, controllerRouter, forwardHandler, notFoundHandler, requestStatisticsHandler, responseStatisticsHandler, staticResourceHandler);
        }
        long configEndTime = System.currentTimeMillis();
        long serverStartTime = System.currentTimeMillis();
        ServerListener serverListener = this.tioBootServer.getTioBootServerListener();
        if (serverListener != null) {
            serverListener.beforeStart((Class[])primarySources, args);
        }
        if (shouldStartServer = EnvUtils.getBoolean((String)"server.listening.enable", (boolean)true)) {
            try {
                this.tioBootServer.start(httpConfig.getBindIp(), httpConfig.getBindPort());
                if (serverListener != null) {
                    serverListener.afterStarted((Class[])primarySources, args, (Context)this);
                }
            }
            catch (IOException e) {
                log.error("Failed to start server", (Throwable)e);
                this.close();
                System.exit(1);
            }
        }
        long serverEndTime = System.currentTimeMillis();
        long routeStartTime = System.currentTimeMillis();
        if (shouldStartServer) {
            Map httpMapping;
            Map<String, IWebSocketHandler> webSocketMapping = webSocketRouter.all();
            if (!webSocketMapping.isEmpty()) {
                log.info("WebSocket handler:\n{}", (Object)MapJsonUtils.toPrettyJson(webSocketMapping));
            }
            if (!(httpMapping = httpRequestRouter.all()).isEmpty()) {
                log.info("HTTP handler:\n{}", (Object)MapJsonUtils.toPrettyJson((Map)httpMapping));
            }
            if (controllerRouter != null && scannedClasses != null) {
                AopControllerFactory aopFactory = new AopControllerFactory();
                if (!scannedClasses.isEmpty()) {
                    controllerRouter.addControllers(scannedClasses);
                }
                controllerRouter.scan(aopFactory);
                TioSwaggerV2Config swaggerV2Config = this.tioBootServer.getSwaggerV2Config();
                if (swaggerV2Config != null && swaggerV2Config.isEnable()) {
                    String swaggerJson = TioSwaggerGenerateUtils.generateSwaggerJson(controllerRouter, swaggerV2Config.getApiInfo());
                    swaggerV2Config.setSwaggerJson(swaggerJson);
                }
            }
        } else {
            log.info("{}:false", (Object)"server.listening.enable");
        }
        long routeEndTime = System.currentTimeMillis();
        long scanClassTime = scanClassEndTime - scanClassStartTime;
        long initServerTime = initServerEndTime - initServerStartTime;
        long configTime = configEndTime - configStartTime;
        long serverTime = serverEndTime - serverStartTime;
        long routeTime = routeEndTime - routeStartTime;
        log.info("Initialization times (ms): Total: {}, Scan Classes: {}, Init Server: {}, Config: {}, Server: {}, Route: {}", new Object[]{scanClassTime + initServerTime + configTime + serverTime + routeTime, scanClassTime, initServerTime, configTime, serverTime, routeTime});
        if (shouldStartServer) {
            this.printUrl(this.port, contextPath);
        }
        return this;
    }

    private void printUrl(int port, String contextPath) {
        log.info("Server port: {}", (Object)port);
        StringBuilder fullUrl = new StringBuilder("http://localhost");
        if (port != 80) {
            fullUrl.append(":").append(port);
        }
        if (contextPath != null && !contextPath.isEmpty()) {
            if (!contextPath.startsWith("/")) {
                fullUrl.append("/");
            }
            fullUrl.append(contextPath);
        }
        log.info("Access URL: {}", (Object)fullUrl.toString());
    }

    private List<Class<?>> processBeforeStartConfiguration(List<Class<?>> scannedClasses) {
        BeforeStartConfigurationProcess beforeStartConfigurationProcess = new BeforeStartConfigurationProcess();
        try {
            return beforeStartConfigurationProcess.process(scannedClasses);
        }
        catch (Exception e) {
            if (!EnvUtils.getBoolean((String)"boot.exception.exit", (boolean)false)) {
                throw new RuntimeException(e);
            }
            log.error("Failed to processBeforeStartConfiguration:", (Throwable)e);
            System.exit(1);
            return null;
        }
    }

    public void initAnnotation(List<Class<?>> scannedClasses) {
        BeanProcess beanProcess = new BeanProcess();
        try {
            beanProcess.initAnnotation(scannedClasses);
        }
        catch (Exception e) {
            if (EnvUtils.getBoolean((String)"boot.exception.exit", (boolean)true)) {
                log.error("Faild to initAnnotation,Exit JVM", (Throwable)e);
                System.exit(1);
            }
            throw new RuntimeException("Faild to initAnnotation", e);
        }
    }

    public void close() {
        log.info("Stopping server...");
        ServerListener serverListener = TioBootServer.me().getTioBootServerListener();
        try {
            if (serverListener != null) {
                serverListener.beforeStop();
            }
            this.tioBootServer.stop();
            TioThreadUtils.stop();
            if (ClassCheckUtils.check("com.litongjava.jfinal.aop.Aop")) {
                Aop.close();
            }
            if (serverListener != null) {
                serverListener.afterStopped();
            }
        }
        catch (Exception e) {
            log.error("Error during server shutdown", (Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.tioBootServer.isRunning();
    }

    public void restart(Class<?>[] primarySources, String[] args) {
        this.close();
        this.run(primarySources, args);
    }

    private HttpConfig configureHttp(int port, String contextPath) {
        Integer multipartMaxFileSize;
        String pageRoot = EnvUtils.get((String)"server.resources.static-locations", (String)"classpath:/pages");
        HttpConfig httpConfig = new HttpConfig(Integer.valueOf(port), null, contextPath, null);
        try {
            httpConfig.setPageRoot(pageRoot);
        }
        catch (Exception e) {
            log.error("Error setting page root", (Throwable)e);
        }
        boolean autoReoload = EnvUtils.getBoolean((String)"server.resources.auto.reload");
        if (autoReoload || EnvUtils.isDevMode()) {
            httpConfig.setMonitorFileChange(autoReoload);
        }
        Integer maxLiveTimeOfStaticRes = EnvUtils.getInteger((String)"http.max.live.time.of.static.res");
        String page404 = EnvUtils.get((String)"server.404");
        String page500 = EnvUtils.get((String)"server.500");
        if (maxLiveTimeOfStaticRes != null) {
            httpConfig.setMaxLiveTimeOfStaticRes(maxLiveTimeOfStaticRes.intValue());
        }
        if (page404 != null) {
            httpConfig.setPage404(page404);
        }
        if (page500 != null) {
            httpConfig.setPage500(page500);
        }
        boolean enableSession = EnvUtils.getBoolean((String)"server.session.enable", (boolean)false);
        log.info("Server session enabled: {}", (Object)enableSession);
        httpConfig.setUseSession(enableSession);
        httpConfig.setCheckHost(EnvUtils.getBoolean((String)"http.checkHost", (boolean)false));
        Integer multipartMaxRequestSize = EnvUtils.getInteger((String)"http.multipart.max-request-size");
        if (multipartMaxRequestSize != null && multipartMaxRequestSize > 0) {
            httpConfig.setMaxLengthOfPostBody(multipartMaxRequestSize.intValue());
        }
        if ((multipartMaxFileSize = EnvUtils.getInteger((String)"http.multipart.max-file-size")) != null && multipartMaxFileSize > 0) {
            httpConfig.setMaxLengthOfMultiBody(multipartMaxFileSize.intValue());
        }
        if (EnvUtils.getBoolean((String)"http.enable.request.limit", (boolean)true)) {
            httpConfig.setSessionRateLimiter((SessionRateLimiter)new TioServerSessionRateLimiter());
        }
        return httpConfig;
    }

    private CacheFactory determineCacheFactory() {
        ConcurrentMapCacheFactory cacheFactory;
        String cacheStore = EnvUtils.get((String)"server.cache.store", (String)"concurrent_map");
        switch (cacheStore.toLowerCase()) {
            case "redis": {
                if (ClassCheckUtils.check("com.litongjava.tio.utils.cache.redismap.RedisMapCacheFactory")) {
                    cacheFactory = RedisMapCacheFactory.INSTANCE;
                    break;
                }
            }
            case "caffeine": {
                if (ClassCheckUtils.check("com.github.benmanes.caffeine.cache.LoadingCache")) {
                    cacheFactory = CaffeineCacheFactory.INSTANCE;
                    break;
                }
            }
            default: {
                cacheFactory = ConcurrentMapCacheFactory.INSTANCE;
            }
        }
        return cacheFactory;
    }

    public int getPort() {
        return this.port;
    }
}

