/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.utils;

import com.litongjava.tio.boot.admin.utils.GeoLite2Utils;
import com.litongjava.tio.boot.admin.vo.IpGeoInfo;
import com.maxmind.geoip2.DatabaseReader;
import com.maxmind.geoip2.exception.GeoIp2Exception;
import com.maxmind.geoip2.model.CityResponse;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Objects;

public class IpDatabaseUtils {
    private static CityResponse getCityResponse(DatabaseReader reader, String ip) throws IOException, GeoIp2Exception {
        InetAddress ipAddress = InetAddress.getByName(ip);
        return reader.city(ipAddress);
    }

    public static String getCountry(DatabaseReader reader, String ip) throws Exception {
        CityResponse response = IpDatabaseUtils.getCityResponse(reader, ip);
        return (String)response.getCountry().getNames().get("zh-CN");
    }

    public static String getProvince(DatabaseReader reader, String ip) throws Exception {
        CityResponse response = IpDatabaseUtils.getCityResponse(reader, ip);
        return (String)response.getMostSpecificSubdivision().getNames().get("zh-CN");
    }

    public static String getCity(DatabaseReader reader, String ip) throws Exception {
        CityResponse response = IpDatabaseUtils.getCityResponse(reader, ip);
        return (String)response.getCity().getNames().get("zh-CN");
    }

    public static Double getLongitude(DatabaseReader reader, String ip) throws Exception {
        CityResponse response = IpDatabaseUtils.getCityResponse(reader, ip);
        return response.getLocation().getLongitude();
    }

    public static Double getLatitude(DatabaseReader reader, String ip) throws Exception {
        CityResponse response = IpDatabaseUtils.getCityResponse(reader, ip);
        return response.getLocation().getLatitude();
    }

    public static IpGeoInfo getGeoInfo(DatabaseReader reader, String ip) {
        CityResponse response;
        try {
            response = IpDatabaseUtils.getCityResponse(reader, ip);
        }
        catch (GeoIp2Exception | IOException e) {
            throw new RuntimeException(e);
        }
        Double longitude = response.getLocation().getLongitude();
        Double latitude = response.getLocation().getLatitude();
        String city = response.getCity().getName();
        String country = response.getCountry().getName();
        String location = String.join((CharSequence)", ", Objects.toString(city, ""), Objects.toString(country, "")).replaceAll("(^,\\s*|,\\s*$)", "");
        return new IpGeoInfo(longitude, latitude, location);
    }

    public static IpGeoInfo getGeoInfo(String ip) {
        DatabaseReader reader = GeoLite2Utils.getDatabase();
        return IpDatabaseUtils.getGeoInfo(reader, ip);
    }
}

