/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.utils;

import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.ContentTypeUtils;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;

public class AwsS3Utils {
    public static final String urlFormat = "https://%s.s3.us-west-1.amazonaws.com/%s";
    public static final String bucketName = EnvUtils.get((String)"AWS_S3_BUCKET_NAME");
    public static final String regionName = EnvUtils.get((String)"AWS_S3_REGION_NAME");
    public static final String accessKeyId = EnvUtils.get((String)"AWS_S3_ACCESS_KEY_ID");
    public static final String secretAccessKey = EnvUtils.get((String)"AWS_S3_SECRET_ACCESS_KEY");

    public static PutObjectResponse upload(S3Client client, String bucketName, String targetName, byte[] fileContent, String suffix) {
        try {
            String contentType = ContentTypeUtils.getContentType((String)suffix);
            PutObjectRequest putOb = (PutObjectRequest)PutObjectRequest.builder().bucket(bucketName).key(targetName).contentType(contentType).build();
            PutObjectResponse putObject = client.putObject(putOb, RequestBody.fromBytes((byte[])fileContent));
            return putObject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getUrl(String targetName) {
        return String.format(urlFormat, bucketName, targetName);
    }

    public static S3Client buildClient() {
        AwsBasicCredentials awsCreds = AwsBasicCredentials.create((String)accessKeyId, (String)secretAccessKey);
        StaticCredentialsProvider staticCredentialsProvider = StaticCredentialsProvider.create((AwsCredentials)awsCreds);
        Region region = Region.of((String)regionName);
        S3ClientBuilder builder = S3Client.builder();
        S3Client s3 = (S3Client)((S3ClientBuilder)((S3ClientBuilder)builder.region(region)).credentialsProvider((AwsCredentialsProvider)staticCredentialsProvider)).build();
        return s3;
    }
}

