/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.services;

import com.litongjava.db.TableInput;
import com.litongjava.db.activerecord.Row;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.model.body.RespBodyVo;
import com.litongjava.table.services.ApiTable;
import com.litongjava.tio.boot.admin.dao.SystemUploadFileDao;
import com.litongjava.tio.boot.admin.services.StorageService;
import com.litongjava.tio.boot.admin.services.SysConfigConstantsService;
import com.litongjava.tio.boot.admin.services.SystemUploadFileService;
import com.litongjava.tio.boot.admin.vo.SystemTxCosConfigVo;
import com.litongjava.tio.boot.admin.vo.UploadResultVo;
import com.litongjava.tio.http.common.UploadFile;
import com.litongjava.tio.utils.crypto.Md5Utils;
import com.litongjava.tio.utils.http.ContentTypeUtils;
import com.litongjava.tio.utils.hutool.FilenameUtils;
import com.litongjava.tio.utils.snowflake.SnowflakeIdUtils;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.PutObjectRequest;
import com.qcloud.cos.model.PutObjectResult;
import com.qcloud.cos.region.Region;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TencentStorageService
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(TencentStorageService.class);

    public RespBodyVo upload(UploadFile uploadFile) {
        String filename = uploadFile.getName();
        long threadId = Thread.currentThread().getId();
        if (threadId > 31L) {
            threadId %= 31L;
        }
        if (threadId < 0L) {
            threadId = 0L;
        }
        long id = SnowflakeIdUtils.id();
        String suffix = FilenameUtils.getSuffix((String)filename);
        String newFilename = id + "." + suffix;
        String targetName = "public/" + newFilename;
        UploadResultVo vo = this.uploadFile(id, targetName, uploadFile, suffix);
        return RespBodyVo.ok((Object)vo);
    }

    private String upload(COSClient cosClient, String bucketName, String targetName, byte[] fileContent, String suffix) {
        PutObjectRequest putObjectRequest = this.getPutObjectRequest(targetName, fileContent, suffix, bucketName);
        PutObjectResult putObjectResult = cosClient.putObject(putObjectRequest);
        return putObjectResult.getETag();
    }

    private PutObjectRequest getPutObjectRequest(String targetName, byte[] fileContent, String suffix, String bucketName) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(fileContent);
        ObjectMetadata objectMetadata = new ObjectMetadata();
        objectMetadata.setContentLength((long)fileContent.length);
        objectMetadata.setContentType(ContentTypeUtils.getContentType((String)suffix));
        return new PutObjectRequest(bucketName, targetName, (InputStream)byteArrayInputStream, objectMetadata);
    }

    private COSClient getCosClient(SystemTxCosConfigVo systemTxCosConfig) {
        BasicCOSCredentials cred = new BasicCOSCredentials(systemTxCosConfig.getSecretId(), systemTxCosConfig.getSecretKey());
        ClientConfig clientConfig = new ClientConfig(new Region(systemTxCosConfig.getRegion()));
        return new COSClient((COSCredentials)cred, clientConfig);
    }

    @Override
    public String getUrl(String bucketName, String targetName) {
        SystemTxCosConfigVo systemTxCosConfig = ((SysConfigConstantsService)Aop.get(SysConfigConstantsService.class)).getSystemTxCosConfig();
        String region = systemTxCosConfig.getRegion();
        String domain = "https://" + bucketName + ".cos." + region + ".myqcloud.com";
        return domain + "/" + targetName;
    }

    @Override
    public UploadResultVo getUrlById(String id) {
        return this.getUrlById(Long.parseLong(id));
    }

    @Override
    public UploadResultVo getUrlById(long id) {
        Row record = ((SystemUploadFileDao)Aop.get(SystemUploadFileDao.class)).getFileBasicInfoById(id);
        if (record == null) {
            return null;
        }
        String url = this.getUrl(record.getStr("bucket_name"), record.getStr("target_name"));
        String originFilename = record.getStr("fielename");
        String md5 = record.getStr("md5");
        Long size = record.getLong("size");
        return new UploadResultVo(id, originFilename, size, url, md5);
    }

    @Override
    public UploadResultVo getUrlByMd5(String md5) {
        return ((SystemUploadFileService)Aop.get(SystemUploadFileService.class)).getUrlByMd5(md5);
    }

    @Override
    public RespBodyVo upload(String category, UploadFile uploadFile) {
        return null;
    }

    @Override
    public UploadResultVo uploadFile(String category, UploadFile uploadFile) {
        return null;
    }

    @Override
    public UploadResultVo uploadFile(long id, String targetName, UploadFile uploadFile, String suffix) {
        byte[] fileContent = uploadFile.getData();
        String filename = uploadFile.getName();
        long size = uploadFile.getSize();
        SystemTxCosConfigVo systemTxCosConfig = ((SysConfigConstantsService)Aop.get(SysConfigConstantsService.class)).getSystemTxCosConfig();
        COSClient cosClient = this.getCosClient(systemTxCosConfig);
        String bucketName = systemTxCosConfig.getBucketName();
        String etag = null;
        try {
            etag = this.upload(cosClient, bucketName, targetName, fileContent, suffix);
        }
        catch (Exception e) {
            log.error("Error uploading file to Tencent COS", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            cosClient.shutdown();
        }
        log.info("Uploaded to COS with ETag: {}", (Object)etag);
        String md5 = Md5Utils.md5Hex((byte[])fileContent);
        TableInput kv = TableInput.create().set((Object)"md5", (Object)md5).set((Object)"name", (Object)filename).set((Object)"size", (Object)size).set((Object)"platform", (Object)"tencent").set((Object)"region_name", (Object)systemTxCosConfig.getRegion()).set((Object)"bucket_name", (Object)bucketName).set((Object)"target_name", (Object)targetName).set((Object)"file_id", (Object)etag);
        ApiTable.save((String)"tio_boot_admin_system_upload_file", (TableInput)kv);
        String downloadUrl = this.getUrl(bucketName, targetName);
        UploadResultVo uploadResultVo = new UploadResultVo();
        uploadResultVo.setId(id).setUrl(downloadUrl).setSize(size);
        uploadResultVo.setMd5(md5).setTargetName(targetName);
        return uploadResultVo;
    }
}

