/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.services;

import com.litongjava.db.TableInput;
import com.litongjava.db.TableResult;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.model.body.RespBodyVo;
import com.litongjava.table.services.ApiTable;
import com.litongjava.tio.boot.admin.client.StableDiffusionClient;
import com.litongjava.tio.boot.admin.services.GoogleStorageService;
import com.litongjava.tio.http.common.UploadFile;
import com.litongjava.tio.utils.json.Json;
import com.litongjava.tio.utils.thread.TioThreadUtils;
import java.io.IOException;
import java.util.Map;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StableDiffusionService {
    private static final Logger log = LoggerFactory.getLogger(StableDiffusionService.class);

    public RespBodyVo generateSd3(UploadFile uploadFile, Map<String, Object> requestMap) {
        RespBodyVo retval = null;
        Response response = ((StableDiffusionClient)Aop.get(StableDiffusionClient.class)).generateSd3(uploadFile, requestMap);
        if (response.isSuccessful()) {
            try {
                String contentType = response.header("Content-Type");
                String xRequestId = response.header("x-request-id");
                if (xRequestId == null) {
                    xRequestId = System.currentTimeMillis() + "";
                }
                assert (contentType != null);
                String suffix = contentType.split("/")[1];
                String fileName = xRequestId + "." + suffix;
                assert (response.body() != null);
                byte[] bytes = response.body().bytes();
                retval = ((GoogleStorageService)Aop.get(GoogleStorageService.class)).uploadImageBytes(bytes, fileName, suffix, contentType);
            }
            catch (IOException e) {
                e.printStackTrace();
                return RespBodyVo.fail((String)e.getMessage());
            }
        } else {
            String string = null;
            try {
                assert (response.body() != null);
                string = response.body().string();
                Object parse = Json.getJson().parseObject(string);
                RespBodyVo fail = RespBodyVo.fail((String)"Fail");
                fail.setData(parse);
                return fail;
            }
            catch (IOException e) {
                e.printStackTrace();
                return RespBodyVo.fail((String)e.getMessage());
            }
        }
        if (retval != null) {
            RespBodyVo finalRetval = retval;
            TioThreadUtils.submit(() -> {
                try {
                    Object kv = null;
                    if (uploadFile != null) {
                        kv = ((GoogleStorageService)Aop.get(GoogleStorageService.class)).uploadImageToGoogle(uploadFile).getData();
                    }
                    this.saveToDb(requestMap, kv, finalRetval.getData());
                }
                catch (Exception e) {
                    log.error("\u5f02\u6b65\u4efb\u52a1\u6267\u884c\u5f02\u5e38", (Throwable)e);
                }
            });
        }
        return retval;
    }

    public void saveToDb(Map<String, Object> requestMap, Object srcImage, Object dstImage) {
        TableInput kv = TableInput.create().set(requestMap);
        if (srcImage != null) {
            Object[] srcImages = new Object[]{srcImage};
            kv.set((Object)"src_images", (Object)srcImages);
        }
        Object[] dstImages = new Object[]{dstImage};
        kv.set((Object)"dst_images", (Object)dstImages);
        String[] jsonFields = new String[]{"src_images", "dst_images"};
        TableResult save = ApiTable.save((String)"tio_boot_admin_sd_generated_history", (TableInput)kv, (String[])jsonFields);
        log.info("save result:{}", (Object)save);
    }
}

