/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.services;

import com.jfinal.kit.Kv;
import com.litongjava.db.TableInput;
import com.litongjava.db.TableResult;
import com.litongjava.db.activerecord.Row;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.model.page.DbPage;
import com.litongjava.mongo.MongoDb;
import com.litongjava.table.model.DataPageRequest;
import com.litongjava.table.model.DataQueryRequest;
import com.litongjava.tio.boot.admin.services.EmqxService;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.result.DeleteResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

public class MongodbJsonService {
    public TableResult<DbPage<Document>> page(String f, TableInput kv) {
        FindIterable iterable;
        DataPageRequest dataPageRequest = new DataPageRequest(kv);
        Integer pageNo = dataPageRequest.getPageNo();
        Integer pageSize = dataPageRequest.getPageSize();
        DataQueryRequest queryRequest = new DataQueryRequest(kv);
        int sortValue = 1;
        if (queryRequest.getIsAsc() != null && !queryRequest.getIsAsc().booleanValue()) {
            sortValue = -1;
        }
        Document queryDocument = new Document();
        Iterator iterator = kv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Document queryValue = new Document("$regex", (Object)(".*" + value + ".*")).append("$options", (Object)"i");
            queryDocument.put(key, (Object)queryValue);
            iterator.remove();
        }
        MongoDatabase database = MongoDb.getDatabase();
        MongoCollection collection = database.getCollection(f);
        long totalCount = collection.count((Bson)queryDocument);
        String orderBy = queryRequest.getOrderBy();
        if (orderBy != null) {
            Document sortDocument = new Document(orderBy, (Object)sortValue);
            iterable = collection.find((Bson)queryDocument).sort((Bson)sortDocument).skip((pageNo - 1) * pageSize).limit(pageSize.intValue());
        } else {
            iterable = collection.find((Bson)queryDocument).skip((pageNo - 1) * pageSize).limit(10);
        }
        MongoCursor cursor = iterable.iterator();
        ArrayList<Document> lists = new ArrayList<Document>();
        while (cursor.hasNext()) {
            Document document = (Document)cursor.next();
            Object idObject = document.get((Object)"_id");
            String idValue = null;
            if (idObject instanceof String) {
                idValue = (String)idObject;
            } else {
                ObjectId objectId = document.getObjectId((Object)"_id");
                idValue = objectId.toHexString();
            }
            document.remove((Object)"_id");
            document.put("id", (Object)idValue);
            lists.add(document);
        }
        DbPage pageData = new DbPage();
        pageData.setTotal(Integer.valueOf((int)totalCount));
        pageData.setList(lists);
        return TableResult.ok((Object)pageData);
    }

    public TableResult<List<Row>> list(String f, TableInput kv) {
        FindIterable iterable;
        new DataPageRequest(kv);
        DataQueryRequest queryRequest = new DataQueryRequest(kv);
        int sortValue = 1;
        if (queryRequest.getIsAsc() != null && !queryRequest.getIsAsc().booleanValue()) {
            sortValue = -1;
        }
        Document queryDocument = new Document();
        Iterator iterator = kv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Document queryValue = new Document("$regex", (Object)(".*" + value + ".*")).append("$options", (Object)"i");
            queryDocument.put(key, (Object)queryValue);
            iterator.remove();
        }
        System.out.println(queryDocument);
        MongoDatabase database = MongoDb.getDatabase();
        MongoCollection collection = database.getCollection(f);
        String orderBy = queryRequest.getOrderBy();
        if (orderBy != null) {
            Document sortDocument = new Document(orderBy, (Object)sortValue);
            iterable = collection.find((Bson)queryDocument).sort((Bson)sortDocument);
        } else {
            iterable = collection.find((Bson)queryDocument);
        }
        ArrayList<Row> lists = new ArrayList<Row>();
        for (Document document : iterable) {
            ObjectId objectId = document.getObjectId((Object)"_id");
            String hexString = objectId.toHexString();
            document.remove((Object)"_id");
            Row record = new Row();
            record.set("id", (Object)hexString);
            Set entrySet = document.entrySet();
            for (Map.Entry e : entrySet) {
                record.set((String)e.getKey(), e.getValue());
            }
            lists.add(record);
        }
        return TableResult.ok(lists);
    }

    public TableResult<List<Row>> listAll(String f) {
        MongoDatabase database = MongoDb.getDatabase();
        MongoCollection collection = database.getCollection(f);
        FindIterable iterable = collection.find();
        ArrayList<Row> lists = new ArrayList<Row>();
        for (Document document : iterable) {
            ObjectId objectId = document.getObjectId((Object)"_id");
            String hexString = objectId.toHexString();
            document.remove((Object)"_id");
            Row record = new Row();
            record.set("id", (Object)hexString);
            Set entrySet = document.entrySet();
            for (Map.Entry e : entrySet) {
                record.set((String)e.getKey(), e.getValue());
            }
            lists.add(record);
        }
        return TableResult.ok(lists);
    }

    public TableResult<Kv> saveOrUpdate(String tableName, TableInput kv) {
        String[] jsonFields = (String[])kv.remove((Object)"json_fields");
        return this.saveOrUpdate(tableName, kv, jsonFields);
    }

    public TableResult<Kv> saveOrUpdate(String tableName, TableInput kv, String[] jsonFields) {
        if (tableName.equals("mqtt_user")) {
            return ((EmqxService)Aop.get(EmqxService.class)).saveOrUpdate(tableName, kv);
        }
        return null;
    }

    public TableResult<Boolean> deleteById(String f, String id) {
        Bson filter;
        MongoDatabase database = MongoDb.getDatabase();
        MongoCollection collection = database.getCollection(f);
        DeleteResult result = collection.deleteOne(filter = Filters.eq((String)"_id", (Object)new ObjectId(id)));
        if (result.getDeletedCount() > 0L) {
            return TableResult.ok();
        }
        return TableResult.fail();
    }
}

