/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.services;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.google.firebase.cloud.StorageClient;
import com.jfinal.kit.Kv;
import com.litongjava.db.TableInput;
import com.litongjava.db.TableResult;
import com.litongjava.db.activerecord.Db;
import com.litongjava.db.activerecord.Row;
import com.litongjava.model.body.RespBodyVo;
import com.litongjava.table.services.ApiTable;
import com.litongjava.tio.http.common.UploadFile;
import com.litongjava.tio.utils.crypto.Md5Utils;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.http.ContentTypeUtils;
import com.litongjava.tio.utils.hutool.FilenameUtils;
import com.litongjava.tio.utils.snowflake.SnowflakeIdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoogleStorageService {
    private static final Logger log = LoggerFactory.getLogger(GoogleStorageService.class);
    String bucketName = EnvUtils.getStr((String)"BUCKET_NAME");

    public RespBodyVo uploadImageToGoogle(UploadFile uploadFile) {
        String filename = uploadFile.getName();
        String suffix = FilenameUtils.getSuffix((String)filename);
        String contentType = ContentTypeUtils.getContentType((String)suffix);
        byte[] fileContent = uploadFile.getData();
        return this.uploadImageBytes(fileContent, filename, suffix, contentType);
    }

    public RespBodyVo uploadImageBytes(byte[] fileContent, String filename, String suffix, String contentType) {
        return this.uploadBytes(fileContent, filename, suffix, "public/images", contentType);
    }

    public RespBodyVo uploadBytes(byte[] fileContent, String filename, String suffix, String folderName, String contentType) {
        long threadId = Thread.currentThread().getId();
        if (threadId > 31L) {
            threadId %= 31L;
        }
        if (threadId < 0L) {
            threadId = 0L;
        }
        long id = SnowflakeIdUtils.id();
        String newFilename = id + "." + suffix;
        String targetName = folderName + "/" + newFilename;
        this.uploadBytesToGoogle(fileContent, targetName, contentType);
        String md5 = Md5Utils.md5Hex((byte[])fileContent);
        TableInput kv = TableInput.create();
        kv.set((Object)"md5", (Object)md5);
        kv.set((Object)"filename", (Object)filename);
        kv.set((Object)"file_size", (Object)fileContent.length);
        kv.set((Object)"platform", (Object)"google");
        kv.set((Object)"bucket_name", (Object)this.bucketName);
        String replaceTargetName = this.replaceTargetName(targetName);
        kv.set((Object)"target_name", (Object)replaceTargetName);
        kv.set((Object)"file_id", (Object)id);
        TableResult save = ApiTable.save((String)"tio_boot_admin_system_upload_file", (TableInput)kv);
        String downloadUrl = this.getUrl(this.bucketName, replaceTargetName);
        Kv kv1 = Kv.create();
        kv1.set((Object)"id", (Object)(((Kv)save.getData()).get((Object)"id") + ""));
        kv1.set((Object)"url", (Object)downloadUrl);
        return RespBodyVo.ok((Object)kv1);
    }

    public Blob uploadBytesToGoogle(byte[] fileContent, String targetName, String contentType) {
        Bucket bucket = StorageClient.getInstance().bucket();
        BlobId blobId = BlobId.of((String)bucket.getName(), (String)targetName);
        BlobInfo blobInfo = BlobInfo.newBuilder((BlobId)blobId).setContentType(contentType).build();
        Storage storage = bucket.getStorage();
        Blob blob = storage.create(blobInfo, fileContent, new Storage.BlobTargetOption[0]);
        log.info("blob:{}", (Object)blob);
        return blob;
    }

    private String replaceTargetName(String targetName) {
        return targetName.replace("/", "%2F");
    }

    public String getUrlByFileId(long fileId) {
        String sql = "select bucket_name,target_name from tio_boot_admin_system_upload_file where id=?";
        Row record = Db.findFirst((String)sql, (Object[])new Object[]{fileId});
        return this.getUrl(record.getStr("bucket_name"), record.getStr("target_name"));
    }

    public String getUrl(String name, String targetName) {
        String template = "https://firebasestorage.googleapis.com/v0/b/%s.appspot.com/o/%s?alt=media";
        return String.format(template, name, targetName);
    }
}

