/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.services;

import com.jfinal.kit.Kv;
import com.litongjava.db.TableInput;
import com.litongjava.db.TableResult;
import com.litongjava.mongo.MongoDb;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.security.SecureRandom;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmqxService {
    private static final Logger log = LoggerFactory.getLogger(EmqxService.class);
    private static final String CHARACTERS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
    private static final SecureRandom random = new SecureRandom();

    public Document getNewUserDocument(String userId, String username, String password) {
        String salt = EmqxService.randomString(32);
        String passwordHash = DigestUtils.sha256Hex((String)(password + salt));
        Document newUser = new Document("username", (Object)username).append("is_superuser", (Object)false).append("user_id", (Object)userId).append("password", (Object)password).append("salt", (Object)salt).append("password_hash", (Object)passwordHash);
        return newUser;
    }

    public String addAuthUser(String userId, String username, String password) {
        MongoDatabase database = MongoDb.getDatabase();
        MongoCollection collection = database.getCollection("mqtt_user");
        Document document = this.getNewUserDocument(userId, username, password);
        collection.insertOne((Object)document);
        return "success";
    }

    public TableResult<Kv> getEmqxAuth(Object userId) {
        Bson filter;
        MongoDatabase database = MongoDb.getDatabase();
        MongoCollection collection = database.getCollection("mqtt_user");
        Document document = (Document)collection.find(filter = Filters.eq((String)"user_id", (Object)userId)).first();
        if (document != null) {
            String username = document.getString((Object)"username");
            String password = document.getString((Object)"password");
            Kv kv = Kv.by((Object)"username", (Object)username).set((Object)"password", (Object)password).set((Object)"userId", userId);
            return TableResult.ok((Object)kv);
        }
        return TableResult.fail((String)("not found user:" + userId));
    }

    public void addOrUpdateUser(List<Kv> usernames) {
        MongoDatabase database = MongoDb.getDatabase();
        MongoCollection collection = database.getCollection("mqtt_user");
        for (Kv kv : usernames) {
            Document newUser;
            String password = kv.getStr((Object)"password");
            String username = kv.getStr((Object)"username");
            Bson filter = Filters.eq((String)"username", (Object)username);
            Document document = (Document)collection.find(filter).first();
            if (document != null) {
                newUser = this.getNewUserDocument(username, password);
                Document set = new Document("$set", (Object)newUser);
                collection.updateOne(filter, (Bson)set);
                continue;
            }
            newUser = this.getNewUserDocument(username, password);
            collection.insertOne((Object)newUser);
        }
    }

    private Document getNewUserDocument(String username, String password) {
        log.info("password:{}", (Object)password);
        String salt = EmqxService.randomString(32);
        String passwordHash = DigestUtils.sha256Hex((String)(password + salt));
        Document newUser = new Document("username", (Object)username).append("is_superuser", (Object)false).append("password", (Object)password).append("salt", (Object)salt).append("password_hash", (Object)passwordHash);
        return newUser;
    }

    public void updateAuthUser(Object idValue, String userId, String username, String password) {
        MongoDatabase database = MongoDb.getDatabase();
        MongoCollection collection = database.getCollection("mqtt_user");
        Bson filter = Filters.eq((String)"_id", (Object)new ObjectId((String)idValue));
        Document newUser = this.getNewUserDocument(username, password);
        newUser.put("user_id", (Object)userId);
        Document set = new Document("$set", (Object)newUser);
        collection.updateOne(filter, (Bson)set);
    }

    public TableResult<Kv> saveOrUpdate(String tableName, TableInput kv) {
        Object idValue = kv.remove((Object)"id");
        if (idValue != null) {
            this.updateAuthUser(idValue, kv.getStr((Object)"user_id"), kv.getStr((Object)"username"), kv.getStr((Object)"password"));
            return TableResult.ok();
        }
        this.addAuthUser(kv.getStr((Object)"user_id"), kv.getStr((Object)"username"), kv.getStr((Object)"password"));
        return TableResult.ok();
    }

    public static String randomString(int length) {
        StringBuilder salt = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            int index = random.nextInt(CHARACTERS.length());
            salt.append(CHARACTERS.charAt(index));
        }
        return salt.toString();
    }
}

