/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.services;

import com.litongjava.db.activerecord.Db;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.tio.boot.admin.services.AccessLogService;
import com.litongjava.tio.boot.admin.vo.AccessLogVo;
import com.litongjava.tio.http.common.HttpRequest;
import com.litongjava.tio.utils.thread.TioThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbArticleAccessLogService {
    private static final Logger log = LoggerFactory.getLogger(DbArticleAccessLogService.class);
    public static final String sql = "INSERT INTO tio_boot_admin_article_access_log (id,channel_id,ip,user_id,method,uri,user_agent,header,body) values(?,?,?,?,?,?,?,?,?)";
    AccessLogService accessLogService = (AccessLogService)Aop.get(AccessLogService.class);

    public void saveDb(AccessLogVo vo) {
        Db.updateBySql((String)sql, (Object[])new Object[]{vo.id, vo.channel_id, vo.clientIp, vo.userId, vo.method, vo.uri, vo.user_agent, vo.header, vo.body});
    }

    public void save(HttpRequest request) {
        AccessLogVo accessLog = this.accessLogService.parseToAccessLog(request);
        TioThreadUtils.execute(() -> {
            try {
                this.saveDb(accessLog);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        });
    }
}

