/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.services;

import com.jfinal.kit.Kv;
import com.jfinal.kit.StrKit;
import com.litongjava.db.TableInput;
import com.litongjava.db.TableResult;
import com.litongjava.db.activerecord.Row;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.model.body.RespBodyVo;
import com.litongjava.table.services.ApiTable;
import com.litongjava.tio.boot.admin.dao.SystemUploadFileDao;
import com.litongjava.tio.boot.admin.services.StorageService;
import com.litongjava.tio.boot.admin.services.SystemUploadFileService;
import com.litongjava.tio.boot.admin.utils.AwsS3Utils;
import com.litongjava.tio.boot.admin.vo.UploadResultVo;
import com.litongjava.tio.http.common.UploadFile;
import com.litongjava.tio.utils.crypto.Md5Utils;
import com.litongjava.tio.utils.hutool.FilenameUtils;
import com.litongjava.tio.utils.snowflake.SnowflakeIdUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;

public class AwsS3StorageService
implements StorageService {
    private static final Logger log = LoggerFactory.getLogger(AwsS3StorageService.class);

    @Override
    public RespBodyVo upload(String category, UploadFile uploadFile) {
        if (StrKit.isBlank((String)category)) {
            category = "default";
        }
        UploadResultVo uploadResultVo = this.uploadFile(category, uploadFile);
        return RespBodyVo.ok((Object)uploadResultVo);
    }

    @Override
    public UploadResultVo uploadFile(String category, UploadFile uploadFile) {
        long id = SnowflakeIdUtils.id();
        String suffix = FilenameUtils.getSuffix((String)uploadFile.getName());
        String newFilename = id + "." + suffix;
        String targetName = category + "/" + newFilename;
        return this.uploadFile(id, targetName, uploadFile, suffix);
    }

    @Override
    public UploadResultVo uploadFile(long id, String targetName, UploadFile uploadFile, String suffix) {
        String name = uploadFile.getName();
        long size = uploadFile.getSize();
        byte[] fileContent = uploadFile.getData();
        String md5 = Md5Utils.md5Hex((byte[])fileContent);
        Row record = ((SystemUploadFileDao)Aop.get(SystemUploadFileDao.class)).getFileBasicInfoByMd5(md5);
        if (record != null) {
            log.info("select table reuslt:{}", (Object)record.toMap());
            id = record.getLong("id");
            String url = this.getUrl(record.getStr("bucket_name"), record.getStr("target_name"));
            Kv kv = record.toKv();
            kv.remove((Object)"target_name");
            kv.remove((Object)"bucket_name");
            kv.set((Object)"url", (Object)url);
            kv.set((Object)"md5", (Object)md5);
            return new UploadResultVo(id, name, size, url, md5);
        }
        log.info("not found from cache table:{}", (Object)md5);
        String etag = null;
        try (S3Client client = AwsS3Utils.buildClient();){
            PutObjectResponse response = AwsS3Utils.upload(client, AwsS3Utils.bucketName, targetName, fileContent, suffix);
            etag = response.eTag();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        log.info("Uploaded with ETag: {}", (Object)etag);
        TableInput kv = TableInput.create().set((Object)"name", (Object)name).set((Object)"size", (Object)size).set((Object)"md5", (Object)md5).set((Object)"platform", (Object)"aws s3").set((Object)"region_name", (Object)AwsS3Utils.regionName).set((Object)"bucket_name", (Object)AwsS3Utils.bucketName).set((Object)"target_name", (Object)targetName).set((Object)"file_id", (Object)etag);
        TableResult save = ApiTable.save((String)"tio_boot_admin_system_upload_file", (TableInput)kv);
        String downloadUrl = this.getUrl(AwsS3Utils.bucketName, targetName);
        return new UploadResultVo((long)((Kv)save.getData()).getLong((Object)"id"), name, size, downloadUrl, md5);
    }

    @Override
    public String getUrl(String bucketName, String targetName) {
        return ((SystemUploadFileService)Aop.get(SystemUploadFileService.class)).getUrl(bucketName, targetName);
    }

    @Override
    public UploadResultVo getUrlById(String id) {
        return ((SystemUploadFileService)Aop.get(SystemUploadFileService.class)).getUrlById(id);
    }

    @Override
    public UploadResultVo getUrlById(long id) {
        return ((SystemUploadFileService)Aop.get(SystemUploadFileService.class)).getUrlById(id);
    }

    @Override
    public UploadResultVo getUrlByMd5(String md5) {
        return ((SystemUploadFileService)Aop.get(SystemUploadFileService.class)).getUrlByMd5(md5);
    }
}

