/*
 * Decompiled with CFR 0.152.
 */
package com.litongjava.tio.boot.admin.services;

import com.litongjava.db.activerecord.Db;
import com.litongjava.db.activerecord.Row;
import com.litongjava.jfinal.aop.Aop;
import com.litongjava.model.body.RespBodyVo;
import com.litongjava.model.validate.ValidateResult;
import com.litongjava.template.SqlTemplates;
import com.litongjava.tio.boot.admin.services.AppEmailService;
import com.litongjava.tio.boot.admin.vo.AppUser;
import com.litongjava.tio.boot.admin.vo.AppUserRegisterRequest;
import com.litongjava.tio.boot.admin.vo.UserResetPasswordRequest;
import com.litongjava.tio.boot.admin.vo.UserToken;
import com.litongjava.tio.boot.admin.vo.UserUpdatePasswordRequest;
import com.litongjava.tio.utils.environment.EnvUtils;
import com.litongjava.tio.utils.jwt.JwtUtils;
import com.litongjava.tio.utils.snowflake.SnowflakeIdUtils;
import com.litongjava.tio.utils.validator.EmailValidator;
import com.litongjava.tio.utils.validator.PasswordValidator;
import java.util.ArrayList;
import org.apache.commons.codec.digest.DigestUtils;

public class AppUserService {
    private static final String SQL_SELECT_USER = SqlTemplates.get((String)"app_users.findById");
    private static final String SQL_SELECT_PASSWORD = "SELECT id, password_salt, password_hash FROM app_users WHERE id = ? AND deleted = 0";

    public boolean registerUserByUserId(AppUserRegisterRequest req, String origin) {
        int lastIndex;
        String password = req.getPassword();
        String email = req.getEmail();
        String displayName = null;
        String username = req.getUsername();
        displayName = email != null ? ((lastIndex = email.lastIndexOf("@")) > 0 ? email.substring(0, lastIndex) : email) : username;
        int userType = req.getUserType();
        boolean exists = Db.exists((String)"app_users", (String)"username", (Object[])new Object[]{username});
        if (exists) {
            return false;
        }
        exists = Db.exists((String)"app_users", (String)"email", (Object[])new Object[]{email});
        if (exists) {
            return false;
        }
        String salt = String.valueOf(System.currentTimeMillis());
        String passwordHash = DigestUtils.sha256Hex((String)(password + salt));
        long id = SnowflakeIdUtils.id();
        String insertSql = "update app_users set display_name=?, email=?, username=?,password_salt=?, password_hash=?, user_type=?,of=? where id=?";
        int rows = Db.updateBySql((String)insertSql, (Object[])new Object[]{displayName, email, username, salt, passwordHash, userType, origin, id + ""});
        return rows > 0;
    }

    public boolean registerUser(String email, String username, String password, int userType, String orgin) {
        int lastIndex;
        boolean exists = Db.exists((String)"app_users", (String)"email", (Object[])new Object[]{email});
        if (exists) {
            return true;
        }
        String displayName = null;
        displayName = email != null ? ((lastIndex = email.lastIndexOf("@")) > 0 ? email.substring(0, lastIndex) : email) : username;
        String salt = String.valueOf(System.currentTimeMillis());
        String passwordHash = DigestUtils.sha256Hex((String)(password + salt));
        long id = SnowflakeIdUtils.id();
        String insertSql = "INSERT INTO app_users (id, display_name,email,username, password_salt, password_hash, user_type,of) VALUES (?,?,?,?,?,?,?,?)";
        int rows = Db.updateBySql((String)insertSql, (Object[])new Object[]{id + "", displayName, email, username, salt, passwordHash, userType, orgin});
        return rows > 0;
    }

    public AppUser getUserByEmail(String email) {
        String sql = "SELECT * FROM app_users WHERE email=? AND deleted=0";
        return (AppUser)Db.findFirst(AppUser.class, (String)sql, (Object[])new Object[]{email});
    }

    public AppUser getUserByUsername(String username) {
        String sql = "SELECT * FROM app_users WHERE username=? AND deleted=0";
        return (AppUser)Db.findFirst(AppUser.class, (String)sql, (Object[])new Object[]{username});
    }

    public AppUser getUserPasswordById(Long userId) {
        return (AppUser)Db.findFirst(AppUser.class, (String)SQL_SELECT_PASSWORD, (Object[])new Object[]{userId});
    }

    public AppUser getUserPasswordById(String userId) {
        return (AppUser)Db.findFirst(AppUser.class, (String)SQL_SELECT_PASSWORD, (Object[])new Object[]{userId});
    }

    public boolean verifyPassword(AppUser user, String password) {
        String salt = user.getPasswordSalt();
        String hash = DigestUtils.sha256Hex((String)(password + salt));
        return hash.equals(user.getPasswordHash());
    }

    public boolean verifyPassword(String email, String password) {
        AppUser appUser = this.getUserByEmail(email);
        return this.verifyPassword(appUser, password);
    }

    public boolean verifyPassword(Long userId, String password) {
        AppUser appUser = this.getUserPasswordById(userId);
        return this.verifyPassword(appUser, password);
    }

    public String createToken(String id, Long timeout) {
        String key = EnvUtils.getStr((String)"admin.secret.key");
        return JwtUtils.createTokenByUserId((String)key, (Object)id, (long)timeout);
    }

    public String createRefreshToken(String id) {
        String key = EnvUtils.getStr((String)"admin.secret.key");
        return JwtUtils.createTokenByUserId((String)key, (Object)id, (long)-1L);
    }

    public boolean logout(String userId) {
        return true;
    }

    public boolean remove(String userId) {
        String sql = "delete from app_users WHERE id=?";
        Db.delete((String)sql, (Object[])new Object[]{userId});
        return true;
    }

    public RespBodyVo resetPassword(UserResetPasswordRequest req) {
        String password;
        ArrayList<ValidateResult> validateResults = new ArrayList<ValidateResult>();
        boolean ok = true;
        String email = req.getEmail();
        String code = req.getCode();
        boolean validate = EmailValidator.validate((String)email);
        if (!validate) {
            ValidateResult validateResult = ValidateResult.by((String)"email", (String)("Failed to valiate email:" + email));
            validateResults.add(validateResult);
            ok = false;
        }
        if (!(validate = PasswordValidator.validate((String)(password = req.getPassword())))) {
            ValidateResult validateResult = ValidateResult.by((String)"password", (String)("Failed to valiate password:" + password));
            validateResults.add(validateResult);
            ok = false;
        }
        if (!ok) {
            return RespBodyVo.failData(validateResults);
        }
        boolean exists = Db.exists((String)"app_users", (String)"email", (Object[])new Object[]{email});
        if (exists) {
            ValidateResult validateResult = ValidateResult.by((String)"email", (String)("email already taken" + email));
            validateResults.add(validateResult);
        }
        if (!ok) {
            return RespBodyVo.failData(validateResults);
        }
        boolean verify = ((AppEmailService)Aop.get(AppEmailService.class)).verifyEmailCode(email, code);
        if (!verify) {
            return RespBodyVo.fail((String)"Failed to verify code");
        }
        String salt = String.valueOf(System.currentTimeMillis());
        String passwordHash = DigestUtils.sha256Hex((String)(password + salt));
        String updateSql = "update app_users set password_salt=?, password_hash=? where email=?";
        Db.updateBySql((String)updateSql, (Object[])new Object[]{salt, passwordHash, email});
        return RespBodyVo.ok();
    }

    public RespBodyVo createAnonymousUser(String origin) {
        long longId = SnowflakeIdUtils.id();
        String userId = longId + "";
        String insertSql = "INSERT INTO app_users (id,of,user_type) VALUES (?,?,0)";
        Db.updateBySql((String)insertSql, (Object[])new Object[]{userId, origin});
        Long timeout = EnvUtils.getLong((String)"app.token.timeout", (Long)604800L);
        Long tokenTimeout = System.currentTimeMillis() / 1000L + timeout;
        String token = this.createToken(userId, tokenTimeout);
        String refreshToken = this.createRefreshToken(userId);
        UserToken userToken = new UserToken(userId, token, tokenTimeout.intValue(), refreshToken, 0);
        return RespBodyVo.ok((Object)userToken);
    }

    public boolean exists(String userId) {
        return Db.exists((String)"app_users", (String)"id", (Object[])new Object[]{userId});
    }

    public String getUsernameById(String userId) {
        return Db.queryStr((String)"select username from app_users where id=?", (Object[])new Object[]{userId});
    }

    public boolean existsEmail(String email) {
        return Db.exists((String)"app_users", (String)"email", (Object[])new Object[]{email});
    }

    public boolean existsUsername(String email) {
        return Db.exists((String)"app_users", (String)"username", (Object[])new Object[]{email});
    }

    public AppUser getUserById(Long userId) {
        return (AppUser)Db.findFirst(AppUser.class, (String)SQL_SELECT_USER, (Object[])new Object[]{userId});
    }

    public AppUser getUserById(String userIdString) {
        return (AppUser)Db.findFirst(AppUser.class, (String)SQL_SELECT_USER, (Object[])new Object[]{userIdString});
    }

    public boolean updateById(String userIdString, Row row) {
        row.set("id", (Object)userIdString);
        return Db.update((String)"app_users", (Row)row);
    }

    public RespBodyVo updatePassword(String userIdString, UserUpdatePasswordRequest updatePasswordRequest) {
        String oldPassword = updatePasswordRequest.getOldPassword();
        String newPassword = updatePasswordRequest.getNewPassword();
        String sql = "select password_salt from app_users where id=?";
        String salt = Db.queryStr((String)sql, (Object[])new Object[]{userIdString});
        String passwordHash = DigestUtils.sha256Hex((String)(oldPassword + salt));
        sql = "select count(1) from app_users where id=? and password_hash=?";
        boolean exists = Db.existsBySql((String)sql, (Object[])new Object[]{userIdString, passwordHash});
        if (exists) {
            passwordHash = DigestUtils.sha256Hex((String)(newPassword + newPassword));
            sql = "update app_users set password_hash=? where id=?";
            int effectd = Db.updateBySql((String)sql, (Object[])new Object[]{passwordHash, userIdString});
            return RespBodyVo.ok((Object)effectd);
        }
        return RespBodyVo.fail();
    }
}

